/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.actions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.lang.java.actions.CreateEnumConstantAction;
import com.intellij.lang.java.actions.CreateFieldActionBase;
import com.intellij.lang.jvm.actions.CreateEnumConstantActionGroup;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.JvmActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/java/actions/CreateEnumConstantAction;", "Lcom/intellij/lang/java/actions/CreateFieldActionBase;", "target", "Lcom/intellij/psi/PsiClass;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "(Lcom/intellij/psi/PsiClass;Lcom/intellij/lang/jvm/actions/CreateFieldRequest;)V", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "getActionGroup", "Lcom/intellij/lang/jvm/actions/JvmActionGroup;", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.java.impl"})
public final class CreateEnumConstantAction
extends CreateFieldActionBase {
    @NotNull
    private final CreateFieldRequest request;

    @NotNull
    public JvmActionGroup getActionGroup() {
        return CreateEnumConstantActionGroup.INSTANCE;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("create.enum.constant.from.usage.text", this.getRequest().getFieldName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"QuickFixBundle.message(\"\u2026text\", request.fieldName)");
        return string;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        PsiExpressionList argumentList;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String name2 = this.getRequest().getFieldName();
        PsiClass targetClass = (PsiClass)this.getTarget();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project);
        if (psiElementFactory == null) {
            Intrinsics.throwNpe();
        }
        PsiElementFactory elementFactory = psiElementFactory;
        PsiEnumConstant psiEnumConstant = elementFactory.createEnumConstantFromText(name2, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiEnumConstant, (String)"elementFactory.createEnu\u2026stantFromText(name, null)");
        PsiEnumConstant enumConstant = psiEnumConstant;
        PsiElement psiElement = targetClass.add((PsiElement)enumConstant);
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiEnumConstant");
        }
        enumConstant = (PsiEnumConstant)psiElement;
        Object[] objectArray = targetClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"targetClass.constructors");
        PsiMethod psiMethod = (PsiMethod)ArraysKt.firstOrNull((Object[])objectArray);
        if (psiMethod == null) {
            return;
        }
        PsiMethod constructor = psiMethod;
        PsiParameterList psiParameterList = constructor.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"constructor.parameterList");
        Object[] parameters2 = psiParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"parameters");
        Object[] objectArray2 = parameters2;
        if (objectArray2.length == 0) {
            return;
        }
        String paramString2 = ArraysKt.joinToString$default((Object[])parameters2, (CharSequence)",", null, null, (int)0, null, (Function1)invoke.paramString.1.INSTANCE, (int)30, null);
        PsiElement psiElement2 = enumConstant.replace((PsiElement)elementFactory.createEnumConstantFromText(name2 + '(' + paramString2 + ')', null));
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiEnumConstant");
        }
        enumConstant = (PsiEnumConstant)psiElement2;
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)enumConstant);
        PsiExpressionList psiExpressionList = enumConstant.getArgumentList();
        if (psiExpressionList == null) {
            Intrinsics.throwNpe();
        }
        PsiExpressionList psiExpressionList2 = argumentList = psiExpressionList;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiExpressionList2, (String)"argumentList");
        for (PsiExpression expression2 : psiExpressionList2.getExpressions()) {
            builder.replaceElement((PsiElement)expression2, (Expression)new EmptyExpression());
        }
        PsiElement psiElement3 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)enumConstant));
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"forcePsiPostprocessAndRestoreElement(enumConstant)");
        enumConstant = (PsiEnumConstant)psiElement3;
        Template template = builder.buildTemplate();
        Editor editor2 = CreateFromUsageBaseFix.positionCursor(project, targetClass.getContainingFile(), (PsiElement)enumConstant);
        if (editor2 == null) {
            return;
        }
        Editor newEditor = editor2;
        TextRange range = enumConstant.getTextRange();
        Editor editor3 = newEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"newEditor");
        Document document = editor3.getDocument();
        TextRange textRange = range;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range");
        document.deleteString(textRange.getStartOffset(), range.getEndOffset());
        CreateFromUsageBaseFix.startTemplate(newEditor, template, project);
    }

    @Override
    @NotNull
    protected CreateFieldRequest getRequest() {
        return this.request;
    }

    public CreateEnumConstantAction(@NotNull PsiClass target, @NotNull CreateFieldRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        super(target, request);
        this.request = request;
    }
}

