/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.actions;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import com.intellij.ui.LayeredIcon;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/java/actions/FieldExpression;", "Lcom/intellij/codeInsight/template/Expression;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/psi/PsiClass;", "fieldName", "", "typeText", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiClass;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "myClassPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "myFactory", "Lcom/intellij/psi/PsiElementFactory;", "kotlin.jvm.PlatformType", "calculateLookupItems", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "context", "Lcom/intellij/codeInsight/template/ExpressionContext;", "(Lcom/intellij/codeInsight/template/ExpressionContext;)[Lcom/intellij/codeInsight/lookup/LookupElement;", "calculateQuickResult", "Lcom/intellij/codeInsight/template/Result;", "calculateResult", "Companion", "intellij.java.impl"})
public final class FieldExpression
extends Expression {
    private final SmartPsiElementPointer<PsiClass> myClassPointer;
    private final PsiElementFactory myFactory;
    private final String fieldName;
    private final Function0<String> typeText;
    private static final Icon newFieldIcon;
    public static final Companion Companion;

    @Nullable
    public Result calculateResult(@NotNull ExpressionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (Result)new TextResult(this.fieldName);
    }

    @Nullable
    public Result calculateQuickResult(@NotNull ExpressionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.calculateResult(context);
    }

    @NotNull
    public LookupElement[] calculateLookupItems(@NotNull ExpressionContext context) {
        LookupElement[] lookupElementArray;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiClass psiClass = (PsiClass)this.myClassPointer.getElement();
        if (psiClass == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)LookupElement.EMPTY_ARRAY, (String)"LookupElement.EMPTY_ARRAY");
            return LookupElement.EMPTY_ARRAY;
        }
        PsiClass psiClass2 = psiClass;
        PsiType userType = this.myFactory.createTypeFromText((String)this.typeText.invoke(), (PsiElement)psiClass2);
        LinkedHashSet result = new LinkedHashSet();
        if (psiClass2.findFieldByName(this.fieldName, false) == null) {
            Collection collection = result;
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)this.fieldName).withIcon(newFieldIcon);
            PsiType psiType = userType;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"userType");
            LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder.withTypeText(psiType.getPresentableText());
            collection.add(lookupElementBuilder2);
        }
        PsiClass psiClass3 = psiClass2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass3, (String)"psiClass");
        PsiField[] psiFieldArray = psiClass3.getFields();
        int n = psiFieldArray.length;
        for (int i = 0; i < n; ++i) {
            PsiField field;
            PsiField psiField = field = psiFieldArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiField, (String)"field");
            PsiType fieldType = psiField.getType();
            if (!Intrinsics.areEqual((Object)userType, (Object)fieldType)) continue;
            Collection collection = result;
            LookupElementBuilder lookupElementBuilder = JavaLookupElementBuilder.forField(field);
            PsiType psiType = fieldType;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"fieldType");
            LookupElementBuilder lookupElementBuilder3 = lookupElementBuilder.withTypeText(psiType.getPresentableText());
            collection.add(lookupElementBuilder3);
        }
        if (result.size() < 2) {
            lookupElementArray = LookupElement.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)LookupElement.EMPTY_ARRAY, (String)"LookupElement.EMPTY_ARRAY");
        } else {
            Collection $receiver$iv;
            Collection thisCollection$iv = $receiver$iv = (Collection)result;
            LookupElement[] lookupElementArray2 = thisCollection$iv.toArray(new LookupElement[0]);
            if (lookupElementArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            lookupElementArray = lookupElementArray2;
        }
        return lookupElementArray;
    }

    public FieldExpression(@NotNull Project project, @NotNull PsiClass target, @NotNull String fieldName, @NotNull Function0<String> typeText) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull(typeText, (String)"typeText");
        this.fieldName = fieldName;
        this.typeText = typeText;
        this.myClassPointer = PointersKt.createSmartPointer((PsiElement)target, project);
        this.myFactory = JavaPsiFacade.getElementFactory((Project)project);
    }

    static {
        Companion = new Companion(null);
        Icon icon = LayeredIcon.create((Icon)AllIcons.Nodes.Field, (Icon)AllIcons.Actions.New);
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"LayeredIcon.create(AllIc\u2026ld, AllIcons.Actions.New)");
        newFieldIcon = icon;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/lang/java/actions/FieldExpression$Companion;", "", "()V", "newFieldIcon", "Ljavax/swing/Icon;", "intellij.java.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

