/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.errorTreeView.EditableMessageElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.service.notification.NotificationMessageElement;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditableNotificationMessageElement
extends NotificationMessageElement
implements EditableMessageElement {
    @NotNull
    private final TreeCellEditor myRightTreeCellEditor;
    @NotNull
    private final Notification myNotification;
    @NotNull
    private final Map<String, String> disabledLinks;

    public EditableNotificationMessageElement(@NotNull Notification notification, @NotNull ErrorTreeElementKind kind2, @Nullable GroupingElement parent, String[] message2, @NotNull Navigatable navigatable, String exportText, String rendererTextPrefix) {
        if (notification == null) {
            EditableNotificationMessageElement.$$$reportNull$$$0(0);
        }
        if (kind2 == null) {
            EditableNotificationMessageElement.$$$reportNull$$$0(1);
        }
        if (navigatable == null) {
            EditableNotificationMessageElement.$$$reportNull$$$0(2);
        }
        super(kind2, parent, message2, navigatable, exportText, rendererTextPrefix);
        this.myNotification = notification;
        this.disabledLinks = ContainerUtil.newHashMap();
        this.myRightTreeCellEditor = new MyCellEditor();
    }

    public void addDisabledLink(@NotNull String url, @Nullable String text2) {
        if (url == null) {
            EditableNotificationMessageElement.$$$reportNull$$$0(3);
        }
        this.disabledLinks.put(url, text2);
    }

    @NotNull
    public TreeCellEditor getRightSelfEditor() {
        TreeCellEditor treeCellEditor = this.myRightTreeCellEditor;
        if (treeCellEditor == null) {
            EditableNotificationMessageElement.$$$reportNull$$$0(4);
        }
        return treeCellEditor;
    }

    public boolean startEditingOnMouseMove() {
        return true;
    }

    public static void disableLink(@NotNull HyperlinkEvent event) {
        if (event == null) {
            EditableNotificationMessageElement.$$$reportNull$$$0(5);
        }
        EditableNotificationMessageElement.disableLink(event, null);
    }

    private static void disableLink(@NotNull HyperlinkEvent event, @Nullable String linkText) {
        if (event == null) {
            EditableNotificationMessageElement.$$$reportNull$$$0(6);
        }
        if (event.getSource() instanceof MyJEditorPane) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (event == null) {
                    EditableNotificationMessageElement.$$$reportNull$$$0(8);
                }
                MyJEditorPane editorPane = (MyJEditorPane)event.getSource();
                editorPane.myElement.addDisabledLink(event.getDescription(), linkText);
                editorPane.myElement.updateStyle(editorPane, null, null, true, false);
            });
        }
    }

    @Override
    protected void updateStyle(@NotNull JEditorPane editorPane, @Nullable JTree tree, Object value2, boolean selected, boolean hasFocus) {
        if (editorPane == null) {
            EditableNotificationMessageElement.$$$reportNull$$$0(7);
        }
        super.updateStyle(editorPane, tree, value2, selected, hasFocus);
        HTMLDocument htmlDocument = (HTMLDocument)editorPane.getDocument();
        Style linkStyle = htmlDocument.getStyleSheet().getStyle("linkStyle");
        StyleConstants.setForeground(linkStyle, IdeTooltipManager.getInstance().getLinkForeground(false));
        StyleConstants.setItalic(linkStyle, true);
        HTMLDocument.Iterator iterator = htmlDocument.getIterator(HTML.Tag.A);
        while (iterator.isValid()) {
            boolean disabledLink = false;
            AttributeSet attributes = iterator.getAttributes();
            if (attributes instanceof SimpleAttributeSet) {
                Object attribute = attributes.getAttribute(HTML.Attribute.HREF);
                if (attribute instanceof String && this.disabledLinks.containsKey(attribute)) {
                    disabledLink = true;
                    ((SimpleAttributeSet)attributes).removeAttribute(HTML.Attribute.HREF);
                }
                if (attribute == null) {
                    disabledLink = true;
                }
            }
            if (!disabledLink) {
                htmlDocument.setCharacterAttributes(iterator.getStartOffset(), iterator.getEndOffset() - iterator.getStartOffset(), linkStyle, false);
            }
            iterator.next();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightSelfEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDisabledLink";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "disableLink";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateStyle";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$disableLink$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final JEditorPane editorComponent;
        @Nullable
        private JTree myTree;

        private MyCellEditor() {
            this.editorComponent = EditableNotificationMessageElement.this.installJep(new MyJEditorPane(EditableNotificationMessageElement.this));
            ActivatedHyperlinkListener hyperlinkListener = new ActivatedHyperlinkListener();
            this.editorComponent.addHyperlinkListener(hyperlinkListener);
            this.editorComponent.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    if (MyCellEditor.this.myTree == null) {
                        return;
                    }
                    TreePath path = MyCellEditor.this.myTree.getLeadSelectionPath();
                    if (path == null) {
                        return;
                    }
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.add(ActionManager.getInstance().getAction("EditSource"));
                    group.add(ActionManager.getInstance().getAction("$Copy"));
                    ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("CompilerMessagesPopup", (ActionGroup)group);
                    menu.getComponent().show(comp, x, y);
                }
            });
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row) {
            this.myTree = tree;
            EditableNotificationMessageElement.this.updateStyle(this.editorComponent, tree, value2, selected, false);
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        private class ActivatedHyperlinkListener
        implements HyperlinkListener {
            private ActivatedHyperlinkListener() {
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener notificationListener;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (notificationListener = EditableNotificationMessageElement.this.myNotification.getListener()) != null) {
                    notificationListener.hyperlinkUpdate(EditableNotificationMessageElement.this.myNotification, e);
                }
            }
        }
    }

    private static class MyJEditorPane
    extends JEditorPane {
        @NotNull
        private final EditableNotificationMessageElement myElement;

        MyJEditorPane(@NotNull EditableNotificationMessageElement element) {
            if (element == null) {
                MyJEditorPane.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement$MyJEditorPane", "<init>"));
        }
    }
}

