/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.roots.ui.configuration.artifacts.ManifestFilesInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactExternalDependenciesImporterImpl
implements ArtifactExternalDependenciesImporter {
    private final ManifestFilesInfo myManifestFiles = new ManifestFilesInfo();
    private final Map<Artifact, List<PackagingElement<?>>> myExternalDependencies = new HashMap();

    @Nullable
    public ManifestFileConfiguration getManifestFile(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context) {
        if (artifact == null) {
            ArtifactExternalDependenciesImporterImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ArtifactExternalDependenciesImporterImpl.$$$reportNull$$$0(1);
        }
        return this.myManifestFiles.getManifestFile(artifact.getRootElement(), artifact.getArtifactType(), context);
    }

    public List<PackagingElement<?>> getExternalDependenciesList(@NotNull Artifact artifact) {
        List<PackagingElement<?>> elements;
        if (artifact == null) {
            ArtifactExternalDependenciesImporterImpl.$$$reportNull$$$0(2);
        }
        if ((elements = this.myExternalDependencies.get(artifact)) == null) {
            elements = new ArrayList();
            this.myExternalDependencies.put(artifact, elements);
        }
        return elements;
    }

    public void applyChanges(ModifiableArtifactModel artifactModel, final PackagingElementResolvingContext context) {
        this.myManifestFiles.saveManifestFiles();
        final ArrayList elementsToInclude = new ArrayList();
        for (Artifact artifact : artifactModel.getArtifacts()) {
            ArtifactUtil.processPackagingElements(artifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, new PackagingElementProcessor<ArtifactPackagingElement>(){

                @Override
                public boolean process(@NotNull ArtifactPackagingElement artifactPackagingElement, @NotNull PackagingElementPath path) {
                    List elements;
                    if (artifactPackagingElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Artifact included = artifactPackagingElement.findArtifact(context);
                    CompositePackagingElement<?> parent = path.getLastParent();
                    if (parent != null && included != null && (elements = (List)ArtifactExternalDependenciesImporterImpl.this.myExternalDependencies.get(included)) != null) {
                        elementsToInclude.add(Pair.create(parent, (Object)elements));
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "artifactPackagingElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/ArtifactExternalDependenciesImporterImpl$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, context, false);
        }
        for (Pair pair : elementsToInclude) {
            ((CompositePackagingElement)pair.getFirst()).addOrFindChildren((Collection)pair.getSecond());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/ArtifactExternalDependenciesImporterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getManifestFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getExternalDependenciesList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

