/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AddSourceFolderListener;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483618)
public class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    public static final com.intellij.openapi.util.Key<Boolean> CREATE_EMPTY_DIRECTORIES = com.intellij.openapi.util.Key.create((String)"createEmptyDirectories");
    private static final com.intellij.openapi.util.Key<Set<AddSourceFolderListener>> LISTENERS_KEY = com.intellij.openapi.util.Key.create((String)"postponedSourceFolderCreationListeners");
    private static final Logger LOG = Logger.getInstance(ContentRootDataService.class);

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        Key key2 = ProjectKeys.CONTENT_ROOT;
        if (key2 == null) {
            ContentRootDataService.$$$reportNull$$$0(0);
        }
        return key2;
    }

    public void importData(@NotNull Collection<DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ContentRootDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(3);
        }
        ContentRootDataService.logUnitTest("Importing data. Data size is [" + toImport.size() + "]");
        if (toImport.isEmpty()) {
            return;
        }
        boolean isNewlyImportedProject = project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
        boolean forceDirectoriesCreation = false;
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(toImport.iterator().next(), (Key)ProjectKeys.PROJECT);
        if (projectDataNode != null) {
            forceDirectoriesCreation = projectDataNode.getUserData(CREATE_EMPTY_DIRECTORIES) == Boolean.TRUE;
        }
        THashSet modulesToExpand = ContainerUtil.newTroveSet();
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module2 = module = module != null ? module : modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData(modelsProvider, (Collection)entry.getValue(), module, forceDirectoriesCreation);
            if (!forceDirectoriesCreation && (!isNewlyImportedProject || projectData == null || !projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalProjectPath((Module)module)))) continue;
            modulesToExpand.add(module);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesToExpand.isEmpty()) {
            for (Module module : modulesToExpand) {
                VirtualFile[] roots;
                String productionModuleName = modelsProvider.getProductionModuleName(module);
                if (productionModuleName != null && modulesToExpand.contains(modelsProvider.findIdeModule(productionModuleName)) || (roots = modelsProvider.getModifiableRootModel(module).getContentRoots()).length <= 0) continue;
                VirtualFile virtualFile = roots[0];
                ExternalSystemUtil.invokeLater(project, ModalityState.NON_MODAL, () -> {
                    if (project == null) {
                        ContentRootDataService.$$$reportNull$$$0(23);
                    }
                    StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                        if (project == null) {
                            ContentRootDataService.$$$reportNull$$$0(24);
                        }
                        ProjectView projectView = ProjectView.getInstance((Project)project);
                        projectView.changeViewCB("ProjectPane", null).doWhenProcessed(() -> projectView.selectCB(null, virtualFile, false));
                    });
                });
            }
        }
    }

    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Collection<? extends DataNode<ContentRootData>> data, @NotNull Module module, boolean forceDirectoriesCreation) {
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(4);
        }
        if (data == null) {
            ContentRootDataService.$$$reportNull$$$0(5);
        }
        if (module == null) {
            ContentRootDataService.$$$reportNull$$$0(6);
        }
        ContentRootDataService.logUnitTest("Import data for module [" + module.getName() + "], data size [" + data.size() + "]");
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        ContentEntry[] contentEntries = modifiableRootModel.getContentEntries();
        HashMap contentEntriesMap = ContainerUtilRt.newHashMap();
        for (ContentEntry contentEntry : contentEntries) {
            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
        }
        boolean createEmptyContentRootDirectories = forceDirectoriesCreation;
        if (!forceDirectoriesCreation && !data.isEmpty()) {
            ProjectSystemId projectSystemId = ((ContentRootData)data.iterator().next().getData()).getOwner();
            AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)module.getProject(), (ProjectSystemId)projectSystemId);
            String string = ExternalSystemModulePropertyManager.getInstance((Module)module).getRootProjectPath();
            if (string != null) {
                ExternalProjectSettings projectSettings = externalSystemSettings.getLinkedProjectSettings(string);
                createEmptyContentRootDirectories = projectSettings != null && projectSettings.isCreateEmptyContentRootDirectories();
            }
        }
        ContentRootDataService.cleanPostponedSourceFolderCreationListeners(module);
        THashSet importedContentEntries = ContainerUtil.newIdentityTroveSet();
        for (DataNode<ContentRootData> dataNode : data) {
            ContentRootData contentRoot = (ContentRootData)dataNode.getData();
            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(modifiableRootModel, contentRoot.getRootPath());
            if (!importedContentEntries.contains(contentEntry)) {
                contentEntry.clearSourceFolders();
                importedContentEntries.add(contentEntry);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Importing content root '%s' for module '%s'", contentRoot.getRootPath(), module.getName()));
            }
            for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
                JpsModuleSourceRootType<?> type2 = ContentRootDataService.getJavaSourceRootType(externalSrcType);
                if (type2 == null) continue;
                for (ContentRootData.SourceRoot path : contentRoot.getPaths(externalSrcType)) {
                    ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module, type2, externalSrcType.isGenerated(), createEmptyContentRootDirectories);
                }
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, path, module.getName(), module.getProject());
            }
            contentEntriesMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : contentEntriesMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    private static void cleanPostponedSourceFolderCreationListeners(@NotNull Module module) {
        if (module == null) {
            ContentRootDataService.$$$reportNull$$$0(7);
        }
        Set listeners = (Set)module.getUserData(LISTENERS_KEY);
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        if (listeners != null) {
            for (AddSourceFolderListener listener : listeners) {
                vfManager.removeVirtualFileListener((VirtualFileListener)listener);
            }
            listeners.clear();
        }
    }

    private static void saveSourceFolderCreationListener(@NotNull Module module, @NotNull AddSourceFolderListener listener) {
        HashSet<AddSourceFolderListener> listeners;
        if (module == null) {
            ContentRootDataService.$$$reportNull$$$0(8);
        }
        if (listener == null) {
            ContentRootDataService.$$$reportNull$$$0(9);
        }
        if ((listeners = (HashSet<AddSourceFolderListener>)module.getUserData(LISTENERS_KEY)) == null) {
            listeners = new HashSet<AddSourceFolderListener>();
            module.putUserData(LISTENERS_KEY, listeners);
        }
        listeners.add(listener);
    }

    @Nullable
    private static JpsModuleSourceRootType<?> getJavaSourceRootType(ExternalSystemSourceType type2) {
        switch (type2) {
            case SOURCE: {
                return JavaSourceRootType.SOURCE;
            }
            case TEST: {
                return JavaSourceRootType.TEST_SOURCE;
            }
            case EXCLUDED: {
                return null;
            }
            case SOURCE_GENERATED: {
                return JavaSourceRootType.SOURCE;
            }
            case TEST_GENERATED: {
                return JavaSourceRootType.TEST_SOURCE;
            }
            case RESOURCE: {
                return JavaResourceRootType.RESOURCE;
            }
            case TEST_RESOURCE: {
                return JavaResourceRootType.TEST_RESOURCE;
            }
        }
        return null;
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model, @NotNull String path) {
        ContentEntry[] entries;
        if (model == null) {
            ContentRootDataService.$$$reportNull$$$0(10);
        }
        if (path == null) {
            ContentRootDataService.$$$reportNull$$$0(11);
        }
        for (ContentEntry entry : entries = model.getContentEntries()) {
            VirtualFile file = entry.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(path)) continue;
            ContentEntry contentEntry = entry;
            if (contentEntry == null) {
                ContentRootDataService.$$$reportNull$$$0(12);
            }
            return contentEntry;
        }
        ContentEntry contentEntry = model.addContentEntry(VfsUtilCore.pathToUrl((String)path));
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(13);
        }
        return contentEntry;
    }

    private static void createSourceRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull Module module, @NotNull JpsModuleSourceRootType<?> sourceRootType, boolean generated, boolean createEmptyContentRootDirectories) {
        JavaSourceRootProperties properties;
        SourceFolder[] folders;
        if (entry == null) {
            ContentRootDataService.$$$reportNull$$$0(14);
        }
        if (root == null) {
            ContentRootDataService.$$$reportNull$$$0(15);
        }
        if (module == null) {
            ContentRootDataService.$$$reportNull$$$0(16);
        }
        if (sourceRootType == null) {
            ContentRootDataService.$$$reportNull$$$0(17);
        }
        ContentRootDataService.logUnitTest("create source root if absent entry.url=[" + entry.getUrl() + "] root.path=[" + root.getPath() + "] generated=[" + generated + "] createEmptyContentRootDirectories=[" + createEmptyContentRootDirectories + "]");
        for (SourceFolder folder : folders = entry.getSourceFolders()) {
            VirtualFile file = folder.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(root.getPath())) continue;
            JpsModuleSourceRootType folderRootType = folder.getRootType();
            if (JavaSourceRootType.SOURCE.equals(folderRootType) || sourceRootType.equals((Object)folderRootType)) {
                return;
            }
            if (JavaSourceRootType.TEST_SOURCE.equals(folderRootType) && JavaResourceRootType.TEST_RESOURCE.equals(sourceRootType)) {
                return;
            }
            entry.removeSourceFolder(folder);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing %s for content root '%s' of module '%s'", root, entry.getUrl(), module.getName()));
        }
        if (!(createEmptyContentRootDirectories || generated || FileUtil.exists((String)root.getPath()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Source folder [" + root.getPath() + "] does not exist and will not be created, will add when dir is created");
            }
            ContentRootDataService.logUnitTest("Adding source folder listener to watch [" + root.getPath() + "] for creation in project [hashCode=" + module.getProject().hashCode() + "]");
            AddSourceFolderListener listener = new AddSourceFolderListener(root, module, sourceRootType);
            ContentRootDataService.saveSourceFolderCreationListener(module, listener);
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)listener, (Disposable)module);
            return;
        }
        SourceFolder sourceFolder = entry.addSourceFolder(VfsUtilCore.pathToUrl((String)root.getPath()), sourceRootType);
        if (!StringUtil.isEmpty((String)root.getPackagePrefix())) {
            sourceFolder.setPackagePrefix(root.getPackagePrefix());
        }
        if (generated && (properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null) {
            properties.setForGeneratedSources(true);
        }
        if (createEmptyContentRootDirectories && !FileUtil.exists((String)root.getPath())) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                if (root == null) {
                    ContentRootDataService.$$$reportNull$$$0(22);
                }
                try {
                    VfsUtil.createDirectoryIfMissing((String)root.getPath());
                }
                catch (IOException e) {
                    LOG.warn(String.format("Unable to create directory for the path: %s", root.getPath()), (Throwable)e);
                }
            });
        }
    }

    private static void logUnitTest(String message2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info(message2);
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull Project project) {
        if (entry == null) {
            ContentRootDataService.$$$reportNull$$$0(18);
        }
        if (root == null) {
            ContentRootDataService.$$$reportNull$$$0(19);
        }
        if (moduleName == null) {
            ContentRootDataService.$$$reportNull$$$0(20);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(21);
        }
        String rootPath = root.getPath();
        for (VirtualFile file : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(rootPath)) continue;
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        }
        entry.addExcludeFolder(VfsUtilCore.pathToUrl((String)rootPath));
        if (!Registry.is((String)"ide.hide.excluded.files")) {
            ChangeListManager.getInstance((Project)project).addDirectoryToIgnoreImplicitly(rootPath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateContentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cleanPostponedSourceFolderCreationListeners";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveSourceFolderCreationListener";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateContentRoot";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRootIfAbsent";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedRootIfAbsent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSourceRootIfAbsent$3";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$importData$2";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

