/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.BeforeRunTaskImporter;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationHandlerKt;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "()V", "apply", "", "module", "Lcom/intellij/openapi/module/Module;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "project", "Lcom/intellij/openapi/project/Project;", "isTrue", "", "", "intellij.platform.externalSystem.impl"})
public final class RunConfigurationHandler
implements ConfigurationHandler {
    private final boolean isTrue(@Nullable Object $receiver) {
        return $receiver != null && $receiver instanceof Boolean && (Boolean)$receiver != false;
    }

    public void apply(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
    }

    public void apply(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Object element$iv$iv;
        Object $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Object runCfgMap = configuration.find("runConfigurations");
        if (!(runCfgMap instanceof List)) {
            return;
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)project);
        Iterable iterable = (Iterable)runCfgMap;
        void var9_7 = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof Map)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new Comparator<T>(this){
            final /* synthetic */ RunConfigurationHandler this$0;
            {
                this.this$0 = runConfigurationHandler;
            }

            public final int compare(T a, T b) {
                Map it;
                Map map = it = (Map)b;
                String string = "defaults";
                RunConfigurationHandler runConfigurationHandler = this.this$0;
                V v = map.get(string);
                it = (Map)a;
                Comparable comparable = Boolean.valueOf(RunConfigurationHandler.access$isTrue(runConfigurationHandler, v));
                map = it;
                string = "defaults";
                runConfigurationHandler = this.this$0;
                v = map.get(string);
                Boolean bl = RunConfigurationHandler.access$isTrue(runConfigurationHandler, v);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)bl);
            }
        };
        for (Map cfg : CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)destination$iv$iv)) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings;
            String typeName;
            String string;
            $receiver$iv$iv = cfg;
            Object v = $receiver$iv$iv.get(destination$iv$iv = "name");
            if (!(v instanceof String)) {
                v = null;
            }
            if ((string = (String)v) == null) {
                string = "";
            }
            String name2 = string;
            destination$iv$iv = cfg;
            String $i$f$sortedByDescending = "type";
            Object v2 = destination$iv$iv.get($i$f$sortedByDescending);
            if (!(v2 instanceof String)) {
                v2 = null;
            }
            if ((typeName = (String)v2) == null) {
                RunConfigurationHandlerKt.getLOG().warn("Missing type for run configuration: '" + name2 + "', skipping");
                continue;
            }
            RunConfigurationImporter importer = RunConfigurationHandlerKt.access$handlerForType(typeName);
            if (importer == null) {
                RunConfigurationHandlerKt.getLOG().warn("No importers for run configuration '" + name2 + "' with type '" + typeName + "', skipping");
                continue;
            }
            RunConfigurationHandler runConfigurationHandler = this;
            element$iv$iv = cfg;
            Object $i$f$filterIsInstanceTo = "defaults";
            Object v3 = element$iv$iv.get($i$f$filterIsInstanceTo);
            boolean isDefaults = runConfigurationHandler.isTrue(v3);
            if (isDefaults) {
                ConfigurationFactory configurationFactory = importer.getConfigurationFactory();
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"importer.configurationFactory");
                runnerAndConfigurationSettings = runManager.getConfigurationTemplate(configurationFactory);
            } else {
                ConfigurationFactory configurationFactory = importer.getConfigurationFactory();
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"importer.configurationFactory");
                runnerAndConfigurationSettings = runManager.createConfiguration(name2, configurationFactory);
            }
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            try {
                Object v4;
                Map map = cfg;
                if (map == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                }
                importer.process(project, runnerAndConfigurationSettings2.getConfiguration(), map, modelsProvider);
                if (!isDefaults) {
                    runManager.addConfiguration(runnerAndConfigurationSettings2);
                }
                if (!((v4 = cfg.get("beforeRun")) instanceof List)) {
                    v4 = null;
                }
                List list = (List)v4;
                if (list == null) continue;
                Object it = $i$f$filterIsInstanceTo = list;
                List tasksList = runnerAndConfigurationSettings2.getConfiguration().getBeforeRunTasks();
                for (Map beforeRunConfig : CollectionsKt.filterIsInstance((Iterable)((Iterable)it), Map.class)) {
                    String typeName2;
                    String string2;
                    Map map2 = beforeRunConfig;
                    Object v5 = map2.get(string2 = "type");
                    if (!(v5 instanceof String)) {
                        v5 = null;
                    }
                    if ((String)v5 == null) {
                        continue;
                    }
                    BeforeRunTaskImporter beforeRunTaskImporter = RunConfigurationHandlerKt.access$importerForType(typeName2);
                    if (beforeRunTaskImporter == null) continue;
                    Map importer2 = map2 = beforeRunTaskImporter;
                    Map map3 = beforeRunConfig;
                    if (map3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, *>");
                    }
                    tasksList = importer2.process(project, modelsProvider, runnerAndConfigurationSettings2.getConfiguration(), tasksList, TypeIntrinsics.asMutableMap((Object)map3));
                }
                runManager.setBeforeRunTasks(runnerAndConfigurationSettings2.getConfiguration(), tasksList);
            }
            catch (Exception e) {
                RunConfigurationHandlerKt.getLOG().warn("Error occurred when importing run configuration " + name2 + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static final /* synthetic */ boolean access$isTrue(RunConfigurationHandler $this, @Nullable Object $receiver) {
        return $this.isTrue($receiver);
    }
}

