/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiNameHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;

public class BasePackageParameterFactory
extends ProjectTemplateParameterFactory {
    private static final Condition<PsiPackage> PACKAGE_CONDITION = aPackage -> PsiNameHelper.getInstance((Project)aPackage.getProject()).isQualifiedName(aPackage.getQualifiedName()) && Character.isLowerCase(aPackage.getName().charAt(0));

    public String getParameterId() {
        return "IJ_BASE_PACKAGE";
    }

    public WizardInputField createField(final String defaultValue) {
        return new WizardInputField<JTextField>("IJ_BASE_PACKAGE", defaultValue){
            private final JTextField myField;
            {
                super(x0, x1);
                this.myField = new JTextField(PropertiesComponent.getInstance().getValue("IJ_BASE_PACKAGE", defaultValue));
            }

            public String getLabel() {
                return "Base \u001bpackage:";
            }

            public JTextField getComponent() {
                return this.myField;
            }

            public String getValue() {
                return this.myField.getText();
            }

            public Map<String, String> getValues() {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put(this.getId(), this.getValue());
                map.put("IJ_BASE_PACKAGE_DIR", this.getValue().replace('.', '/'));
                map.put("IJ_BASE_PACKAGE_PREFIX", StringUtil.isEmpty((String)this.getValue()) ? "" : this.getValue() + ".");
                return map;
            }

            public boolean validate() throws ConfigurationException {
                String value2 = this.getValue();
                if (!StringUtil.isEmpty((String)value2) && !PsiNameHelperImpl.getInstance().isQualifiedName(value2)) {
                    throw new ConfigurationException(value2 + " is not a valid package name");
                }
                PropertiesComponent.getInstance().setValue("IJ_BASE_PACKAGE", value2);
                return true;
            }
        };
    }

    public String detectParameterValue(Project project) {
        PsiPackage root = JavaPsiFacade.getInstance((Project)project).findPackage("");
        if (root == null) {
            return null;
        }
        String name2 = BasePackageParameterFactory.getBasePackage(root, GlobalSearchScope.projectScope((Project)project)).getQualifiedName();
        return StringUtil.isEmpty((String)name2) ? null : name2;
    }

    private static PsiPackage getBasePackage(PsiPackage pack, GlobalSearchScope scope) {
        List subPackages = ContainerUtil.filter((Object[])pack.getSubPackages(scope), PACKAGE_CONDITION);
        return subPackages.size() == 1 ? BasePackageParameterFactory.getBasePackage((PsiPackage)subPackages.get(0), scope) : pack;
    }
}

