/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.RenameablePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingElementPath {
    public static final PackagingElementPath EMPTY = new PackagingElementPath(null, null);
    private final PackagingElementPath myParentPath;
    private final PackagingElement<?> myLastElement;

    private PackagingElementPath(PackagingElementPath parentPath, PackagingElement<?> lastElement) {
        this.myParentPath = parentPath;
        this.myLastElement = lastElement;
    }

    public PackagingElementPath appendComplex(ComplexPackagingElement<?> element) {
        return new PackagingElementPath(this, (PackagingElement<?>)element);
    }

    public PackagingElementPath appendComposite(CompositePackagingElement<?> element) {
        return new PackagingElementPath(this, (PackagingElement<?>)element);
    }

    @NotNull
    public String getPathString() {
        String string = this.getPathString("/");
        if (string == null) {
            PackagingElementPath.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getPathString(String separator) {
        String string = this.getPathStringFrom(separator, null);
        if (string == null) {
            PackagingElementPath.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPathStringFrom(String separator, @Nullable CompositePackagingElement<?> ancestor) {
        List<CompositePackagingElement<?>> parents2 = this.getParentsFrom(ancestor);
        String string = ContainerUtil.reverse(parents2).stream().map(RenameablePackagingElement::getName).collect(Collectors.joining("/"));
        if (string == null) {
            PackagingElementPath.$$$reportNull$$$0(2);
        }
        return string;
    }

    public List<CompositePackagingElement<?>> getParents() {
        return this.getParentsFrom(null);
    }

    public List<CompositePackagingElement<?>> getParentsFrom(@Nullable CompositePackagingElement<?> ancestor) {
        SmartList result = new SmartList();
        PackagingElementPath path = this;
        while (path != EMPTY && path.myLastElement != ancestor) {
            if (path.myLastElement instanceof CompositePackagingElement) {
                result.add((CompositePackagingElement)path.myLastElement);
            }
            path = path.myParentPath;
        }
        return result;
    }

    public List<PackagingElement<?>> getAllElements() {
        SmartList result = new SmartList();
        PackagingElementPath path = this;
        while (path != EMPTY) {
            result.add(path.myLastElement);
            path = path.myParentPath;
        }
        return result;
    }

    @Nullable
    public CompositePackagingElement<?> getLastParent() {
        PackagingElementPath path = this;
        while (path != EMPTY) {
            if (path.myLastElement instanceof CompositePackagingElement) {
                return (CompositePackagingElement)path.myLastElement;
            }
            path = path.myParentPath;
        }
        return null;
    }

    @Nullable
    public Artifact findLastArtifact(PackagingElementResolvingContext context) {
        PackagingElementPath path = this;
        while (path != EMPTY) {
            PackagingElement<?> element = path.myLastElement;
            if (element instanceof ArtifactPackagingElement) {
                return ((ArtifactPackagingElement)element).findArtifact(context);
            }
            path = path.myParentPath;
        }
        return null;
    }

    public static PackagingElementPath createPath(@NotNull List<? extends PackagingElement<?>> elements) {
        if (elements == null) {
            PackagingElementPath.$$$reportNull$$$0(3);
        }
        PackagingElementPath path = EMPTY;
        for (PackagingElement<?> element : elements) {
            path = new PackagingElementPath(path, element);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/PackagingElementPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathStringFrom";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/PackagingElementPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

