/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.Tag;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.ui.ArtifactElementPresentation;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactPackagingElement
extends ComplexPackagingElement<ArtifactPackagingElementState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.elements.ArtifactPackagingElement");
    private final Project myProject;
    private ArtifactPointer myArtifactPointer;
    @NonNls
    public static final String ARTIFACT_NAME_ATTRIBUTE = "artifact-name";

    public ArtifactPackagingElement(@NotNull Project project) {
        if (project == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(0);
        }
        super((PackagingElementType)ArtifactElementType.ARTIFACT_ELEMENT_TYPE);
        this.myProject = project;
    }

    public ArtifactPackagingElement(@NotNull Project project, @NotNull ArtifactPointer artifactPointer) {
        if (project == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(1);
        }
        if (artifactPointer == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(2);
        }
        this(project);
        this.myArtifactPointer = artifactPointer;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        Artifact artifact;
        if (context == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(3);
        }
        if (artifactType == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(4);
        }
        if ((artifact = this.findArtifact(context)) != null) {
            ArtifactType type2 = artifact.getArtifactType();
            List substitution = type2.getSubstitution(artifact, context, artifactType);
            if (substitution != null) {
                return substitution;
            }
            ArrayList<CompositePackagingElement> elements = new ArrayList<CompositePackagingElement>();
            CompositePackagingElement rootElement = artifact.getRootElement();
            if (rootElement instanceof ArtifactRootElement) {
                elements.addAll(rootElement.getChildren());
            } else {
                elements.add(rootElement);
            }
            return elements;
        }
        return null;
    }

    @NotNull
    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        Artifact artifact;
        if (resolvingContext == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(5);
        }
        if (creator == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(6);
        }
        if (generationContext == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(7);
        }
        if (artifactType == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(8);
        }
        if ((artifact = this.findArtifact(resolvingContext)) != null) {
            if (artifact.getArtifactType().getSubstitution(artifact, resolvingContext, artifactType) != null) {
                List list = super.computeAntInstructions(resolvingContext, creator, generationContext, artifactType);
                if (list == null) {
                    ArtifactPackagingElement.$$$reportNull$$$0(9);
                }
                return list;
            }
            String outputPath = BuildProperties.propertyRef((String)generationContext.getArtifactOutputProperty(artifact));
            List<Tag> list = Collections.singletonList(creator.createDirectoryContentCopyInstruction(outputPath));
            if (list == null) {
                ArtifactPackagingElement.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(12);
        }
        DelegatedPackagingElementPresentation delegatedPackagingElementPresentation = new DelegatedPackagingElementPresentation(new ArtifactElementPresentation(this.myArtifactPointer, context));
        if (delegatedPackagingElementPresentation == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(13);
        }
        return delegatedPackagingElementPresentation;
    }

    public ArtifactPackagingElementState getState() {
        ArtifactPackagingElementState state = new ArtifactPackagingElementState();
        if (this.myArtifactPointer != null) {
            state.setArtifactName(this.myArtifactPointer.getArtifactName());
        }
        return state;
    }

    public void loadState(@NotNull ArtifactPackagingElementState state) {
        String name2;
        if (state == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(14);
        }
        this.myArtifactPointer = (name2 = state.getArtifactName()) != null ? ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(name2) : null;
    }

    public String toString() {
        return "artifact:" + this.getArtifactName();
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(15);
        }
        return element instanceof ArtifactPackagingElement && this.myArtifactPointer != null && this.myArtifactPointer.equals(((ArtifactPackagingElement)element).myArtifactPointer);
    }

    @Nullable
    public Artifact findArtifact(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(16);
        }
        return this.myArtifactPointer != null ? this.myArtifactPointer.findArtifact(context.getArtifactModel()) : null;
    }

    @Nullable
    public String getArtifactName() {
        return this.myArtifactPointer != null ? this.myArtifactPointer.getArtifactName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPointer";
                break;
            }
            case 3: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ArtifactPackagingElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ArtifactPackagingElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAntInstructions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeAntInstructions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findArtifact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ArtifactPackagingElementState {
        private String myArtifactName;

        @Attribute(value="artifact-name")
        public String getArtifactName() {
            return this.myArtifactName;
        }

        public void setArtifactName(String artifactName) {
            this.myArtifactName = artifactName;
        }
    }
}

