/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntryDependencyInfo;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementOverriddenMethodsInfo;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementParseInfo;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementPropertyInfo;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementVisitor;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementColorsAware;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSectionRuleAwareSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRearranger
implements Rearranger<JavaElementArrangementEntry>,
ArrangementSectionRuleAwareSettings,
ArrangementStandardSettingsAware,
ArrangementColorsAware {
    @NotNull
    private static final Set<ArrangementSettingsToken> SUPPORTED_TYPES;
    @NotNull
    private static final Set<ArrangementSettingsToken> SUPPORTED_MODIFIERS;
    @NotNull
    private static final List<ArrangementSettingsToken> SUPPORTED_ORDERS;
    @NotNull
    private static final ArrangementSettingsToken NO_TYPE;
    @NotNull
    private static final Map<ArrangementSettingsToken, Set<ArrangementSettingsToken>> MODIFIERS_BY_TYPE;
    @NotNull
    private static final Collection<Set<ArrangementSettingsToken>> MUTEXES;
    private static final Set<ArrangementSettingsToken> TYPES_WITH_DISABLED_ORDER;
    private static final Set<ArrangementSettingsToken> TYPES_WITH_DISABLED_NAME_MATCH;
    private static final Map<ArrangementSettingsToken, List<ArrangementSettingsToken>> GROUPING_RULES;
    private static final StdArrangementRuleAliasToken VISIBILITY;
    private static final StdArrangementExtendableSettings DEFAULT_SETTINGS;
    private static final DefaultArrangementSettingsSerializer SETTINGS_SERIALIZER;

    @NotNull
    private static Set<ArrangementSettingsToken> concat(@NotNull Set<ArrangementSettingsToken> base, ArrangementSettingsToken ... modifiers) {
        if (base == null) {
            JavaRearranger.$$$reportNull$$$0(0);
        }
        HashSet result = ContainerUtilRt.newHashSet(base);
        Collections.addAll(result, modifiers);
        HashSet hashSet = result;
        if (hashSet == null) {
            JavaRearranger.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static void setupGettersAndSetters(@NotNull JavaArrangementParseInfo info) {
        if (info == null) {
            JavaRearranger.$$$reportNull$$$0(2);
        }
        Collection<JavaArrangementPropertyInfo> properties = info.getProperties();
        for (JavaArrangementPropertyInfo propertyInfo : properties) {
            JavaElementArrangementEntry getter = propertyInfo.getGetter();
            List<JavaElementArrangementEntry> setters = propertyInfo.getSetters();
            if (getter == null) continue;
            JavaElementArrangementEntry previous = getter;
            for (JavaElementArrangementEntry setter : setters) {
                setter.addDependency((ArrangementEntry)previous);
                previous = setter;
            }
        }
    }

    private static void setupUtilityMethods(@NotNull JavaArrangementParseInfo info, @NotNull ArrangementSettingsToken orderType) {
        if (info == null) {
            JavaRearranger.$$$reportNull$$$0(3);
        }
        if (orderType == null) {
            JavaRearranger.$$$reportNull$$$0(4);
        }
        if (StdArrangementTokens.Order.DEPTH_FIRST.equals((Object)orderType)) {
            for (ArrangementEntryDependencyInfo rootInfo : info.getMethodDependencyRoots()) {
                JavaRearranger.setupDepthFirstDependency(rootInfo);
            }
        } else if (StdArrangementTokens.Order.BREADTH_FIRST.equals((Object)orderType)) {
            for (ArrangementEntryDependencyInfo rootInfo : info.getMethodDependencyRoots()) {
                JavaRearranger.setupBreadthFirstDependency(rootInfo);
            }
        } else assert (false) : orderType;
    }

    private static void setupDepthFirstDependency(@NotNull ArrangementEntryDependencyInfo info) {
        if (info == null) {
            JavaRearranger.$$$reportNull$$$0(5);
        }
        for (ArrangementEntryDependencyInfo dependencyInfo : info.getDependentEntriesInfos()) {
            JavaRearranger.setupDepthFirstDependency(dependencyInfo);
            JavaElementArrangementEntry dependentEntry = dependencyInfo.getAnchorEntry();
            if (dependentEntry.getDependencies() != null) continue;
            dependentEntry.addDependency((ArrangementEntry)info.getAnchorEntry());
        }
    }

    private static void setupBreadthFirstDependency(@NotNull ArrangementEntryDependencyInfo info) {
        if (info == null) {
            JavaRearranger.$$$reportNull$$$0(6);
        }
        ArrayDeque<ArrangementEntryDependencyInfo> toProcess = new ArrayDeque<ArrangementEntryDependencyInfo>();
        toProcess.add(info);
        JavaElementArrangementEntry prev = info.getAnchorEntry();
        while (!toProcess.isEmpty()) {
            ArrangementEntryDependencyInfo current = (ArrangementEntryDependencyInfo)toProcess.removeFirst();
            for (ArrangementEntryDependencyInfo dependencyInfo : current.getDependentEntriesInfos()) {
                JavaElementArrangementEntry dependencyMethod = dependencyInfo.getAnchorEntry();
                if (dependencyMethod.getDependencies() == null) {
                    dependencyMethod.addDependency((ArrangementEntry)prev);
                    prev = dependencyMethod;
                }
                toProcess.addLast(dependencyInfo);
            }
        }
    }

    private static void setupOverriddenMethods(JavaArrangementParseInfo info) {
        for (JavaArrangementOverriddenMethodsInfo methodsInfo : info.getOverriddenMethods()) {
            JavaElementArrangementEntry previous = null;
            for (JavaElementArrangementEntry entry : methodsInfo.getMethodEntries()) {
                if (previous != null && entry.getDependencies() == null) {
                    entry.addDependency((ArrangementEntry)previous);
                }
                previous = entry;
            }
        }
    }

    @Nullable
    public Pair<JavaElementArrangementEntry, List<JavaElementArrangementEntry>> parseWithNew(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull PsiElement element, @NotNull ArrangementSettings settings) {
        if (root == null) {
            JavaRearranger.$$$reportNull$$$0(7);
        }
        if (ranges == null) {
            JavaRearranger.$$$reportNull$$$0(8);
        }
        if (element == null) {
            JavaRearranger.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            JavaRearranger.$$$reportNull$$$0(10);
        }
        JavaArrangementParseInfo existingEntriesInfo = new JavaArrangementParseInfo();
        root.accept((PsiElementVisitor)new JavaArrangementVisitor(existingEntriesInfo, document, ranges, settings));
        JavaArrangementParseInfo newEntryInfo = new JavaArrangementParseInfo();
        element.accept((PsiElementVisitor)new JavaArrangementVisitor(newEntryInfo, document, Collections.singleton(element.getTextRange()), settings));
        if (newEntryInfo.getEntries().size() != 1) {
            return null;
        }
        return Pair.create((Object)((Object)newEntryInfo.getEntries().get(0)), existingEntriesInfo.getEntries());
    }

    @NotNull
    public List<JavaElementArrangementEntry> parse(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            JavaRearranger.$$$reportNull$$$0(11);
        }
        if (ranges == null) {
            JavaRearranger.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            JavaRearranger.$$$reportNull$$$0(13);
        }
        JavaArrangementParseInfo parseInfo = new JavaArrangementParseInfo();
        root.accept((PsiElementVisitor)new JavaArrangementVisitor(parseInfo, document, ranges, settings));
        for (ArrangementGroupingRule rule : settings.getGroupings()) {
            if (StdArrangementTokens.Grouping.GETTERS_AND_SETTERS.equals((Object)rule.getGroupingType())) {
                JavaRearranger.setupGettersAndSetters(parseInfo);
                continue;
            }
            if (StdArrangementTokens.Grouping.DEPENDENT_METHODS.equals((Object)rule.getGroupingType())) {
                JavaRearranger.setupUtilityMethods(parseInfo, rule.getOrderType());
                continue;
            }
            if (!StdArrangementTokens.Grouping.OVERRIDDEN_METHODS.equals((Object)rule.getGroupingType())) continue;
            JavaRearranger.setupOverriddenMethods(parseInfo);
        }
        List<ArrangementEntryDependencyInfo> fieldDependencyRoots = parseInfo.getFieldDependencyRoots();
        if (!fieldDependencyRoots.isEmpty()) {
            this.setupFieldInitializationDependencies(fieldDependencyRoots, settings, parseInfo);
        }
        List<JavaElementArrangementEntry> list = parseInfo.getEntries();
        if (list == null) {
            JavaRearranger.$$$reportNull$$$0(14);
        }
        return list;
    }

    public void setupFieldInitializationDependencies(@NotNull List<? extends ArrangementEntryDependencyInfo> fieldDependencyRoots, @NotNull ArrangementSettings settings, @NotNull JavaArrangementParseInfo parseInfo) {
        if (fieldDependencyRoots == null) {
            JavaRearranger.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            JavaRearranger.$$$reportNull$$$0(16);
        }
        if (parseInfo == null) {
            JavaRearranger.$$$reportNull$$$0(17);
        }
        Collection<JavaElementArrangementEntry> fields = parseInfo.getFields();
        List arrangedFields = ArrangementEngine.arrange(fields, (List)settings.getSections(), (List)settings.getRulesSortedByPriority(), null);
        for (ArrangementEntryDependencyInfo arrangementEntryDependencyInfo : fieldDependencyRoots) {
            JavaElementArrangementEntry anchorField = arrangementEntryDependencyInfo.getAnchorEntry();
            int anchorEntryIndex = arrangedFields.indexOf((Object)anchorField);
            for (ArrangementEntryDependencyInfo fieldInInitializerInfo : arrangementEntryDependencyInfo.getDependentEntriesInfos()) {
                JavaElementArrangementEntry fieldInInitializer = fieldInInitializerInfo.getAnchorEntry();
                if (arrangedFields.indexOf((Object)fieldInInitializer) <= anchorEntryIndex) continue;
                anchorField.addDependency((ArrangementEntry)fieldInInitializer);
            }
        }
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable JavaElementArrangementEntry parent, @Nullable JavaElementArrangementEntry previous, @NotNull JavaElementArrangementEntry target) {
        if (settings == null) {
            JavaRearranger.$$$reportNull$$$0(18);
        }
        if (target == null) {
            JavaRearranger.$$$reportNull$$$0(19);
        }
        if (previous == null) {
            return -1;
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        if (StdArrangementTokens.EntryType.FIELD.equals((Object)target.getType())) {
            if (parent != null && parent.getType() == StdArrangementTokens.EntryType.INTERFACE) {
                return commonSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE;
            }
            if (StdArrangementTokens.EntryType.INIT_BLOCK.equals((Object)previous.getType())) {
                return javaSettings.BLANK_LINES_AROUND_INITIALIZER;
            }
            return commonSettings.BLANK_LINES_AROUND_FIELD;
        }
        if (StdArrangementTokens.EntryType.METHOD.equals((Object)target.getType())) {
            if (parent != null && parent.getType() == StdArrangementTokens.EntryType.INTERFACE) {
                return commonSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE;
            }
            return commonSettings.BLANK_LINES_AROUND_METHOD;
        }
        if (StdArrangementTokens.EntryType.CLASS.equals((Object)target.getType())) {
            return commonSettings.BLANK_LINES_AROUND_CLASS;
        }
        if (StdArrangementTokens.EntryType.INIT_BLOCK.equals((Object)target.getType())) {
            return javaSettings.BLANK_LINES_AROUND_INITIALIZER;
        }
        return -1;
    }

    @NotNull
    public ArrangementSettingsSerializer getSerializer() {
        DefaultArrangementSettingsSerializer defaultArrangementSettingsSerializer = SETTINGS_SERIALIZER;
        if (defaultArrangementSettingsSerializer == null) {
            JavaRearranger.$$$reportNull$$$0(20);
        }
        return defaultArrangementSettingsSerializer;
    }

    @NotNull
    public StdArrangementSettings getDefaultSettings() {
        StdArrangementExtendableSettings stdArrangementExtendableSettings = DEFAULT_SETTINGS;
        if (stdArrangementExtendableSettings == null) {
            JavaRearranger.$$$reportNull$$$0(21);
        }
        return stdArrangementExtendableSettings;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return ContainerUtilRt.newArrayList((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.GETTERS_AND_SETTERS), new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.OVERRIDDEN_METHODS, new ArrangementSettingsToken[]{StdArrangementTokens.Order.BY_NAME, StdArrangementTokens.Order.KEEP}), new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.DEPENDENT_METHODS, new ArrangementSettingsToken[]{StdArrangementTokens.Order.BREADTH_FIRST, StdArrangementTokens.Order.DEPTH_FIRST})});
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return ContainerUtilRt.newArrayList((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, SUPPORTED_TYPES), new CompositeArrangementSettingsToken(StdArrangementTokens.General.MODIFIER, SUPPORTED_MODIFIERS), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME), new CompositeArrangementSettingsToken(StdArrangementTokens.General.ORDER, new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME})});
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            JavaRearranger.$$$reportNull$$$0(22);
        }
        if (SUPPORTED_TYPES.contains(token)) {
            return true;
        }
        ArrangementSettingsToken type2 = null;
        if (current != null) {
            type2 = ArrangementUtil.parseType((ArrangementMatchCondition)current);
        }
        if (type2 == null) {
            type2 = NO_TYPE;
        }
        if (SUPPORTED_ORDERS.contains(token)) {
            return !TYPES_WITH_DISABLED_ORDER.contains(type2);
        }
        if (StdArrangementTokens.Regexp.NAME.equals((Object)token)) {
            return !TYPES_WITH_DISABLED_NAME_MATCH.contains(type2);
        }
        Set<ArrangementSettingsToken> modifiers = MODIFIERS_BY_TYPE.get(type2);
        return modifiers != null && modifiers.contains(token);
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition2) throws IllegalArgumentException {
        if (condition2 == null) {
            JavaRearranger.$$$reportNull$$$0(23);
        }
        throw new IllegalArgumentException("Can't build a matcher for condition " + condition2);
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        Collection<Set<ArrangementSettingsToken>> collection = MUTEXES;
        if (collection == null) {
            JavaRearranger.$$$reportNull$$$0(24);
        }
        return collection;
    }

    private static void and(@NotNull List<? super StdArrangementMatchRule> matchRules, ArrangementSettingsToken ... conditions) {
        if (matchRules == null) {
            JavaRearranger.$$$reportNull$$$0(25);
        }
        if (conditions == null) {
            JavaRearranger.$$$reportNull$$$0(26);
        }
        if (conditions.length == 1) {
            matchRules.add((StdArrangementMatchRule)new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition(conditions[0]))));
            return;
        }
        ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
        for (ArrangementSettingsToken condition2 : conditions) {
            composite.addOperand((ArrangementMatchCondition)new ArrangementAtomMatchCondition(condition2));
        }
        matchRules.add((StdArrangementMatchRule)new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)composite)));
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull EditorColorsScheme scheme, @NotNull ArrangementSettingsToken token, boolean selected) {
        if (scheme == null) {
            JavaRearranger.$$$reportNull$$$0(27);
        }
        if (token == null) {
            JavaRearranger.$$$reportNull$$$0(28);
        }
        if (selected) {
            TextAttributes attributes = new TextAttributes();
            attributes.setForegroundColor(scheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
            attributes.setBackgroundColor(scheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
            return attributes;
        }
        if (SUPPORTED_TYPES.contains(token)) {
            return JavaRearranger.getAttributes(scheme, JavaHighlightingColors.KEYWORD);
        }
        if (SUPPORTED_MODIFIERS.contains(token)) {
            JavaRearranger.getAttributes(scheme, JavaHighlightingColors.KEYWORD);
        }
        return null;
    }

    @Nullable
    private static TextAttributes getAttributes(@NotNull EditorColorsScheme scheme, TextAttributesKey ... keys) {
        if (scheme == null) {
            JavaRearranger.$$$reportNull$$$0(29);
        }
        if (keys == null) {
            JavaRearranger.$$$reportNull$$$0(30);
        }
        TextAttributes result = null;
        for (TextAttributesKey key2 : keys) {
            Color currentBackgroundColor;
            Color currentForegroundColor;
            TextAttributes attributes = scheme.getAttributes(key2).clone();
            if (attributes == null) continue;
            if (result == null) {
                result = attributes;
            }
            if ((currentForegroundColor = result.getForegroundColor()) == null) {
                result.setForegroundColor(attributes.getForegroundColor());
            }
            if ((currentBackgroundColor = result.getBackgroundColor()) == null) {
                result.setBackgroundColor(attributes.getBackgroundColor());
            }
            if (result.getForegroundColor() == null || result.getBackgroundColor() == null) continue;
            return result;
        }
        if (result != null && result.getForegroundColor() == null) {
            return null;
        }
        if (result != null && result.getBackgroundColor() == null) {
            result.setBackgroundColor(scheme.getDefaultBackground());
        }
        return result;
    }

    @Nullable
    public Color getBorderColor(@NotNull EditorColorsScheme scheme, boolean selected) {
        if (scheme == null) {
            JavaRearranger.$$$reportNull$$$0(31);
        }
        return null;
    }

    static {
        ArrangementSettingsToken[] visibility;
        SUPPORTED_TYPES = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.EntryType.INIT_BLOCK, StdArrangementTokens.EntryType.CONSTRUCTOR, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.EntryType.CLASS, StdArrangementTokens.EntryType.INTERFACE, StdArrangementTokens.EntryType.ENUM, StdArrangementTokens.Modifier.GETTER, StdArrangementTokens.Modifier.SETTER, StdArrangementTokens.Modifier.OVERRIDDEN});
        SUPPORTED_MODIFIERS = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE, StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.FINAL, StdArrangementTokens.Modifier.ABSTRACT, StdArrangementTokens.Modifier.SYNCHRONIZED, StdArrangementTokens.Modifier.TRANSIENT, StdArrangementTokens.Modifier.VOLATILE});
        SUPPORTED_ORDERS = ContainerUtilRt.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME});
        NO_TYPE = new ArrangementSettingsToken("NO_TYPE", "NO_TYPE");
        MODIFIERS_BY_TYPE = ContainerUtilRt.newHashMap();
        MUTEXES = ContainerUtilRt.newArrayList();
        TYPES_WITH_DISABLED_ORDER = ContainerUtil.newHashSet();
        TYPES_WITH_DISABLED_NAME_MATCH = ContainerUtil.newHashSet();
        HashSet visibilityModifiers = ContainerUtilRt.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE});
        MUTEXES.add(visibilityModifiers);
        MUTEXES.add(SUPPORTED_TYPES);
        Set<ArrangementSettingsToken> commonModifiers = JavaRearranger.concat(visibilityModifiers, StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.FINAL);
        MODIFIERS_BY_TYPE.put(NO_TYPE, commonModifiers);
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.ENUM, visibilityModifiers);
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.INTERFACE, visibilityModifiers);
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.CLASS, JavaRearranger.concat(commonModifiers, StdArrangementTokens.Modifier.ABSTRACT));
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.METHOD, JavaRearranger.concat(commonModifiers, StdArrangementTokens.Modifier.SYNCHRONIZED, StdArrangementTokens.Modifier.ABSTRACT));
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.CONSTRUCTOR, JavaRearranger.concat(commonModifiers, StdArrangementTokens.Modifier.SYNCHRONIZED));
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.FIELD, JavaRearranger.concat(commonModifiers, StdArrangementTokens.Modifier.TRANSIENT, StdArrangementTokens.Modifier.VOLATILE));
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.Modifier.GETTER, ContainerUtilRt.newHashSet());
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.Modifier.SETTER, ContainerUtilRt.newHashSet());
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.Modifier.OVERRIDDEN, ContainerUtilRt.newHashSet());
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.INIT_BLOCK, ContainerUtilRt.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.STATIC}));
        TYPES_WITH_DISABLED_ORDER.add(StdArrangementTokens.EntryType.INIT_BLOCK);
        TYPES_WITH_DISABLED_NAME_MATCH.add(StdArrangementTokens.EntryType.INIT_BLOCK);
        GROUPING_RULES = ContainerUtilRt.newLinkedHashMap();
        GROUPING_RULES.put(StdArrangementTokens.Grouping.GETTERS_AND_SETTERS, Collections.emptyList());
        GROUPING_RULES.put(StdArrangementTokens.Grouping.OVERRIDDEN_METHODS, ContainerUtilRt.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Order.BY_NAME, StdArrangementTokens.Order.KEEP}));
        GROUPING_RULES.put(StdArrangementTokens.Grouping.DEPENDENT_METHODS, ContainerUtilRt.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Order.BREADTH_FIRST, StdArrangementTokens.Order.DEPTH_FIRST}));
        VISIBILITY = new StdArrangementRuleAliasToken("visibility");
        ArrayList visibility2 = new ArrayList();
        JavaRearranger.and(visibility2, StdArrangementTokens.Modifier.PUBLIC);
        JavaRearranger.and(visibility2, StdArrangementTokens.Modifier.PACKAGE_PRIVATE);
        JavaRearranger.and(visibility2, StdArrangementTokens.Modifier.PROTECTED);
        JavaRearranger.and(visibility2, StdArrangementTokens.Modifier.PRIVATE);
        VISIBILITY.setDefinitionRules(visibility2);
        ArrayList groupingRules = ContainerUtilRt.newArrayList((Object[])new ArrangementGroupingRule[]{new ArrangementGroupingRule(StdArrangementTokens.Grouping.GETTERS_AND_SETTERS)});
        ArrayList matchRules = ContainerUtilRt.newArrayList();
        for (ArrangementSettingsToken modifier : visibility = new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE}) {
            JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.FINAL, modifier);
        }
        for (ArrangementSettingsToken modifier : visibility) {
            JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.Modifier.STATIC, modifier);
        }
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.INIT_BLOCK, StdArrangementTokens.Modifier.STATIC);
        for (ArrangementSettingsToken modifier : visibility) {
            JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.Modifier.FINAL, modifier);
        }
        for (ArrangementSettingsToken modifier : visibility) {
            JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD, modifier);
        }
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.INIT_BLOCK);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.CONSTRUCTOR);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.Modifier.STATIC);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.METHOD);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.ENUM);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.INTERFACE);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.CLASS, StdArrangementTokens.Modifier.STATIC);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.CLASS);
        ArrayList aliasTokens = ContainerUtilRt.newArrayList();
        aliasTokens.add(VISIBILITY);
        DEFAULT_SETTINGS = StdArrangementExtendableSettings.createByMatchRules((List)groupingRules, (List)matchRules, (Collection)aliasTokens);
        SETTINGS_SERIALIZER = new DefaultArrangementSettingsSerializer((StdArrangementSettings)DEFAULT_SETTINGS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 14: 
            case 20: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 14: 
            case 20: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 14: 
            case 20: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/JavaRearranger";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderType";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldDependencyRoots";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parseInfo";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchRules";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/JavaRearranger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSettings";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutexes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 1: 
            case 14: 
            case 20: 
            case 21: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupGettersAndSetters";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupUtilityMethods";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupDepthFirstDependency";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupBreadthFirstDependency";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseWithNew";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupFieldInitializationDependencies";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBlankLines";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getBorderColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 14: 
            case 20: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

