/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.java.BlockFactory;
import com.intellij.psi.formatter.java.ChildrenBlocksBuilder;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;

public class ArrayInitializerBlocksBuilder {
    private final ASTNode myNode;
    private final BlockFactory myBlockFactory;
    private final CommonCodeStyleSettings mySettings;

    public ArrayInitializerBlocksBuilder(ASTNode node, BlockFactory blockFactory) {
        this.myNode = node;
        this.myBlockFactory = blockFactory;
        this.mySettings = this.myBlockFactory.getSettings();
    }

    public List<Block> buildBlocks() {
        Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.ARRAY_INITIALIZER_WRAP), (boolean)false);
        Alignment alignment = this.mySettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION ? Alignment.createAlignment() : null;
        ChildrenBlocksBuilder.Config config = new ChildrenBlocksBuilder.Config().setDefaultIndent(Indent.getContinuationWithoutFirstIndent()).setIndent(JavaTokenType.RBRACE, Indent.getNoneIndent()).setIndent(JavaTokenType.LBRACE, Indent.getNoneIndent()).setDefaultWrap(wrap).setNoWrap(JavaTokenType.COMMA).setNoWrap(JavaTokenType.RBRACE).setNoWrap(JavaTokenType.LBRACE).setDefaultAlignment(alignment).setNoAlignment(JavaTokenType.COMMA).setNoAlignment(JavaTokenType.LBRACE).setNoAlignmentIf(JavaTokenType.RBRACE, (Condition<ASTNode>)((Condition)node -> {
            PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)node.getPsi());
            if (prev == null) {
                return false;
            }
            return prev.getNode().getElementType() != JavaTokenType.COMMA;
        }));
        return config.createBuilder().buildNodeChildBlocks(this.myNode, this.myBlockFactory);
    }
}

