/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightClassReferenceExpression;
import com.intellij.psi.impl.light.LightClassTypeReference;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightKeyword;
import com.intellij.psi.impl.light.LightPackageReference;
import com.intellij.psi.impl.light.LightPackageReferenceExpression;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementFactoryImpl
extends PsiJavaParserFacadeImpl
implements PsiElementFactory {
    private final ConcurrentMap<LanguageLevel, PsiClass> myArrayClasses = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<GlobalSearchScope, PsiClassType> myCachedObjectType = ContainerUtil.newConcurrentMap();
    private static final JavaParserUtil.ParserWrapper CATCH_SECTION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseCatchBlock(builder);
        }
    };

    public PsiElementFactoryImpl(PsiManagerEx manager) {
        super((PsiManager)manager);
        manager.registerRunnableToRunOnChange(() -> this.myCachedObjectType.clear());
    }

    @NotNull
    public PsiClass getArrayClass(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(0);
        }
        PsiClass psiClass = this.myArrayClasses.computeIfAbsent(languageLevel, this::createArrayClass);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(1);
        }
        return psiClass;
    }

    private PsiClass createArrayClass(LanguageLevel level) {
        String text2 = level.isAtLeast(LanguageLevel.JDK_1_5) ? "public class __Array__<T> {\n public final int length;\n public T[] clone() {}\n}" : "public class __Array__{\n public final int length;\n public Object clone() {}\n}";
        PsiClass psiClass = ((PsiExtensibleClass)this.createClassFromText(text2, null)).getOwnInnerClasses().get(0);
        PsiElementFactoryImpl.ensureNonWritable(psiClass);
        PsiFile file = psiClass.getContainingFile();
        file.clearCaches();
        PsiUtil.FILE_LANGUAGE_LEVEL_KEY.set((UserDataHolder)file, (Object)level);
        return psiClass;
    }

    private static void ensureNonWritable(PsiClass arrayClass) {
        try {
            arrayClass.getContainingFile().getViewProvider().getVirtualFile().setWritable(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public PsiClassType getArrayClassType(@NotNull PsiType componentType, @NotNull LanguageLevel languageLevel) {
        if (componentType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(2);
        }
        if (languageLevel == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(3);
        }
        PsiClass arrayClass = this.getArrayClass(languageLevel);
        PsiTypeParameter[] typeParameters = arrayClass.getTypeParameters();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (typeParameters.length == 1) {
            substitutor = substitutor.put(typeParameters[0], componentType);
        }
        PsiClassType psiClassType = this.createType(arrayClass, substitutor);
        if (psiClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(4);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor) {
        if (resolve == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(5);
        }
        if (substitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(6);
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve, substitutor);
        if (psiImmediateClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(7);
        }
        return psiImmediateClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel) {
        if (resolve == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(8);
        }
        if (substitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(9);
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve, substitutor, languageLevel);
        if (psiImmediateClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(10);
        }
        return psiImmediateClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations2) {
        if (resolve == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(11);
        }
        if (substitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(12);
        }
        if (annotations2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(13);
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve, substitutor, languageLevel, annotations2);
        if (psiImmediateClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(14);
        }
        return psiImmediateClassType;
    }

    @NotNull
    public PsiClass createClass(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(15);
        }
        PsiClass psiClass = this.createClassInner("class", name2);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(16);
        }
        return psiClass;
    }

    @NotNull
    public PsiClass createInterface(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(17);
        }
        PsiClass psiClass = this.createClassInner("interface", name2);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(18);
        }
        return psiClass;
    }

    @NotNull
    public PsiClass createEnum(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(19);
        }
        PsiClass psiClass = this.createClassInner("enum", name2);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(20);
        }
        return psiClass;
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull @NonNls String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(21);
        }
        PsiClass psiClass = this.createClassInner("@interface", name2);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(22);
        }
        return psiClass;
    }

    private PsiClass createClassInner(@NonNls String type2, @NonNls String name2) {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name2);
        PsiJavaFile aFile = this.createDummyJavaFile("public " + type2 + " " + name2 + " { }");
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length != 1) {
            throw new IncorrectOperationException("Incorrect " + type2 + " name \"" + name2 + "\".");
        }
        return classes2[0];
    }

    @NotNull
    public PsiTypeElement createTypeElement(@NotNull PsiType psiType) {
        if (psiType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(23);
        }
        LightTypeElement element = new LightTypeElement(this.myManager, psiType);
        CodeEditUtil.setNodeGenerated((ASTNode)element.getNode(), (boolean)true);
        LightTypeElement lightTypeElement = element;
        if (lightTypeElement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(24);
        }
        return lightTypeElement;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByType(@NotNull PsiClassType type2) {
        if (type2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(25);
        }
        if (type2 instanceof PsiClassReferenceType) {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ((PsiClassReferenceType)type2).getReference();
            if (psiJavaCodeReferenceElement == null) {
                PsiElementFactoryImpl.$$$reportNull$$$0(26);
            }
            return psiJavaCodeReferenceElement;
        }
        LightClassTypeReference lightClassTypeReference = new LightClassTypeReference(this.myManager, type2);
        if (lightClassTypeReference == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(27);
        }
        return lightClassTypeReference;
    }

    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        PsiTypeParameterList parameterList = this.createMethodFromText("void foo()", null).getTypeParameterList();
        assert (parameterList != null);
        PsiTypeParameterList psiTypeParameterList = parameterList;
        if (psiTypeParameterList == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(28);
        }
        return psiTypeParameterList;
    }

    @NotNull
    public PsiTypeParameter createTypeParameter(String name2, PsiClassType[] superTypes) {
        PsiTypeParameter psiTypeParameter;
        StringBuilder builder = new StringBuilder();
        builder.append("public <").append(name2);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type2 : superTypes) {
                if (type2.equalsToText("java.lang.Object")) continue;
                builder.append(type2.getCanonicalText(true)).append('&');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            psiTypeParameter = this.createMethodFromText(builder.toString(), null).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder.toString());
        }
        if (psiTypeParameter == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(29);
        }
        return psiTypeParameter;
    }

    @NotNull
    public PsiField createField(@NotNull String name2, @NotNull PsiType type2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(30);
        }
        if (type2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(31);
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name2);
        if (PsiType.NULL.equals((Object)type2)) {
            throw new IncorrectOperationException("Cannot create field with type \"null\".");
        }
        String text2 = "class _Dummy_ { private " + GenericsUtil.getVariableTypeByExpressionType((PsiType)type2).getCanonicalText(true) + " " + name2 + "; }";
        PsiJavaFile aFile = this.createDummyJavaFile(text2);
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException("Class was not created " + text2);
        }
        PsiClass psiClass = classes2[0];
        PsiField[] fields = psiClass.getFields();
        if (fields.length < 1) {
            throw new IncorrectOperationException("Field was not created " + text2);
        }
        PsiField field = fields[0];
        field = (PsiField)JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)field);
        PsiField psiField = (PsiField)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)field);
        if (psiField == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(32);
        }
        return psiField;
    }

    @NotNull
    public PsiMethod createMethod(@NotNull String name2, PsiType returnType) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(33);
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name2);
        if (PsiType.NULL.equals((Object)returnType)) {
            throw new IncorrectOperationException("Cannot create method with type \"null\".");
        }
        String canonicalText = GenericsUtil.getVariableTypeByExpressionType((PsiType)returnType).getCanonicalText(true);
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { public " + canonicalText + " " + name2 + "() {\n} }");
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException("Class was not created. Method name: " + name2 + "; return type: " + canonicalText);
        }
        PsiMethod[] methods = classes2[0].getMethods();
        if (methods.length < 1) {
            throw new IncorrectOperationException("Method was not created. Method name: " + name2 + "; return type: " + canonicalText);
        }
        PsiMethod method = methods[0];
        method = (PsiMethod)JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)method);
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(34);
        }
        return psiMethod;
    }

    @NotNull
    public PsiMethod createMethod(@NotNull @NonNls String name2, PsiType returnType, PsiElement context) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(35);
        }
        PsiMethod psiMethod = this.createMethodFromText("public " + GenericsUtil.getVariableTypeByExpressionType((PsiType)returnType).getCanonicalText(true) + " " + name2 + "() {}", context);
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(36);
        }
        return psiMethod;
    }

    @NotNull
    public PsiMethod createConstructor() {
        PsiMethod psiMethod = this.createConstructor("_Dummy_");
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(37);
        }
        return psiMethod;
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name2) {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(38);
        }
        PsiJavaFile aFile = this.createDummyJavaFile("class " + name2 + " { public " + name2 + "() {} }");
        PsiMethod method = aFile.getClasses()[0].getMethods()[0];
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(39);
        }
        return psiMethod;
    }

    public PsiMethod createConstructor(@NotNull @NonNls String name2, PsiElement context) {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(40);
        }
        return this.createMethodFromText(name2 + "() {}", context);
    }

    @NotNull
    public PsiClassInitializer createClassInitializer() throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { {} }");
        PsiClassInitializer classInitializer = aFile.getClasses()[0].getInitializers()[0];
        PsiClassInitializer psiClassInitializer = (PsiClassInitializer)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)classInitializer);
        if (psiClassInitializer == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(41);
        }
        return psiClassInitializer;
    }

    @NotNull
    public PsiParameter createParameter(@NotNull String name2, @NotNull PsiType type2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(42);
        }
        if (type2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(43);
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name2);
        if (PsiType.NULL.equals((Object)type2)) {
            throw new IncorrectOperationException("Cannot create parameter with type \"null\".");
        }
        String text2 = type2.getCanonicalText(true) + " " + name2;
        PsiParameter parameter2 = this.createParameterFromText(text2, null);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myManager.getProject());
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter2, (String)"final", (boolean)JavaCodeStyleSettingsFacade.getInstance((Project)this.myManager.getProject()).isGenerateFinalParameters());
        GeneratedMarkerVisitor.markGenerated((PsiElement)parameter2);
        parameter2 = (PsiParameter)JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)parameter2);
        PsiParameter psiParameter = (PsiParameter)codeStyleManager.reformat((PsiElement)parameter2);
        if (psiParameter == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(44);
        }
        return psiParameter;
    }

    public PsiParameter createParameter(@NotNull @NonNls String name2, PsiType type2, PsiElement context) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(45);
        }
        PsiMethod psiMethod = this.createMethodFromText("void f(" + type2.getCanonicalText(true) + " " + name2 + ") {}", context);
        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
        return parameters2[0];
    }

    @NotNull
    public PsiCodeBlock createCodeBlock() {
        PsiCodeBlock block = this.createCodeBlockFromText("{}", null);
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)block);
        if (psiCodeBlock == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(46);
        }
        return psiCodeBlock;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(47);
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(aClass, aClass instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : this.createRawSubstitutor((PsiTypeParameterListOwner)aClass));
        if (psiImmediateClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(48);
        }
        return psiImmediateClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiJavaCodeReferenceElement classReference2) {
        if (classReference2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(49);
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(classReference2, null);
        if (psiClassReferenceType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(50);
        }
        return psiClassReferenceType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameter2) {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(51);
        }
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        assert (typeParameters.length == 1) : aClass;
        PsiClassType psiClassType = this.createType(aClass, PsiSubstitutor.EMPTY.put(typeParameters[0], parameter2));
        if (psiClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(52);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters2) {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(53);
        }
        PsiClassType psiClassType = this.createType(aClass, PsiSubstitutor.EMPTY.putAll(aClass, parameters2));
        if (psiClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(54);
        }
        return psiClassType;
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner2) {
        if (owner2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(55);
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)owner2)) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter2, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(substitutorMap);
        if (psiSubstitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(56);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiSubstitutor baseSubstitutor, @NotNull PsiTypeParameter[] typeParameters) {
        if (baseSubstitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(57);
        }
        if (typeParameters == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(58);
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter2 : typeParameters) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter2, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(substitutorMap).putAll(baseSubstitutor);
        if (psiSubstitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(59);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiElement createDummyHolder(@NotNull String text2, @NotNull IElementType type2, @Nullable PsiElement context) {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(60);
        }
        if (type2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(61);
        }
        DummyHolder result = DummyHolderFactory.createHolder((PsiManager)this.myManager, (PsiElement)context);
        FileElement holder = result.getTreeElement();
        Language language = type2.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        assert (parserDefinition != null) : "No parser definition for language " + language;
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, (ASTNode)holder, lexer, language, (CharSequence)text2);
        ASTNode node = parserDefinition.createParser(project).parse(type2, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiElement psi = node.getPsi();
        assert (psi != null) : text2;
        PsiElement psiElement = psi;
        if (psiElement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(62);
        }
        return psiElement;
    }

    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map) {
        if (map == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(63);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(map);
        if (psiSubstitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(64);
        }
        return psiSubstitutor;
    }

    @Nullable
    public PsiPrimitiveType createPrimitiveType(@NotNull String text2) {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(65);
        }
        return PsiJavaParserFacadeImpl.getPrimitiveType(text2);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName) {
        if (qName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(66);
        }
        PsiClassType psiClassType = this.createTypeByFQClassName(qName, GlobalSearchScope.allScope((Project)this.myManager.getProject()));
        if (psiClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(67);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(68);
        }
        if (resolveScope == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(69);
        }
        if ("java.lang.Object".equals(qName)) {
            Object cachedObjectType = (PsiClassType)this.myCachedObjectType.get(resolveScope);
            if (cachedObjectType != null) {
                PsiClassType psiClassType = cachedObjectType;
                if (psiClassType == null) {
                    PsiElementFactoryImpl.$$$reportNull$$$0(70);
                }
                return psiClassType;
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass("java.lang.Object", resolveScope);
            if (aClass != null) {
                cachedObjectType = new PsiImmediateClassType(aClass, PsiSubstitutor.EMPTY);
                Object object = cachedObjectType = (PsiClassType)ConcurrencyUtil.cacheOrGet(this.myCachedObjectType, (Object)resolveScope, (Object)cachedObjectType);
                if (object == null) {
                    PsiElementFactoryImpl.$$$reportNull$$$0(71);
                }
                return object;
            }
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(this.createReferenceElementByFQClassName(qName, resolveScope), null);
        if (psiClassReferenceType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(72);
        }
        return psiClassReferenceType;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createClassReferenceElement(@NotNull PsiClass aClass) {
        String text2;
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(73);
        }
        if ((text2 = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName()) == null) {
            throw new IncorrectOperationException("Invalid class: " + aClass);
        }
        LightClassReference lightClassReference = new LightClassReference(this.myManager, text2, aClass);
        if (lightClassReference == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(74);
        }
        return lightClassReference;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(75);
        }
        if (resolveScope == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(76);
        }
        String shortName = PsiNameHelper.getShortClassName((String)qName);
        LightClassReference lightClassReference = new LightClassReference(this.myManager, shortName, qName, resolveScope);
        if (lightClassReference == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(77);
        }
        return lightClassReference;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createFQClassNameReferenceElement(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(78);
        }
        if (resolveScope == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(79);
        }
        LightClassReference lightClassReference = new LightClassReference(this.myManager, qName, qName, resolveScope);
        if (lightClassReference == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(80);
        }
        return lightClassReference;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(81);
        }
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference(this.myManager, aPackage);
        if (lightPackageReference == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(82);
        }
        return lightPackageReference;
    }

    @NotNull
    public PsiPackageStatement createPackageStatement(@NotNull String name2) throws IncorrectOperationException {
        PsiJavaFile aFile;
        PsiPackageStatement stmt;
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(83);
        }
        if ((stmt = (aFile = this.createDummyJavaFile("package " + name2 + ";")).getPackageStatement()) == null) {
            throw new IncorrectOperationException("Incorrect package name: " + name2);
        }
        PsiPackageStatement psiPackageStatement = stmt;
        if (psiPackageStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(84);
        }
        return psiPackageStatement;
    }

    @NotNull
    public PsiImportStaticStatement createImportStaticStatement(@NotNull PsiClass aClass, @NotNull String memberName) throws IncorrectOperationException {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(85);
        }
        if (memberName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(86);
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import static " + aClass.getQualifiedName() + "." + memberName + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, true);
        PsiImportStaticStatement psiImportStaticStatement = (PsiImportStaticStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
        if (psiImportStaticStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(87);
        }
        return psiImportStaticStatement;
    }

    @NotNull
    public PsiParameterList createParameterList(@NotNull String[] names, @NotNull PsiType[] types) throws IncorrectOperationException {
        if (names == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(88);
        }
        if (types == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(89);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("void method(");
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(types[i].getCanonicalText(true)).append(' ').append(names[i]);
        }
        builder.append(");");
        PsiParameterList psiParameterList = this.createMethodFromText(builder.toString(), null).getParameterList();
        if (psiParameterList == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(90);
        }
        return psiParameterList;
    }

    @NotNull
    public PsiReferenceList createReferenceList(@NotNull PsiJavaCodeReferenceElement[] references) throws IncorrectOperationException {
        if (references == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(91);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("void method()");
        if (references.length > 0) {
            builder.append(" throws ");
            for (int i = 0; i < references.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(references[i].getCanonicalText());
            }
        }
        builder.append(';');
        PsiReferenceList psiReferenceList = this.createMethodFromText(builder.toString(), null).getThrowsList();
        if (psiReferenceList == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(92);
        }
        return psiReferenceList;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(93);
        }
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference(this.myManager, packageName);
        if (lightPackageReference == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(94);
        }
        return lightPackageReference;
    }

    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(95);
        }
        String text2 = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        LightClassReferenceExpression lightClassReferenceExpression = new LightClassReferenceExpression(this.myManager, text2, aClass);
        if (lightClassReferenceExpression == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(96);
        }
        return lightClassReferenceExpression;
    }

    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(97);
        }
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReferenceExpression lightPackageReferenceExpression = new LightPackageReferenceExpression(this.myManager, aPackage);
        if (lightPackageReferenceExpression == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(98);
        }
        return lightPackageReferenceExpression;
    }

    @NotNull
    public PsiIdentifier createIdentifier(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(99);
        }
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)text2);
        LightIdentifier lightIdentifier = new LightIdentifier(this.myManager, text2);
        if (lightIdentifier == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(100);
        }
        return lightIdentifier;
    }

    @NotNull
    public PsiKeyword createKeyword(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(101);
        }
        if (!PsiNameHelper.getInstance((Project)this.myManager.getProject()).isKeyword(text2)) {
            throw new IncorrectOperationException("\"" + text2 + "\" is not a keyword.");
        }
        LightKeyword lightKeyword = new LightKeyword(this.myManager, text2);
        if (lightKeyword == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(102);
        }
        return lightKeyword;
    }

    @NotNull
    public PsiKeyword createKeyword(@NotNull @NonNls String keyword, PsiElement context) throws IncorrectOperationException {
        LanguageLevel level;
        if (keyword == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(103);
        }
        if (!JavaLexer.isKeyword(keyword, level = PsiUtil.getLanguageLevel((PsiElement)context)) && !JavaLexer.isSoftKeyword(keyword, level)) {
            throw new IncorrectOperationException("\"" + keyword + "\" is not a keyword.");
        }
        LightKeyword lightKeyword = new LightKeyword(this.myManager, keyword);
        if (lightKeyword == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(104);
        }
        return lightKeyword;
    }

    @NotNull
    public PsiImportStatement createImportStatement(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(105);
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + aClass.getQualifiedName() + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
        if (psiImportStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(106);
        }
        return psiImportStatement;
    }

    @NotNull
    public PsiImportStatement createImportStatementOnDemand(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(107);
        }
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create import statement for default package.");
        }
        if (!PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(packageName)) {
            throw new IncorrectOperationException("Incorrect package name: \"" + packageName + "\".");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + packageName + ".*;");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
        if (psiImportStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(108);
        }
        return psiImportStatement;
    }

    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NonNls @NotNull String name2, @NotNull PsiType type2, @Nullable PsiExpression initializer) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(109);
        }
        if (type2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(110);
        }
        PsiDeclarationStatement psiDeclarationStatement = this.createVariableDeclarationStatement(name2, type2, initializer, null);
        if (psiDeclarationStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(111);
        }
        return psiDeclarationStatement;
    }

    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NonNls @NotNull String name2, @NotNull PsiType type2, @Nullable PsiExpression initializer, @Nullable PsiElement context) throws IncorrectOperationException {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(112);
        }
        if (type2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(113);
        }
        if (!this.isIdentifier(name2)) {
            throw new IncorrectOperationException("\"" + name2 + "\" is not an identifier.");
        }
        if (PsiType.NULL.equals((Object)type2)) {
            throw new IncorrectOperationException("Cannot create variable with type \"null\".");
        }
        String text2 = "X " + name2 + (initializer != null ? " = x" : "") + ";";
        PsiDeclarationStatement statement = (PsiDeclarationStatement)this.createStatementFromText(text2, context);
        PsiVariable variable = (PsiVariable)statement.getDeclaredElements()[0];
        PsiElementFactoryImpl.replace((PsiElement)variable.getTypeElement(), (PsiElement)this.createTypeElement(GenericsUtil.getVariableTypeByExpressionType((PsiType)type2)), text2);
        boolean generateFinalLocals = JavaCodeStyleSettingsFacade.getInstance((Project)this.myManager.getProject()).isGenerateFinalLocals();
        PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)generateFinalLocals);
        if (initializer != null) {
            PsiElementFactoryImpl.replace((PsiElement)variable.getInitializer(), (PsiElement)initializer, text2);
        }
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        PsiDeclarationStatement psiDeclarationStatement = statement;
        if (psiDeclarationStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(114);
        }
        return psiDeclarationStatement;
    }

    private static void replace(@Nullable PsiElement original, @NotNull PsiElement replacement, @NotNull String message2) {
        if (replacement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(115);
        }
        if (message2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(116);
        }
        assert (original != null) : message2;
        original.replace(replacement);
    }

    @NotNull
    public PsiDocTag createParamTag(@NotNull String parameterName, @NonNls String description) throws IncorrectOperationException {
        if (parameterName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(117);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" * @param ");
        builder.append(parameterName);
        builder.append(" ");
        String[] strings = description.split("\\n");
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append("\n * ");
            }
            builder.append(strings[i]);
        }
        PsiDocTag psiDocTag = this.createDocTagFromText(builder.toString());
        if (psiDocTag == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(118);
        }
        return psiDocTag;
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (annotationText == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(119);
        }
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiAnnotation);
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        if (psiAnnotation2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(120);
        }
        return psiAnnotation2;
    }

    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context, boolean markGenerated) throws IncorrectOperationException {
        if (annotationText == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(121);
        }
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        if (markGenerated) {
            GeneratedMarkerVisitor.markGenerated((PsiElement)psiAnnotation);
        }
        return psiAnnotation;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(122);
        }
        PsiCodeBlock psiCodeBlock = super.createCodeBlockFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiCodeBlock);
        PsiCodeBlock psiCodeBlock2 = psiCodeBlock;
        if (psiCodeBlock2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(123);
        }
        return psiCodeBlock2;
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(124);
        }
        PsiEnumConstant enumConstant = super.createEnumConstantFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)enumConstant);
        PsiEnumConstant psiEnumConstant = enumConstant;
        if (psiEnumConstant == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(125);
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(126);
        }
        PsiExpression expression2 = super.createExpressionFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)expression2);
        PsiExpression psiExpression = expression2;
        if (psiExpression == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(127);
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(128);
        }
        PsiField psiField = super.createFieldFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiField);
        PsiField psiField2 = psiField;
        if (psiField2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(129);
        }
        return psiField2;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(130);
        }
        PsiParameter parameter2 = super.createParameterFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)parameter2);
        PsiParameter psiParameter = parameter2;
        if (psiParameter == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(131);
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(132);
        }
        PsiStatement statement = super.createStatementFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        PsiStatement psiStatement = statement;
        if (psiStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(133);
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(134);
        }
        PsiType psiType = this.createTypeInner(text2, context, true);
        if (psiType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(135);
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text2, PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(136);
        }
        PsiTypeParameter typeParameter = super.createTypeParameterFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)typeParameter);
        PsiTypeParameter psiTypeParameter = typeParameter;
        if (psiTypeParameter == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(137);
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text2, PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(138);
        }
        PsiMethod method = super.createMethodFromText(text2, context, level);
        GeneratedMarkerVisitor.markGenerated((PsiElement)method);
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(139);
        }
        return psiMethod;
    }

    private static PsiImportStatementBase extractImport(PsiJavaFile aFile, boolean isStatic) {
        PsiImportStaticStatement[] statements;
        PsiImportList importList = aFile.getImportList();
        assert (importList != null) : aFile;
        Object[] objectArray = statements = isStatic ? importList.getImportStaticStatements() : importList.getImportStatements();
        assert (statements.length == 1) : aFile.getText();
        return statements[0];
    }

    @NotNull
    public PsiCatchSection createCatchSection(@NotNull PsiType exceptionType, @NotNull String exceptionName, @Nullable PsiElement context) throws IncorrectOperationException {
        if (exceptionType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(140);
        }
        if (exceptionName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(141);
        }
        if (!(exceptionType instanceof PsiClassType) && !(exceptionType instanceof PsiDisjunctionType)) {
            throw new IncorrectOperationException("Unexpected type:" + exceptionType);
        }
        String text2 = "catch (" + exceptionType.getCanonicalText(true) + " " + exceptionName + ") {}";
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, CATCH_SECTION, PsiElementFactoryImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCatchSection)) {
            throw new IncorrectOperationException("Incorrect catch section '" + text2 + "'. Parsed element: " + element);
        }
        Project project = this.myManager.getProject();
        JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(project);
        helper.setupCatchBlock(exceptionName, exceptionType, context, (PsiCatchSection)element);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        PsiCatchSection catchSection = (PsiCatchSection)styleManager.reformat(element);
        GeneratedMarkerVisitor.markGenerated((PsiElement)catchSection);
        PsiCatchSection psiCatchSection = catchSection;
        if (psiCatchSection == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(142);
        }
        return psiCatchSection;
    }

    public boolean isValidClassName(@NotNull String name2) {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(143);
        }
        return this.isIdentifier(name2);
    }

    public boolean isValidMethodName(@NotNull String name2) {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(144);
        }
        return this.isIdentifier(name2);
    }

    public boolean isValidParameterName(@NotNull String name2) {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(145);
        }
        return this.isIdentifier(name2);
    }

    public boolean isValidFieldName(@NotNull String name2) {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(146);
        }
        return this.isIdentifier(name2);
    }

    public boolean isValidLocalVariableName(@NotNull String name2) {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(147);
        }
        return this.isIdentifier(name2);
    }

    private boolean isIdentifier(@NotNull String name2) {
        if (name2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(148);
        }
        return PsiNameHelper.getInstance((Project)this.myManager.getProject()).isIdentifier(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 77: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 111: 
            case 114: 
            case 118: 
            case 120: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 142: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 77: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 111: 
            case 114: 
            case 118: 
            case 120: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 142: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 77: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 111: 
            case 114: 
            case 118: 
            case 120: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiElementFactoryImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 83: 
            case 109: 
            case 112: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 25: 
            case 31: 
            case 43: 
            case 61: 
            case 110: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 47: 
            case 51: 
            case 53: 
            case 73: 
            case 85: 
            case 95: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSubstitutor";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 60: 
            case 65: 
            case 99: 
            case 101: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 66: 
            case 68: 
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 69: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 81: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 93: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 119: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationText";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiElementFactoryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayClassType";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 48: 
            case 50: 
            case 52: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterface";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnum";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeElement";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceElementByType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameterList";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameter";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createField";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethod";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructor";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassInitializer";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlock";
                break;
            }
            case 56: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyHolder";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubstitutor";
                break;
            }
            case 67: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQClassName";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassReferenceElement";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceElementByFQClassName";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "createFQClassNameReferenceElement";
                break;
            }
            case 82: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageReferenceElement";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageStatement";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStaticStatement";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceList";
                break;
            }
            case 96: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceExpression";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdentifier";
                break;
            }
            case 102: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyword";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatement";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatementOnDemand";
                break;
            }
            case 111: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableDeclarationStatement";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "createParamTag";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlockFromText";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnumConstantFromText";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionFromText";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldFromText";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterFromText";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatementFromText";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeFromText";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameterFromText";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodFromText";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "createCatchSection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getArrayClass";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 77: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 111: 
            case 114: 
            case 118: 
            case 120: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 142: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getArrayClassType";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 47: 
            case 49: 
            case 51: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createInterface";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createEnum";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTypeElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceElementByType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createField";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createMethod";
                break;
            }
            case 38: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createConstructor";
                break;
            }
            case 42: 
            case 43: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 55: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createRawSubstitutor";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createDummyHolder";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createSubstitutor";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createPrimitiveType";
                break;
            }
            case 66: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQClassName";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createClassReferenceElement";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceElementByFQClassName";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "createFQClassNameReferenceElement";
                break;
            }
            case 81: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "createPackageReferenceElement";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createPackageStatement";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createImportStaticStatement";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceList";
                break;
            }
            case 95: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceExpression";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "createIdentifier";
                break;
            }
            case 101: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "createKeyword";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatement";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatementOnDemand";
                break;
            }
            case 109: 
            case 110: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "createVariableDeclarationStatement";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "createParamTag";
                break;
            }
            case 119: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "createCodeBlockFromText";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "createEnumConstantFromText";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromText";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "createFieldFromText";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "createParameterFromText";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "createStatementFromText";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromText";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "createTypeParameterFromText";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFromText";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "createCatchSection";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassName";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isValidMethodName";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "isValidParameterName";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "isValidFieldName";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "isValidLocalVariableName";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 64: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 77: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 111: 
            case 114: 
            case 118: 
            case 120: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 142: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

