/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class RelaxedDirectInheritorChecker {
    private final String myBaseClassName;
    private final PsiClass myBaseClass;
    private final VolatileNotNullLazyValue<Pair<PsiClass[], Boolean>> myClasses;
    private final ProjectFileIndex myFileIndex;

    public RelaxedDirectInheritorChecker(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(0);
        }
        this.myBaseClass = baseClass;
        this.myBaseClassName = Objects.requireNonNull(baseClass.getName());
        this.myClasses = VolatileNotNullLazyValue.createValue(() -> RelaxedDirectInheritorChecker.getClassesAndTheirAmbiguities(this.myBaseClass.getProject(), this.myBaseClassName));
        this.myFileIndex = ProjectFileIndex.getInstance((Project)this.myBaseClass.getProject());
    }

    @NotNull
    private static Pair<PsiClass[], Boolean> getClassesAndTheirAmbiguities(@NotNull Project project, @NotNull String classShortName) {
        Map cache;
        Pair result;
        if (project == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(1);
        }
        if (classShortName == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(2);
        }
        if ((result = (Pair)SoftReference.dereference((Reference)((Reference)(cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap map = ContainerUtil.newConcurrentMap();
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        })).get(classShortName)))) == null) {
            PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(classShortName, GlobalSearchScope.allScope((Project)project));
            boolean ambiguities = RelaxedDirectInheritorChecker.hasAmbiguities(Arrays.asList(classes2));
            result = Pair.create((Object)classes2, (Object)ambiguities);
            cache.put(classShortName, new SoftReference((Object)result));
        }
        Pair pair = result;
        if (pair == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private static boolean hasAmbiguities(@NotNull List<? extends PsiClass> classes2) {
        if (classes2 == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(4);
        }
        int locals = 0;
        String theFQN = null;
        for (PsiClass psiClass : classes2) {
            String qName = psiClass.getQualifiedName();
            if (qName == null) {
                if (++locals <= 1) continue;
                return true;
            }
            if (theFQN == null) {
                theFQN = qName;
                continue;
            }
            if (theFQN.equals(qName)) continue;
            return true;
        }
        return locals == 1 && theFQN != null;
    }

    public boolean checkInheritance(@NotNull PsiClass inheritorCandidate) {
        if (inheritorCandidate == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(5);
        }
        if (!inheritorCandidate.isValid() || !this.myBaseClass.isValid()) {
            return false;
        }
        if (this.myFileIndex.isInSourceContent(inheritorCandidate.getContainingFile().getVirtualFile())) {
            GlobalSearchScope scope;
            Pair value2 = (Pair)this.myClasses.getValue();
            boolean hasGlobalAmbiguities = (Boolean)value2.getSecond();
            if (!hasGlobalAmbiguities) {
                return true;
            }
            Object[] classes2 = (PsiClass[])value2.getFirst();
            List accessible = ContainerUtil.findAll((Object[])classes2, arg_0 -> RelaxedDirectInheritorChecker.lambda$checkInheritance$2(scope = inheritorCandidate.getResolveScope(), inheritorCandidate, arg_0));
            if (!RelaxedDirectInheritorChecker.hasAmbiguities(accessible)) {
                return accessible.contains(this.myBaseClass);
            }
        }
        return inheritorCandidate.isInheritor(this.myBaseClass, false);
    }

    private static boolean isAccessibleLight(@NotNull PsiClass inheritorCandidate, @NotNull PsiClass base) {
        PsiModifierList modifierList;
        if (inheritorCandidate == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(6);
        }
        if (base == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(7);
        }
        if ((modifierList = base.getModifierList()) != null && PsiUtil.getAccessLevel((PsiModifierList)modifierList) == 3) {
            return true;
        }
        return JavaResolveUtil.isAccessible((PsiMember)base, base.getContainingClass(), modifierList, (PsiElement)inheritorCandidate, null, null);
    }

    private static /* synthetic */ boolean lambda$checkInheritance$2(GlobalSearchScope scope, @NotNull PsiClass inheritorCandidate, PsiClass base) {
        if (inheritorCandidate == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(8);
        }
        return PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)base) && RelaxedDirectInheritorChecker.isAccessibleLight(inheritorCandidate, base);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classShortName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/RelaxedDirectInheritorChecker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritorCandidate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/RelaxedDirectInheritorChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesAndTheirAmbiguities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassesAndTheirAmbiguities";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasAmbiguities";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkInheritance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleLight";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkInheritance$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

