/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileLocalResolver {
    private final LighterAST myTree;

    public FileLocalResolver(@NotNull LighterAST tree) {
        if (tree == null) {
            FileLocalResolver.$$$reportNull$$$0(0);
        }
        this.myTree = tree;
    }

    @NotNull
    public LighterAST getLightTree() {
        LighterAST lighterAST = this.myTree;
        if (lighterAST == null) {
            FileLocalResolver.$$$reportNull$$$0(1);
        }
        return lighterAST;
    }

    @NotNull
    public LightResolveResult resolveLocally(@NotNull LighterASTNode ref) {
        String refName;
        if (ref == null) {
            FileLocalResolver.$$$reportNull$$$0(2);
        }
        if ((refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, ref)) == null) {
            LightResolveResult lightResolveResult = LightResolveResult.UNKNOWN;
            if (lightResolveResult == null) {
                FileLocalResolver.$$$reportNull$$$0(3);
            }
            return lightResolveResult;
        }
        if (!this.canResolveToLocalVariable(this.myTree, ref)) {
            LightResolveResult lightResolveResult = LightResolveResult.NON_LOCAL;
            if (lightResolveResult == null) {
                FileLocalResolver.$$$reportNull$$$0(4);
            }
            return lightResolveResult;
        }
        boolean passedClass = false;
        LighterASTNode lastParent = ref;
        while (true) {
            ProgressManager.checkCanceled();
            LighterASTNode scope = this.myTree.getParent(lastParent);
            if (scope == null) {
                LightResolveResult lightResolveResult = LightResolveResult.NON_LOCAL;
                if (lightResolveResult == null) {
                    FileLocalResolver.$$$reportNull$$$0(5);
                }
                return lightResolveResult;
            }
            for (LighterASTNode var : this.getDeclarations(scope, lastParent)) {
                if (!refName.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, var))) continue;
                if (passedClass) {
                    LightResolveResult lightResolveResult = var.getTokenType() == JavaElementType.FIELD ? LightResolveResult.NON_LOCAL : LightResolveResult.UNKNOWN;
                    if (lightResolveResult == null) {
                        FileLocalResolver.$$$reportNull$$$0(6);
                    }
                    return lightResolveResult;
                }
                LightResolveResult lightResolveResult = LightResolveResult.resolved(var);
                if (lightResolveResult == null) {
                    FileLocalResolver.$$$reportNull$$$0(7);
                }
                return lightResolveResult;
            }
            lastParent = scope;
            passedClass |= scope.getTokenType() == JavaElementType.CLASS || scope.getTokenType() == JavaElementType.ANONYMOUS_CLASS;
        }
    }

    private boolean canResolveToLocalVariable(@NotNull LighterAST tree, @NotNull LighterASTNode ref) {
        LighterASTNode parent;
        if (tree == null) {
            FileLocalResolver.$$$reportNull$$$0(8);
        }
        if (ref == null) {
            FileLocalResolver.$$$reportNull$$$0(9);
        }
        return (parent = tree.getParent(ref)) != null && parent.getTokenType() != JavaElementType.METHOD_CALL_EXPRESSION && !this.hasQualifier(ref);
    }

    private boolean hasQualifier(@NotNull LighterASTNode ref) {
        if (ref == null) {
            FileLocalResolver.$$$reportNull$$$0(10);
        }
        return LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)ref, (TokenSet)ElementType.EXPRESSION_BIT_SET) != null;
    }

    @NotNull
    private Iterable<LighterASTNode> getDeclarations(LighterASTNode scope, @Nullable LighterASTNode lastParent) {
        IElementType type2 = scope.getTokenType();
        if (type2 == JavaElementType.CODE_BLOCK) {
            JBIterable<LighterASTNode> jBIterable = this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.DECLARATION_STATEMENT), lastParent));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.DECLARATION_STATEMENT) {
            JBIterable<LighterASTNode> jBIterable = FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.LOCAL_VARIABLE), lastParent);
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.FOR_STATEMENT) {
            JBIterable<LighterASTNode> jBIterable = this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET), lastParent));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.FOREACH_STATEMENT || type2 == JavaElementType.CATCH_SECTION) {
            JBIterable jBIterable = JBIterable.of((Object)LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.PARAMETER));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(14);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.TRY_STATEMENT) {
            JBIterable<LighterASTNode> jBIterable = this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.RESOURCE_LIST), lastParent));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.RESOURCE_LIST) {
            JBIterable<LighterASTNode> jBIterable = FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.RESOURCE_VARIABLE), lastParent);
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(16);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.CLASS) {
            List list = LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.FIELD);
            if (list == null) {
                FileLocalResolver.$$$reportNull$$$0(17);
            }
            return list;
        }
        if (type2 == JavaElementType.LAMBDA_EXPRESSION || type2 == JavaElementType.METHOD) {
            LighterASTNode paramList = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.PARAMETER_LIST);
            List list = paramList == null ? ContainerUtil.emptyList() : LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)paramList, (IElementType)JavaElementType.PARAMETER);
            if (list == null) {
                FileLocalResolver.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<LighterASTNode> list = Collections.emptyList();
        if (list == null) {
            FileLocalResolver.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private JBIterable<LighterASTNode> walkChildrenScopes(JBIterable<LighterASTNode> children) {
        JBIterable jBIterable = children.flatMap(child -> this.getDeclarations((LighterASTNode)child, null));
        if (jBIterable == null) {
            FileLocalResolver.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<LighterASTNode> before(List<LighterASTNode> children, @Nullable LighterASTNode lastParent) {
        JBIterable jBIterable = JBIterable.from(children).filter(node -> lastParent == null || node.getStartOffset() < lastParent.getStartOffset());
        if (jBIterable == null) {
            FileLocalResolver.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @Nullable
    public String getShortClassTypeName(@NotNull LighterASTNode var) {
        LighterASTNode typeRef;
        String refName;
        if (var == null) {
            FileLocalResolver.$$$reportNull$$$0(22);
        }
        if ((refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, typeRef = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)var, (IElementType)JavaElementType.TYPE), (IElementType)JavaElementType.JAVA_CODE_REFERENCE))) == null) {
            return null;
        }
        if (LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)typeRef, (IElementType)JavaElementType.JAVA_CODE_REFERENCE) != null) {
            return refName;
        }
        if (this.isTypeParameter(refName, var)) {
            return null;
        }
        return refName;
    }

    private boolean isTypeParameter(String name2, LighterASTNode place) {
        LighterASTNode scope = place;
        while (scope != null) {
            if (scope.getTokenType() == JavaElementType.CLASS || scope.getTokenType() == JavaElementType.METHOD) {
                if (this.hasOwnTypeParameter(name2, scope)) {
                    return true;
                }
                if (this.isStatic(scope)) break;
            }
            scope = this.myTree.getParent(scope);
        }
        return false;
    }

    private boolean hasOwnTypeParameter(String name2, LighterASTNode member) {
        LighterASTNode typeParams = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)member, (IElementType)JavaElementType.TYPE_PARAMETER_LIST);
        if (typeParams != null) {
            for (LighterASTNode param : LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)typeParams, (IElementType)JavaElementType.TYPE_PARAMETER)) {
                if (!name2.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, param))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStatic(LighterASTNode scope) {
        LighterASTNode modList = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.MODIFIER_LIST);
        return modList != null && LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)modList, (IElementType)JavaTokenType.STATIC_KEYWORD) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/FileLocalResolver";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/FileLocalResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightTree";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocally";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "walkChildrenScopes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "before";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canResolveToLocalVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifier";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getShortClassTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LightResolveResult {
        public static final LightResolveResult UNKNOWN = new LightResolveResult();
        public static final LightResolveResult NON_LOCAL = new LightResolveResult();

        @NotNull
        static LightResolveResult resolved(final @NotNull LighterASTNode target) {
            if (target == null) {
                LightResolveResult.$$$reportNull$$$0(0);
            }
            LightResolveResult lightResolveResult = new LightResolveResult(){

                @Override
                @Nullable
                public LighterASTNode getTarget() {
                    return target;
                }
            };
            if (lightResolveResult == null) {
                LightResolveResult.$$$reportNull$$$0(1);
            }
            return lightResolveResult;
        }

        @Nullable
        public LighterASTNode getTarget() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/FileLocalResolver$LightResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/FileLocalResolver$LightResolveResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolved";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolved";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

