/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiImportListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiImportStatementImpl;
import com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PsiImportListImpl
extends JavaStubPsiElement<PsiImportListStub>
implements PsiImportList {
    private volatile Map<String, PsiImportStatement> myClassNameToImportMap;
    private volatile Map<String, PsiImportStatement> myPackageNameToImportMap;
    private volatile Map<String, PsiImportStatementBase> myNameToSingleImportMap;
    private static final PsiImportStatementBase[] EMPTY_ARRAY = PsiImportStatementBase.EMPTY_ARRAY;
    private static final ArrayFactory<PsiImportStatementBase> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiImportStatementBase[count];
    private static final TokenSet IMPORT_STATEMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.IMPORT_STATEMENT});
    private static final TokenSet IMPORT_STATIC_STATEMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.IMPORT_STATIC_STATEMENT});

    public PsiImportListImpl(PsiImportListStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.IMPORT_LIST);
    }

    public PsiImportListImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiImportListImpl clone = (PsiImportListImpl)((Object)super.clone());
        clone.myClassNameToImportMap = null;
        clone.myPackageNameToImportMap = null;
        clone.myNameToSingleImportMap = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        this.myClassNameToImportMap = null;
        this.myPackageNameToImportMap = null;
        this.myNameToSingleImportMap = null;
        super.subtreeChanged();
    }

    @NotNull
    public PsiImportStatement[] getImportStatements() {
        PsiImportStatement[] psiImportStatementArray = (PsiImportStatement[])this.getStubOrPsiChildren(IMPORT_STATEMENT_BIT_SET, PsiImportStatementImpl.ARRAY_FACTORY);
        if (psiImportStatementArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(0);
        }
        return psiImportStatementArray;
    }

    @NotNull
    public PsiImportStaticStatement[] getImportStaticStatements() {
        PsiImportStaticStatement[] psiImportStaticStatementArray = (PsiImportStaticStatement[])this.getStubOrPsiChildren(IMPORT_STATIC_STATEMENT_BIT_SET, PsiImportStaticStatementImpl.ARRAY_FACTORY);
        if (psiImportStaticStatementArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(1);
        }
        return psiImportStaticStatementArray;
    }

    @NotNull
    public PsiImportStatementBase[] getAllImportStatements() {
        PsiImportStatementBase[] psiImportStatementBaseArray = (PsiImportStatementBase[])this.getStubOrPsiChildren(ElementType.IMPORT_STATEMENT_BASE_BIT_SET, ARRAY_FACTORY);
        if (psiImportStatementBaseArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(2);
        }
        return psiImportStatementBaseArray;
    }

    public PsiImportStatement findSingleClassImportStatement(String name2) {
        Map<String, PsiImportStatement> map;
        while ((map = this.myClassNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name2);
    }

    public PsiImportStatement findOnDemandImportStatement(String name2) {
        Map<String, PsiImportStatement> map;
        while ((map = this.myPackageNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name2);
    }

    public PsiImportStatementBase findSingleImportStatement(String name2) {
        Map<String, PsiImportStatementBase> map;
        while ((map = this.myNameToSingleImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name2);
    }

    public boolean isReplaceEquivalent(PsiImportList otherList) {
        return this.getText().equals(otherList.getText());
    }

    private void initializeMaps() {
        PsiImportStaticStatement[] importStatics;
        PsiImportStatement[] imports2;
        HashMap<String, PsiImportStatement> classNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatement> packageNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatementBase> nameToSingleImportMap = new HashMap<String, PsiImportStatementBase>();
        for (PsiImportStatement anImport : imports2 = this.getImportStatements()) {
            String qName = anImport.getQualifiedName();
            if (qName == null) continue;
            if (anImport.isOnDemand()) {
                packageNameToImportMap.put(qName, anImport);
                continue;
            }
            classNameToImportMap.put(qName, anImport);
            PsiJavaCodeReferenceElement importReference2 = anImport.getImportReference();
            if (importReference2 == null) continue;
            nameToSingleImportMap.put(importReference2.getReferenceName(), (PsiImportStatementBase)anImport);
        }
        for (PsiImportStaticStatement importStatic : importStatics = this.getImportStaticStatements()) {
            String referenceName;
            if (importStatic.isOnDemand() || (referenceName = importStatic.getReferenceName()) == null) continue;
            nameToSingleImportMap.put(referenceName, (PsiImportStatementBase)importStatic);
        }
        this.myClassNameToImportMap = classNameToImportMap;
        this.myPackageNameToImportMap = packageNameToImportMap;
        this.myNameToSingleImportMap = nameToSingleImportMap;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiImportListImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportList((PsiImportList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiImportList";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiImportListImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStaticStatements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImportStatements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiImportListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

