/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.ReferenceAdjuster;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.search.MethodDeepestSuperSearcher;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCodeStyleManagerImpl
extends JavaCodeStyleManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl");
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";
    @NonNls
    private static final String GET_PREFIX = "get";
    @NonNls
    private static final String IS_PREFIX = "is";
    @NonNls
    private static final String FIND_PREFIX = "find";
    @NonNls
    private static final String CREATE_PREFIX = "create";
    @NonNls
    private static final String SET_PREFIX = "set";
    @NonNls
    private static final String[] ourPrepositions = new String[]{"as", "at", "by", "down", "for", "from", "in", "into", "of", "on", "onto", "out", "over", "per", "to", "up", "upon", "via", "with"};
    private final Project myProject;

    public JavaCodeStyleManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = this.shortenClassReferences(element, 0);
        if (psiElement == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element, int flags) throws IncorrectOperationException {
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(2);
        }
        CheckUtil.checkWritable((PsiElement)element);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)element)) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        boolean addImports = !BitUtil.isSet((int)flags, (int)4096);
        boolean incompleteCode = BitUtil.isSet((int)flags, (int)8192);
        ReferenceAdjuster adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage());
        if (adjuster != null) {
            ASTNode reference = adjuster.process(element.getNode(), addImports, incompleteCode, this.myProject);
            PsiElement psiElement = SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)reference);
            if (psiElement == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public void shortenClassReferences(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        ReferenceAdjuster adjuster;
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(6);
        }
        CheckUtil.checkWritable((PsiElement)element);
        if (SourceTreeToPsiMap.hasTreeElement((PsiElement)element) && (adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage())) != null) {
            adjuster.processRange(element.getNode(), startOffset, endOffset, this.myProject);
        }
    }

    @NotNull
    public PsiElement qualifyClassReferences(@NotNull PsiElement element) {
        ReferenceAdjuster adjuster;
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(7);
        }
        if ((adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage())) != null) {
            ASTNode reference = adjuster.process(element.getNode(), false, false, true, true);
            PsiElement psiElement = SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)reference);
            if (psiElement == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    public void optimizeImports(@NotNull PsiFile file) throws IncorrectOperationException {
        PsiImportList importList;
        PsiImportList newList;
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(10);
        }
        CheckUtil.checkWritable((PsiElement)file);
        if (file instanceof PsiJavaFile && CodeStyle.isFormattingEnabled((PsiFile)file) && (newList = this.prepareOptimizeImportsResult((PsiJavaFile)file)) != null && (importList = ((PsiJavaFile)file).getImportList()) != null) {
            importList.replace((PsiElement)newList);
        }
    }

    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file) {
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(11);
        }
        return new ImportHelper(JavaCodeStyleSettings.getInstance((PsiFile)file)).prepareOptimizeImportsResult(file);
    }

    public boolean hasConflictingOnDemandImport(@NotNull PsiJavaFile file, @NotNull PsiClass psiClass, @NotNull String referenceName) {
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(12);
        }
        if (psiClass == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(13);
        }
        if (referenceName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(14);
        }
        return ImportHelper.hasConflictingOnDemandImport(file, psiClass, referenceName);
    }

    public boolean addImport(@NotNull PsiJavaFile file, @NotNull PsiClass refClass) {
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(15);
        }
        if (refClass == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(16);
        }
        return new ImportHelper(JavaCodeStyleSettings.getInstance((PsiFile)file)).addImport(file, refClass);
    }

    public void removeRedundantImports(@NotNull PsiJavaFile file) throws IncorrectOperationException {
        Collection<PsiImportStatementBase> redundant;
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(17);
        }
        if ((redundant = this.findRedundantImports(file)) == null) {
            return;
        }
        for (PsiImportStatementBase importStatement : redundant) {
            PsiJavaCodeReferenceElement ref = importStatement.getImportReference();
            if (ref == null || ref.resolve() == null) continue;
            importStatement.delete();
        }
    }

    @Nullable
    public Collection<PsiImportStatementBase> findRedundantImports(final @NotNull PsiJavaFile file) {
        THashSet redundant;
        PsiImportList importList;
        if (file == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(18);
        }
        if ((importList = file.getImportList()) == null) {
            return null;
        }
        Object[] imports2 = importList.getAllImportStatements();
        if (imports2.length == 0) {
            return null;
        }
        THashSet allImports = new THashSet(Arrays.asList(imports2));
        if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            redundant = ContainerUtil.newIdentityTroveSet();
            ContainerUtil.addAll((Collection)redundant, (Object[])imports2);
            redundant.removeAll((Collection<?>)allImports);
            for (Object importStatement : imports2) {
                if (!(importStatement instanceof JspxImportStatement) || !importStatement.isForeignFileImport()) continue;
                redundant.remove(importStatement);
            }
        } else {
            redundant = allImports;
            List roots = file.getViewProvider().getAllFiles();
            for (PsiElement root : roots) {
                root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Collection)redundant){
                    final /* synthetic */ Collection val$redundant;
                    {
                        this.val$redundant = collection;
                    }

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        PsiElement resolveScope;
                        JavaResolveResult resolveResult;
                        if (!reference.isQualified() && !this.inTheSamePackage(file, (resolveResult = reference.advancedResolve(false)).getElement()) && (resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
                            PsiImportStatementBase importStatementBase = (PsiImportStatementBase)resolveScope;
                            this.val$redundant.remove(importStatementBase);
                        }
                        super.visitReferenceElement(reference);
                    }

                    private boolean inTheSamePackage(PsiJavaFile file2, PsiElement element) {
                        PsiFile containingFile;
                        if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null && (containingFile = element.getContainingFile()) instanceof PsiJavaFile) {
                            return Comparing.strEqual((String)file2.getPackageName(), (String)((PsiJavaFile)containingFile).getPackageName());
                        }
                        return false;
                    }
                });
            }
        }
        return redundant;
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement) {
        if (statement == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(19);
        }
        return new ImportHelper(JavaCodeStyleSettings.getInstance(statement.getContainingFile())).findEntryIndex(statement);
    }

    @NotNull
    public SuggestedNameInfo suggestCompiledParameterName(@NotNull PsiType type2) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(20);
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(this.suggestVariableNameByType(type2, VariableKind.PARAMETER, true, true)){};
        if (suggestedNameInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(21);
        }
        return suggestedNameInfo;
    }

    @NotNull
    public SuggestedNameInfo suggestVariableName(final @NotNull VariableKind kind2, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type2, boolean correctKeywords) {
        NamesByExprInfo namesByExpr;
        if (kind2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(22);
        }
        if (expr != null && type2 == null) {
            type2 = expr.getType();
        }
        LinkedHashSet names = new LinkedHashSet();
        if (propertyName != null) {
            Object[] namesByName = ArrayUtil.toStringArray(this.getSuggestionsByName(propertyName, kind2, correctKeywords));
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByName, kind2, propertyName, null);
            ContainerUtil.addAll(names, (Object[])namesByName);
        }
        if (expr != null) {
            namesByExpr = this.suggestVariableNameByExpression(expr, kind2);
            Object[] suggestions = ArrayUtil.toStringArray(this.getSuggestionsByNames(namesByExpr.names, kind2, correctKeywords));
            if (namesByExpr.propertyName != null) {
                JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])suggestions, kind2, namesByExpr.propertyName, null);
            }
            ContainerUtil.addAll(names, (Object[])suggestions);
        } else {
            namesByExpr = null;
        }
        if (type2 != null) {
            Object[] namesByType = this.suggestVariableNameByType(type2, kind2, correctKeywords);
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByType, kind2, null, type2);
            ContainerUtil.addAll(names, (Object[])namesByType);
        }
        final String _propertyName = propertyName != null ? propertyName : (namesByExpr != null ? namesByExpr.propertyName : null);
        JavaCodeStyleManagerImpl.addNamesFromStatistics(names, kind2, _propertyName, type2);
        String[] namesArray = ArrayUtil.toStringArray(names);
        JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesArray, kind2, _propertyName, type2);
        final PsiType _type = type2;
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(namesArray){

            public void nameChosen(String name2) {
                if (_propertyName != null || _type != null && _type.isValid()) {
                    JavaStatisticsManager.incVariableNameUseCount((String)name2, (VariableKind)kind2, (String)_propertyName, (PsiType)_type);
                }
            }
        };
        if (suggestedNameInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(23);
        }
        return suggestedNameInfo;
    }

    private static void addNamesFromStatistics(@NotNull Set<? super String> names, @NotNull VariableKind variableKind, @Nullable String propertyName, @Nullable PsiType type2) {
        if (names == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(24);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(25);
        }
        String[] allNames = JavaStatisticsManager.getAllVariableNamesUsed((VariableKind)variableKind, (String)propertyName, (PsiType)type2);
        int maxFrequency = 0;
        for (String name2 : allNames) {
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name2, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            maxFrequency = Math.max(maxFrequency, count);
        }
        int frequencyLimit = Math.max(5, maxFrequency / 2);
        for (String name3 : allNames) {
            if (names.contains(name3)) continue;
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name3, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("new name:" + name3 + " count:" + count);
                LOG.debug("frequencyLimit:" + frequencyLimit);
            }
            if (count < frequencyLimit) continue;
            names.add(name3);
        }
        if (propertyName != null && type2 != null) {
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, propertyName, null);
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names, variableKind, null, type2);
        }
    }

    @NotNull
    private String[] suggestVariableNameByType(@NotNull PsiType type2, @NotNull VariableKind variableKind, boolean correctKeywords) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(26);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(27);
        }
        String[] stringArray = this.suggestVariableNameByType(type2, variableKind, correctKeywords, false);
        if (stringArray == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(28);
        }
        return stringArray;
    }

    @NotNull
    private String[] suggestVariableNameByType(@NotNull PsiType type2, @NotNull VariableKind variableKind, boolean correctKeywords, boolean skipIndices) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(29);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(30);
        }
        Collection<String> byTypeNames = this.doSuggestNamesByType(type2, variableKind, skipIndices);
        String[] stringArray = ArrayUtil.toStringArray(this.getSuggestionsByNames(byTypeNames, variableKind, correctKeywords));
        if (stringArray == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(31);
        }
        return stringArray;
    }

    @NotNull
    private Collection<String> doSuggestNamesByType(@NotNull PsiType type2, @NotNull VariableKind variableKind, boolean skipIndices) {
        Collection<String> fromTypeMap;
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(32);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(33);
        }
        if ((fromTypeMap = this.suggestNamesFromTypeMap(type2, variableKind, skipIndices)) != null) {
            Collection<String> collection = fromTypeMap;
            if (collection == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(34);
            }
            return collection;
        }
        if (!(type2 instanceof PsiClassType) || skipIndices) {
            Collection<String> collection = JavaCodeStyleManagerImpl.suggestNamesFromTypeName(type2, skipIndices);
            if (collection == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(35);
            }
            return collection;
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        PsiClassType classType = (PsiClassType)type2;
        JavaCodeStyleManagerImpl.suggestNamesForCollectionInheritors(classType, suggestions);
        this.suggestFromOptionalContent(variableKind, classType, suggestions);
        JavaCodeStyleManagerImpl.suggestNamesFromGenericParameters(classType, suggestions);
        suggestions.addAll(JavaCodeStyleManagerImpl.suggestNamesFromTypeName(type2, false));
        JavaCodeStyleManagerImpl.suggestNamesFromHierarchy(classType, suggestions);
        LinkedHashSet<String> linkedHashSet = suggestions;
        if (linkedHashSet == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(36);
        }
        return linkedHashSet;
    }

    @Nullable
    private Collection<String> suggestNamesFromTypeMap(@NotNull PsiType type2, @NotNull VariableKind variableKind, boolean skipIndices) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(37);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(38);
        }
        String longTypeName = skipIndices ? type2.getCanonicalText() : JavaCodeStyleManagerImpl.getLongTypeName(type2);
        CodeStyleSettings.TypeToNameMap map = this.getMapByVariableKind(variableKind);
        if (map != null && longTypeName != null) {
            String name2;
            if (type2.equals(PsiType.NULL)) {
                longTypeName = "java.lang.Object";
            }
            if ((name2 = map.nameByType(longTypeName)) != null && this.isIdentifier(name2)) {
                return Collections.singletonList(type2 instanceof PsiArrayType ? StringUtil.pluralize((String)name2) : name2);
            }
        }
        return null;
    }

    private void suggestFromOptionalContent(@NotNull VariableKind variableKind, @NotNull PsiClassType classType, @NotNull Collection<? super String> suggestions) {
        PsiType optionalContent;
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(39);
        }
        if (classType == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(40);
        }
        if (suggestions == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(41);
        }
        if ((optionalContent = JavaCodeStyleManagerImpl.extractOptionalContent(classType)) == null) {
            return;
        }
        Collection<String> contentSuggestions = this.doSuggestNamesByType(optionalContent, variableKind, false);
        suggestions.addAll(contentSuggestions);
        for (String s : contentSuggestions) {
            suggestions.add("optional" + StringUtil.capitalize((String)s));
        }
    }

    @NotNull
    private static Collection<String> suggestNamesFromTypeName(@NotNull PsiType type2, boolean skipIndices) {
        String typeName;
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(42);
        }
        if ((typeName = JavaCodeStyleManagerImpl.getTypeName(type2, !skipIndices)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(43);
            }
            return list;
        }
        typeName = JavaCodeStyleManagerImpl.normalizeTypeName(typeName);
        List<String> list = Collections.singletonList(type2 instanceof PsiArrayType ? StringUtil.pluralize((String)typeName) : typeName);
        if (list == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(44);
        }
        return list;
    }

    @Nullable
    private static PsiType extractOptionalContent(@NotNull PsiClassType classType) {
        PsiClass resolved;
        if (classType == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(45);
        }
        if ((resolved = classType.resolve()) != null && "java.util.Optional".equals(resolved.getQualifiedName()) && classType.getParameterCount() == 1) {
            return classType.getParameters()[0];
        }
        return null;
    }

    private static void suggestNamesFromHierarchy(@NotNull PsiClassType type2, @NotNull Collection<? super String> suggestions) {
        PsiClass resolved;
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(46);
        }
        if (suggestions == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(47);
        }
        if ((resolved = type2.resolve()) == null || resolved.getContainingClass() == null) {
            return;
        }
        InheritanceUtil.processSupers((PsiClass)resolved, (boolean)false, superClass -> {
            if (suggestions == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(138);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)superClass, (PsiElement)resolved, (boolean)true)) {
                suggestions.add(superClass.getName());
            }
            return false;
        });
    }

    private static void suggestNamesFromGenericParameters(@NotNull PsiClassType type2, @NotNull Collection<? super String> suggestions) {
        PsiType[] parameters2;
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(48);
        }
        if (suggestions == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(49);
        }
        StringBuilder fullNameBuilder = new StringBuilder();
        for (PsiType parameter2 : parameters2 = type2.getParameters()) {
            String typeName;
            if (!(parameter2 instanceof PsiClassType) || (typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(parameter2))) == null) continue;
            fullNameBuilder.append(typeName);
        }
        String baseName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName((PsiType)type2));
        if (baseName != null) {
            fullNameBuilder.append(baseName);
            suggestions.add(fullNameBuilder.toString());
        }
    }

    private static void suggestNamesForCollectionInheritors(@NotNull PsiClassType type2, @NotNull Collection<? super String> suggestions) {
        PsiType componentType;
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(50);
        }
        if (suggestions == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(51);
        }
        if ((componentType = PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false)) == null || componentType.equals(type2)) {
            return;
        }
        String typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(componentType));
        if (typeName != null) {
            suggestions.add(StringUtil.pluralize((String)typeName));
        }
    }

    private static String normalizeTypeName(@Nullable String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.endsWith(IMPL_SUFFIX) && typeName.length() > IMPL_SUFFIX.length()) {
            return typeName.substring(0, typeName.length() - IMPL_SUFFIX.length());
        }
        return typeName;
    }

    @Nullable
    public static String getTypeName(@NotNull PsiType type2) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(52);
        }
        return JavaCodeStyleManagerImpl.getTypeName(type2, true);
    }

    @Nullable
    private static String getTypeName(@NotNull PsiType type2, boolean withIndices) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(53);
        }
        if ((type2 = type2.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            String className = classType.getClassName();
            if (className != null || !withIndices) {
                return className;
            }
            PsiClass aClass = classType.resolve();
            return aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getClassName() : null;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return type2.getPresentableText();
        }
        if (type2 instanceof PsiWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiWildcardType)type2).getExtendsBound(), withIndices);
        }
        if (type2 instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiIntersectionType)type2).getRepresentative(), withIndices);
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName((PsiType)((PsiCapturedWildcardType)type2).getWildcard(), withIndices);
        }
        if (type2 instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiDisjunctionType)type2).getLeastUpperBound(), withIndices);
        }
        return null;
    }

    @Nullable
    private static String getLongTypeName(@NotNull PsiType type2) {
        if (type2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(54);
        }
        if (type2 instanceof PsiClassType) {
            PsiClass aClass = ((PsiClassType)type2).resolve();
            if (aClass == null) {
                return null;
            }
            if (aClass instanceof PsiAnonymousClass) {
                PsiClass baseClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve();
                return baseClass != null ? baseClass.getQualifiedName() : null;
            }
            return aClass.getQualifiedName();
        }
        if (type2 instanceof PsiArrayType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiArrayType)type2).getComponentType()) + "[]";
        }
        if (type2 instanceof PsiPrimitiveType) {
            return type2.getPresentableText();
        }
        if (type2 instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type2).getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type2).getWildcard().getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type2 instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiIntersectionType)type2).getRepresentative());
        }
        if (type2 instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiDisjunctionType)type2).getLeastUpperBound());
        }
        return null;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpression(@NotNull PsiExpression expr, @Nullable VariableKind variableKind) {
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(55);
        }
        LinkedHashSet names = new LinkedHashSet();
        ContainerUtil.addIfNotNull(names, (Object)JavaCodeStyleManagerImpl.suggestVariableNameFromLiterals(expr));
        NamesByExprInfo byExpr = this.suggestVariableNameByExpressionOnly(expr, variableKind, false);
        NamesByExprInfo byExprPlace = this.suggestVariableNameByExpressionPlace(expr, variableKind);
        NamesByExprInfo byExprAllMethods = this.suggestVariableNameByExpressionOnly(expr, variableKind, true);
        ContainerUtil.addAll(names, (Iterable)byExpr.names);
        ContainerUtil.addAll(names, (Iterable)byExprPlace.names);
        PsiType type2 = expr.getType();
        if (type2 != null && variableKind != null) {
            ContainerUtil.addAll(names, this.doSuggestNamesByType(type2, variableKind, false));
        }
        ContainerUtil.addAll(names, (Iterable)byExprAllMethods.names);
        String propertyName = byExpr.propertyName != null ? byExpr.propertyName : byExprPlace.propertyName;
        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName, names);
        if (namesByExprInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(56);
        }
        return namesByExprInfo;
    }

    @Nullable
    private static String suggestVariableNameFromLiterals(@NotNull PsiExpression expr) {
        String text2;
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(57);
        }
        if ((text2 = JavaCodeStyleManagerImpl.findLiteralText(expr)) == null) {
            return null;
        }
        return expr.getType() instanceof PsiArrayType ? StringUtil.pluralize((String)text2) : text2;
    }

    @Nullable
    private static String findLiteralText(@NotNull PsiExpression expr) {
        PsiElement[] literals;
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(58);
        }
        if ((literals = PsiTreeUtil.collectElements((PsiElement)expr, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                PsiElement exprList;
                if (JavaCodeStyleManagerImpl.isStringPsiLiteral(element) && this.isNameSupplier(element) && (exprList = element.getParent()) instanceof PsiExpressionList) {
                    PsiElement call = exprList.getParent();
                    if (call instanceof PsiNewExpression) {
                        return true;
                    }
                    if (call instanceof PsiMethodCallExpression) {
                        return true;
                    }
                }
                return false;
            }

            private boolean isNameSupplier(PsiElement element) {
                String stringPresentation = StringUtil.unquoteString((String)element.getText());
                String[] words = stringPresentation.split(" ");
                if (words.length > 5) {
                    return false;
                }
                return Arrays.stream(words).allMatch(StringUtil::isJavaIdentifier);
            }
        })).length == 1) {
            return StringUtil.unquoteString((String)literals[0].getText()).replaceAll(" ", "_");
        }
        return null;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpressionOnly(@NotNull PsiExpression expr, @Nullable VariableKind variableKind, boolean useAllMethodNames) {
        PsiType functionalInterfaceType;
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(59);
        }
        if (expr instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)expr).getMethodExpression();
            String methodName = methodExpr.getReferenceName();
            if (methodName != null) {
                PsiExpression[] expressions2;
                if (("of".equals(methodName) || "ofNullable".equals(methodName)) && JavaCodeStyleManagerImpl.isJavaUtilMethodCall((PsiMethodCallExpression)expr) && (expressions2 = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length > 0) {
                    NamesByExprInfo namesByExprInfo = this.suggestVariableNameByExpressionOnly(expressions2[0], variableKind, useAllMethodNames);
                    if (namesByExprInfo == null) {
                        JavaCodeStyleManagerImpl.$$$reportNull$$$0(60);
                    }
                    return namesByExprInfo;
                }
                if (("map".equals(methodName) || "flatMap".equals(methodName) || "filter".equals(methodName)) && JavaCodeStyleManagerImpl.isJavaUtilMethodCall((PsiMethodCallExpression)expr)) {
                    NamesByExprInfo namesByExprInfo = NamesByExprInfo.EMPTY;
                    if (namesByExprInfo == null) {
                        JavaCodeStyleManagerImpl.$$$reportNull$$$0(61);
                    }
                    return namesByExprInfo;
                }
                String[] words = NameUtil.nameToWords((String)methodName);
                if (words.length > 0) {
                    String firstWord = words[0];
                    if (GET_PREFIX.equals(firstWord) || IS_PREFIX.equals(firstWord) || FIND_PREFIX.equals(firstWord) || CREATE_PREFIX.equals(firstWord)) {
                        if (words.length > 1) {
                            String propertyName = methodName.substring(firstWord.length());
                            PsiExpression qualifierExpression2 = methodExpr.getQualifierExpression();
                            if (qualifierExpression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression2).resolve() instanceof PsiVariable) {
                                String name2 = ((PsiReferenceExpression)qualifierExpression2).getReferenceName() + StringUtil.capitalize((String)propertyName);
                                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName, new String[]{name2});
                                if (namesByExprInfo == null) {
                                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(62);
                                }
                                return namesByExprInfo;
                            }
                            NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName);
                            if (namesByExprInfo == null) {
                                JavaCodeStyleManagerImpl.$$$reportNull$$$0(63);
                            }
                            return namesByExprInfo;
                        }
                    } else if (words.length == 1 || useAllMethodNames) {
                        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(methodName);
                        if (namesByExprInfo == null) {
                            JavaCodeStyleManagerImpl.$$$reportNull$$$0(64);
                        }
                        return namesByExprInfo;
                    }
                }
            }
        } else if (expr instanceof PsiReferenceExpression) {
            String propertyName = this.getPropertyName((PsiReferenceExpression)expr, true);
            if (propertyName != null) {
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName);
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(65);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiArrayAccessExpression) {
            String singular;
            NamesByExprInfo info = this.suggestVariableNameByExpressionOnly(((PsiArrayAccessExpression)expr).getArrayExpression(), variableKind, useAllMethodNames);
            String string = singular = info.propertyName == null ? null : StringUtil.unpluralize((String)info.propertyName);
            if (singular != null) {
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(singular, ContainerUtil.mapNotNull((Collection)info.names, StringUtil::unpluralize));
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(66);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiLiteralExpression && variableKind == VariableKind.STATIC_FINAL_FIELD) {
            String stringValue;
            String[] names;
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            Object value2 = literalExpression.getValue();
            if (value2 instanceof String && (names = JavaCodeStyleManagerImpl.getSuggestionsByValue(stringValue = (String)value2)).length > 0) {
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, new String[]{JavaCodeStyleManagerImpl.constantValueToConstantName(names)});
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(67);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiParenthesizedExpression) {
            PsiExpression expression2 = ((PsiParenthesizedExpression)expr).getExpression();
            if (expression2 != null) {
                NamesByExprInfo namesByExprInfo = this.suggestVariableNameByExpressionOnly(expression2, variableKind, useAllMethodNames);
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(68);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiTypeCastExpression) {
            PsiExpression operand2 = ((PsiTypeCastExpression)expr).getOperand();
            if (operand2 != null) {
                NamesByExprInfo namesByExprInfo = this.suggestVariableNameByExpressionOnly(operand2, variableKind, useAllMethodNames);
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(69);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiLiteralExpression) {
            String text2 = StringUtil.unquoteString((String)expr.getText());
            if (this.isIdentifier(text2)) {
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(text2);
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(70);
                }
                return namesByExprInfo;
            }
        } else if (expr instanceof PsiFunctionalExpression && variableKind != null && (functionalInterfaceType = ((PsiFunctionalExpression)expr).getFunctionalInterfaceType()) != null) {
            NamesByExprInfo namesByExprInfo = new NamesByExprInfo(null, this.doSuggestNamesByType(functionalInterfaceType, variableKind, false));
            if (namesByExprInfo == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(71);
            }
            return namesByExprInfo;
        }
        NamesByExprInfo namesByExprInfo = NamesByExprInfo.EMPTY;
        if (namesByExprInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(72);
        }
        return namesByExprInfo;
    }

    private static boolean isJavaUtilMethodCall(@NotNull PsiMethodCallExpression expr) {
        PsiMethod method;
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(73);
        }
        if ((method = expr.resolveMethod()) == null) {
            return false;
        }
        return JavaCodeStyleManagerImpl.isJavaUtilMethod(method) || !MethodDeepestSuperSearcher.processDeepestSuperMethods(method, (Processor<? super PsiMethod>)((Processor)method1 -> !JavaCodeStyleManagerImpl.isJavaUtilMethod(method1)));
    }

    private static boolean isJavaUtilMethod(@NotNull PsiMethod method) {
        String name2;
        if (method == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(74);
        }
        return (name2 = PsiUtil.getMemberQualifiedName((PsiMember)method)) != null && name2.startsWith("java.util.");
    }

    @Nullable
    private String getPropertyName(@NotNull PsiReferenceExpression expression2) {
        if (expression2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(75);
        }
        return this.getPropertyName(expression2, false);
    }

    @Nullable
    private String getPropertyName(@NotNull PsiReferenceExpression expression2, boolean skipUnresolved) {
        String propertyName;
        if (expression2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(76);
        }
        if ((propertyName = expression2.getReferenceName()) == null) {
            return null;
        }
        PsiElement refElement = expression2.resolve();
        if (refElement instanceof PsiVariable) {
            VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
            return this.variableNameToPropertyName(propertyName, refVariableKind);
        }
        if (refElement == null && skipUnresolved) {
            return null;
        }
        return propertyName;
    }

    @NotNull
    private static String constantValueToConstantName(@NotNull String[] names) {
        if (names == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(77);
        }
        String string = String.join((CharSequence)"_", names);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(78);
        }
        return string;
    }

    @NotNull
    private static String[] getSuggestionsByValue(@NotNull String stringValue) {
        if (stringValue == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(79);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        boolean prevIsUpperCase = false;
        for (int i = 0; i < stringValue.length(); ++i) {
            char c = stringValue.charAt(i);
            if (Character.isUpperCase(c)) {
                if (currentWord.length() > 0 && !prevIsUpperCase) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                currentWord.append(c);
            } else if (Character.isLowerCase(c)) {
                currentWord.append(Character.toUpperCase(c));
            } else if (Character.isJavaIdentifierPart(c) && c != '_') {
                if (Character.isJavaIdentifierStart(c) || currentWord.length() > 0 || !result.isEmpty()) {
                    currentWord.append(c);
                }
            } else if (currentWord.length() > 0) {
                result.add(currentWord.toString());
                currentWord = new StringBuffer();
            }
            prevIsUpperCase = Character.isUpperCase(c);
        }
        if (currentWord.length() > 0) {
            result.add(currentWord.toString());
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(80);
        }
        return stringArray;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpressionPlace(@NotNull PsiExpression expr, @Nullable VariableKind variableKind) {
        PsiVariable variable;
        String variableName;
        if (expr == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(81);
        }
        if (expr.getParent() instanceof PsiExpressionList) {
            PsiExpressionList list = (PsiExpressionList)expr.getParent();
            PsiElement listParent = list.getParent();
            PsiSubstitutor subst = PsiSubstitutor.EMPTY;
            PsiMethod method = null;
            if (listParent instanceof PsiMethodCallExpression) {
                JavaResolveResult resolveResult = ((PsiMethodCallExpression)listParent).getMethodExpression().advancedResolve(false);
                method = (PsiMethod)resolveResult.getElement();
                subst = resolveResult.getSubstitutor();
            } else {
                if (listParent instanceof PsiAnonymousClass) {
                    listParent = listParent.getParent();
                }
                if (listParent instanceof PsiNewExpression) {
                    method = ((PsiNewExpression)listParent).resolveConstructor();
                }
            }
            if (method != null) {
                String name2;
                PsiParameter[] parameters2;
                Object[] expressions2;
                int index;
                PsiElement navElement = method.getNavigationElement();
                if (navElement instanceof PsiMethod) {
                    method = (PsiMethod)navElement;
                }
                if ((index = ArrayUtil.indexOf((Object[])(expressions2 = list.getExpressions()), (Object)expr)) < (parameters2 = method.getParameterList().getParameters()).length && (name2 = parameters2[index].getName()) != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)subst.substitute(parameters2[index].getType()), (PsiExpression)expr)) {
                    String firstWord;
                    String methodName;
                    String[] words;
                    name2 = this.variableNameToPropertyName(name2, VariableKind.PARAMETER);
                    if (expressions2.length == 1 && (words = NameUtil.nameToWords((String)(methodName = method.getName()))).length > 0 && SET_PREFIX.equals(firstWord = words[0])) {
                        String propertyName = methodName.substring(firstWord.length());
                        NamesByExprInfo namesByExprInfo = new NamesByExprInfo(name2, new String[]{propertyName});
                        if (namesByExprInfo == null) {
                            JavaCodeStyleManagerImpl.$$$reportNull$$$0(82);
                        }
                        return namesByExprInfo;
                    }
                    NamesByExprInfo namesByExprInfo = new NamesByExprInfo(name2);
                    if (namesByExprInfo == null) {
                        JavaCodeStyleManagerImpl.$$$reportNull$$$0(83);
                    }
                    return namesByExprInfo;
                }
            }
        } else if (expr.getParent() instanceof PsiAssignmentExpression) {
            String name3;
            PsiExpression leftExpression;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expr.getParent();
            if (expr == assignmentExpression.getRExpression() && (leftExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression && (name3 = this.getPropertyName((PsiReferenceExpression)leftExpression)) != null) {
                NamesByExprInfo namesByExprInfo = new NamesByExprInfo(name3);
                if (namesByExprInfo == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(84);
                }
                return namesByExprInfo;
            }
        } else if (expr.getParent() instanceof PsiLocalVariable && variableKind != VariableKind.LOCAL_VARIABLE && (variableName = (variable = (PsiVariable)expr.getParent()).getName()) != null) {
            String propertyName = this.variableNameToPropertyName(variableName, this.getVariableKind(variable));
            NamesByExprInfo namesByExprInfo = new NamesByExprInfo(propertyName);
            if (namesByExprInfo == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(85);
            }
            return namesByExprInfo;
        }
        NamesByExprInfo namesByExprInfo = NamesByExprInfo.EMPTY;
        if (namesByExprInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(86);
        }
        return namesByExprInfo;
    }

    @NotNull
    public String variableNameToPropertyName(@NotNull String name2, @NotNull VariableKind variableKind) {
        if (name2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(87);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(88);
        }
        if (variableKind == VariableKind.STATIC_FINAL_FIELD || variableKind == VariableKind.STATIC_FIELD && name2.contains("_")) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < name2.length(); ++i) {
                char c = name2.charAt(i);
                if (c != '_') {
                    if (Character.isLowerCase(c)) {
                        String string = this.variableNameToPropertyNameInner(name2, variableKind);
                        if (string == null) {
                            JavaCodeStyleManagerImpl.$$$reportNull$$$0(89);
                        }
                        return string;
                    }
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (++i >= name2.length()) continue;
                c = name2.charAt(i);
                buffer.append(c);
            }
            String string = buffer.toString();
            if (string == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(90);
            }
            return string;
        }
        String string = this.variableNameToPropertyNameInner(name2, variableKind);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(91);
        }
        return string;
    }

    @NotNull
    private String variableNameToPropertyNameInner(@NotNull String name2, @NotNull VariableKind variableKind) {
        if (name2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(92);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(93);
        }
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        boolean doDecapitalize = false;
        int pLength = prefix.length();
        if (pLength > 0 && name2.startsWith(prefix) && name2.length() > pLength && (!Character.isLetter(prefix.charAt(pLength - 1)) || Character.isUpperCase(name2.charAt(pLength)))) {
            name2 = name2.substring(pLength);
            doDecapitalize = true;
        }
        if (name2.endsWith(suffix) && name2.length() > suffix.length()) {
            name2 = name2.substring(0, name2.length() - suffix.length());
            doDecapitalize = true;
        }
        if (doDecapitalize) {
            name2 = Introspector.decapitalize(name2);
        }
        String string = name2;
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(94);
        }
        return string;
    }

    @NotNull
    public String propertyNameToVariableName(@NotNull String propertyName, @NotNull VariableKind variableKind) {
        if (propertyName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(95);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(96);
        }
        if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
            Object[] words = NameUtil.nameToWords((String)propertyName);
            String string = StringUtil.join((Object[])words, StringUtil::toUpperCase, (String)"_");
            if (string == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(97);
            }
            return string;
        }
        String prefix = this.getPrefixByVariableKind(variableKind);
        String name2 = propertyName;
        if (!(name2.isEmpty() || prefix.isEmpty() || StringUtil.endsWithChar((CharSequence)prefix, (char)'_'))) {
            name2 = Character.toUpperCase(name2.charAt(0)) + name2.substring(1);
        }
        name2 = prefix + name2 + this.getSuffixByVariableKind(variableKind);
        String string = name2 = this.changeIfNotIdentifier(name2);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(98);
        }
        return string;
    }

    @NotNull
    private Collection<String> getSuggestionsByNames(@NotNull Iterable<String> names, @NotNull VariableKind kind2, boolean correctKeywords) {
        if (names == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(99);
        }
        if (kind2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(100);
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        for (String name2 : names) {
            suggestions.addAll(this.getSuggestionsByName(name2, kind2, correctKeywords));
        }
        LinkedHashSet<String> linkedHashSet = suggestions;
        if (linkedHashSet == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(101);
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<String> getSuggestionsByName(@NotNull String name2, @NotNull VariableKind variableKind, boolean correctKeywords) {
        if (name2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(102);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(103);
        }
        boolean upperCaseStyle = variableKind == VariableKind.STATIC_FINAL_FIELD;
        boolean preferLongerNames = this.getJavaSettings().PREFER_LONGER_NAMES;
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        ArrayList<String> answer = new ArrayList<String>();
        for (String suggestion : NameUtil.getSuggestionsByName((String)name2, (String)prefix, (String)suffix, (boolean)upperCaseStyle, (boolean)preferLongerNames, (boolean)false)) {
            answer.add(correctKeywords ? this.changeIfNotIdentifier(suggestion) : suggestion);
        }
        ContainerUtil.addIfNotNull(answer, (Object)JavaCodeStyleManagerImpl.getWordByPreposition(name2, prefix, suffix, upperCaseStyle));
        ArrayList<String> arrayList = answer;
        if (arrayList == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(104);
        }
        return arrayList;
    }

    private static String getWordByPreposition(@NotNull String name2, String prefix, String suffix, boolean upperCaseStyle) {
        if (name2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(105);
        }
        String[] words = NameUtil.splitNameIntoWords((String)name2);
        for (int i = 1; i < words.length; ++i) {
            for (String preposition : ourPrepositions) {
                if (!preposition.equalsIgnoreCase(words[i])) continue;
                String mainWord = words[i - 1];
                mainWord = upperCaseStyle ? StringUtil.toUpperCase((String)mainWord) : (prefix.isEmpty() || StringUtil.endsWithChar((CharSequence)prefix, (char)'_') ? StringUtil.toLowerCase((String)mainWord) : StringUtil.capitalize((String)mainWord));
                return prefix + mainWord + suffix;
            }
        }
        return null;
    }

    @NotNull
    public String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, boolean lookForward) {
        if (baseName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(106);
        }
        String string = JavaCodeStyleManagerImpl.suggestUniqueVariableName(baseName, place, lookForward, false, v -> false);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(107);
        }
        return string;
    }

    @NotNull
    public String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, Predicate<? super PsiVariable> canBeReused) {
        if (baseName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(108);
        }
        String string = JavaCodeStyleManagerImpl.suggestUniqueVariableName(baseName, place, true, false, canBeReused);
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(109);
        }
        return string;
    }

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(final @NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean ignorePlaceName, boolean lookForward) {
        if (baseNameInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(110);
        }
        String[] names = baseNameInfo.names;
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(names.length);
        for (String name2 : names) {
            String withShadowing;
            String placeName;
            if (ignorePlaceName && place instanceof PsiNamedElement && Comparing.strEqual((String)(placeName = ((PsiNamedElement)place).getName()), (String)name2)) {
                uniqueNames.add(name2);
                continue;
            }
            String unique = this.suggestUniqueVariableName(name2, place, lookForward);
            if (!unique.equals(name2) && (withShadowing = JavaCodeStyleManagerImpl.suggestUniqueVariableName(name2, place, lookForward, true, v -> false)).equals(name2)) {
                uniqueNames.add(name2);
            }
            uniqueNames.add(unique);
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(ArrayUtil.toStringArray(uniqueNames)){

            public void nameChosen(String name2) {
                baseNameInfo.nameChosen(name2);
            }
        };
        if (suggestedNameInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(111);
        }
        return suggestedNameInfo;
    }

    @NotNull
    private static String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, boolean lookForward, boolean allowShadowing, Predicate<? super PsiVariable> canBeReused) {
        if (baseName == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(112);
        }
        PsiElement scope = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class, PsiMethod.class});
        int index = 0;
        while (true) {
            String name2;
            String string = name2 = index > 0 ? baseName + index : baseName;
            if (!(JavaCodeStyleManagerImpl.hasConflictingVariable(place, name2, allowShadowing) || lookForward && JavaCodeStyleManagerImpl.hasConflictingVariableAfterwards(scope, name2, canBeReused))) {
                String string2 = name2;
                if (string2 == null) {
                    JavaCodeStyleManagerImpl.$$$reportNull$$$0(113);
                }
                return string2;
            }
            ++index;
        }
    }

    private static boolean hasConflictingVariable(@Nullable PsiElement place, @NotNull String name2, boolean allowShadowing) {
        if (name2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(114);
        }
        if (place == null) {
            return false;
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)place.getProject()).getResolveHelper();
        PsiVariable existingVariable = helper.resolveAccessibleReferencedVariable(name2, place);
        if (existingVariable == null) {
            return false;
        }
        return !allowShadowing || !(existingVariable instanceof PsiField) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiMethod.class}) == null;
    }

    private static boolean hasConflictingVariableAfterwards(@Nullable PsiElement scope, final @NotNull String name2, final @NotNull Predicate<? super PsiVariable> canBeReused) {
        if (name2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(115);
        }
        if (canBeReused == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(116);
        }
        for (PsiElement run = scope; run != null; run = run.getNextSibling()) {
            class CancelException
            extends RuntimeException {
                CancelException() {
                }
            }
            try {
                run.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitVariable(PsiVariable variable) {
                        if (name2.equals(variable.getName()) && !canBeReused.test(variable)) {
                            throw new CancelException();
                        }
                    }
                });
                continue;
            }
            catch (CancelException e) {
                return true;
            }
        }
        return false;
    }

    private static void sortVariableNameSuggestions(@NotNull String[] names, @NotNull VariableKind variableKind, @Nullable String propertyName, @Nullable PsiType type2) {
        if (names == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(117);
        }
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(118);
        }
        if (names.length <= 1) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorting names:" + variableKind);
            if (propertyName != null) {
                LOG.debug("propertyName:" + propertyName);
            }
            if (type2 != null) {
                LOG.debug("type:" + type2);
            }
            for (String name2 : names) {
                int count = JavaStatisticsManager.getVariableNameUseCount((String)name2, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
                LOG.debug(name2 + " : " + count);
            }
        }
        Comparator comparator = (s1, s2) -> {
            if (variableKind == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(137);
            }
            int count1 = JavaStatisticsManager.getVariableNameUseCount((String)s1, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            int count2 = JavaStatisticsManager.getVariableNameUseCount((String)s2, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            return count2 - count1;
        };
        Arrays.sort(names, comparator);
    }

    @NotNull
    public String getPrefixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(119);
        }
        String prefix = null;
        switch (variableKind) {
            case FIELD: {
                prefix = this.getJavaSettings().FIELD_NAME_PREFIX;
                break;
            }
            case STATIC_FIELD: {
                prefix = this.getJavaSettings().STATIC_FIELD_NAME_PREFIX;
                break;
            }
            case PARAMETER: {
                prefix = this.getJavaSettings().PARAMETER_NAME_PREFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                prefix = this.getJavaSettings().LOCAL_VARIABLE_NAME_PREFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        String string = prefix == null ? "" : prefix;
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(120);
        }
        return string;
    }

    @NotNull
    public String getSuffixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(121);
        }
        String suffix = null;
        switch (variableKind) {
            case FIELD: {
                suffix = this.getJavaSettings().FIELD_NAME_SUFFIX;
                break;
            }
            case STATIC_FIELD: {
                suffix = this.getJavaSettings().STATIC_FIELD_NAME_SUFFIX;
                break;
            }
            case PARAMETER: {
                suffix = this.getJavaSettings().PARAMETER_NAME_SUFFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                suffix = this.getJavaSettings().LOCAL_VARIABLE_NAME_SUFFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        String string = suffix == null ? "" : suffix;
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(122);
        }
        return string;
    }

    @NotNull
    public Collection<String> suggestSemanticNames(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(123);
        }
        Collection collection = this.suggestVariableNameByExpression(expression2, null).names;
        if (collection == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(124);
        }
        return collection;
    }

    @NotNull
    private Collection<String> suggestSemanticNamesByType(@Nullable PsiType type2, @NotNull VariableKind kind2) {
        if (kind2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(125);
        }
        Collection<String> collection = type2 == null ? Collections.emptyList() : this.doSuggestNamesByType(type2, kind2, false);
        if (collection == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(126);
        }
        return collection;
    }

    @NotNull
    public SuggestedNameInfo suggestNames(@NotNull Collection<String> semanticNames, final @NotNull VariableKind kind2, final @Nullable PsiType type2) {
        if (semanticNames == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(127);
        }
        if (kind2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(128);
        }
        Iterable allSemanticNames = ContainerUtil.concat((Iterable[])new Iterable[]{semanticNames, this.suggestSemanticNamesByType(type2, kind2)});
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>(this.getSuggestionsByNames(allSemanticNames, kind2, true));
        final String propertyName = (String)ContainerUtil.getFirstItem(semanticNames);
        JavaCodeStyleManagerImpl.addNamesFromStatistics(suggestions, kind2, propertyName, type2);
        String[] namesArray = ArrayUtil.toStringArray(suggestions);
        JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesArray, kind2, propertyName, type2);
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(namesArray){

            public void nameChosen(String name2) {
                if (type2 == null || !type2.isValid()) {
                    return;
                }
                JavaStatisticsManager.incVariableNameUseCount((String)name2, (VariableKind)kind2, (String)propertyName, (PsiType)type2);
            }
        };
        if (suggestedNameInfo == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(129);
        }
        return suggestedNameInfo;
    }

    @Nullable
    private CodeStyleSettings.TypeToNameMap getMapByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(130);
        }
        if (variableKind == VariableKind.FIELD) {
            return this.getJavaSettings().FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.STATIC_FIELD) {
            return this.getJavaSettings().STATIC_FIELD_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.PARAMETER) {
            return this.getJavaSettings().PARAMETER_TYPE_TO_NAME;
        }
        if (variableKind == VariableKind.LOCAL_VARIABLE) {
            return this.getJavaSettings().LOCAL_VARIABLE_TYPE_TO_NAME;
        }
        return null;
    }

    @NonNls
    @NotNull
    private String changeIfNotIdentifier(@NotNull String name2) {
        if (name2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(131);
        }
        if (!this.isIdentifier(name2)) {
            String string = StringUtil.fixVariableNameDerivedFromPropertyName((String)name2);
            if (string == null) {
                JavaCodeStyleManagerImpl.$$$reportNull$$$0(132);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(133);
        }
        return string;
    }

    private boolean isIdentifier(@NotNull String name2) {
        if (name2 == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(134);
        }
        return PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name2, LanguageLevel.HIGHEST);
    }

    @NotNull
    private JavaCodeStyleSettings getJavaSettings() {
        JavaCodeStyleSettings javaCodeStyleSettings = (JavaCodeStyleSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class);
        if (javaCodeStyleSettings == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(135);
        }
        return javaCodeStyleSettings;
    }

    private static boolean isStringPsiLiteral(@NotNull PsiElement element) {
        if (element == null) {
            JavaCodeStyleManagerImpl.$$$reportNull$$$0(136);
        }
        if (element instanceof PsiLiteralExpression) {
            String text2 = element.getText();
            return StringUtil.isQuotedString((String)text2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 129: 
            case 132: 
            case 133: 
            case 135: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 129: 
            case 132: 
            case 133: 
            case 135: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 129: 
            case 132: 
            case 133: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 37: 
            case 42: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: 
            case 100: 
            case 125: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 24: 
            case 77: 
            case 99: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 38: 
            case 39: 
            case 88: 
            case 93: 
            case 96: 
            case 103: 
            case 118: 
            case 119: 
            case 121: 
            case 130: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableKind";
                break;
            }
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 41: 
            case 47: 
            case 49: 
            case 51: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestions";
                break;
            }
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 73: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 75: 
            case 76: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringValue";
                break;
            }
            case 87: 
            case 92: 
            case 102: 
            case 105: 
            case 114: 
            case 115: 
            case 131: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 106: 
            case 108: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseNameInfo";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canBeReused";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semanticNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenClassReferences";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyClassReferences";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestCompiledParameterName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableName";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableNameByType";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "doSuggestNamesByType";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNamesFromTypeName";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableNameByExpression";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableNameByExpressionOnly";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "constantValueToConstantName";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsByValue";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestVariableNameByExpressionPlace";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "variableNameToPropertyName";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "variableNameToPropertyNameInner";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyNameToVariableName";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsByNames";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsByName";
                break;
            }
            case 107: 
            case 109: 
            case 111: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUniqueVariableName";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixByVariableKind";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffixByVariableKind";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSemanticNames";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSemanticNamesByType";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "changeIfNotIdentifier";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shortenClassReferences";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 129: 
            case 132: 
            case 133: 
            case 135: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "qualifyClassReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareOptimizeImportsResult";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasConflictingOnDemandImport";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundantImports";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findRedundantImports";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findEntryIndex";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "suggestCompiledParameterName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addNamesFromStatistics";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameByType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestNamesByType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamesFromTypeMap";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "suggestFromOptionalContent";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamesFromTypeName";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "extractOptionalContent";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamesFromHierarchy";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamesFromGenericParameters";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamesForCollectionInheritors";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getLongTypeName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameByExpression";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameFromLiterals";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findLiteralText";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameByExpressionOnly";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isJavaUtilMethodCall";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isJavaUtilMethod";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "constantValueToConstantName";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsByValue";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableNameByExpressionPlace";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "variableNameToPropertyName";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "variableNameToPropertyNameInner";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "propertyNameToVariableName";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsByNames";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsByName";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getWordByPreposition";
                break;
            }
            case 106: 
            case 108: 
            case 110: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "suggestUniqueVariableName";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "hasConflictingVariable";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "hasConflictingVariableAfterwards";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "sortVariableNameSuggestions";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixByVariableKind";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getSuffixByVariableKind";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "suggestSemanticNames";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "suggestSemanticNamesByType";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "suggestNames";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getMapByVariableKind";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "changeIfNotIdentifier";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "isStringPsiLiteral";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sortVariableNameSuggestions$4";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestNamesFromHierarchy$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 78: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 129: 
            case 132: 
            case 133: 
            case 135: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NamesByExprInfo {
        static final NamesByExprInfo EMPTY = new NamesByExprInfo(null, Collections.emptyList());
        private final String propertyName;
        private final Collection<String> names;

        private NamesByExprInfo(@Nullable String propertyName, @NotNull Collection<String> names) {
            if (names == null) {
                NamesByExprInfo.$$$reportNull$$$0(0);
            }
            this.propertyName = propertyName;
            this.names = names;
        }

        private NamesByExprInfo(@NotNull String propertyName) {
            if (propertyName == null) {
                NamesByExprInfo.$$$reportNull$$$0(1);
            }
            this(propertyName, Collections.singletonList(propertyName));
        }

        private NamesByExprInfo(@Nullable String propertyName, String ... names) {
            if (names == null) {
                NamesByExprInfo.$$$reportNull$$$0(2);
            }
            this(propertyName, propertyName == null ? Arrays.asList(names) : ContainerUtil.prepend(Arrays.asList(names), (Object[])new String[]{propertyName}));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "names";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "propertyName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/codeStyle/JavaCodeStyleManagerImpl$NamesByExprInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

