/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.psi.impl.source.codeStyle.javadoc.TagDescription;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDParamListOwnerComment
extends JDComment {
    protected List<TagDescription> myParamsList;

    public JDParamListOwnerComment(@NotNull CommentFormatter formatter) {
        if (formatter == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(0);
        }
        super(formatter);
    }

    @Override
    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        if (prefix == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(1);
        }
        if (sb == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(2);
        }
        if (this.myParamsList != null) {
            int before = sb.length();
            this.generateList(prefix, sb, this.myParamsList, JDTag.PARAM.getWithEndWhitespace(), this.myFormatter.getSettings().JD_ALIGN_PARAM_COMMENTS, this.myFormatter.getSettings().JD_KEEP_EMPTY_PARAMETER, this.myFormatter.getSettings().JD_PARAM_DESCRIPTION_ON_NEW_LINE);
            int size = sb.length() - before;
            if (size > 0 && this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_PARM_COMMENTS) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
    }

    @Nullable
    public TagDescription getParameter(@Nullable String name2) {
        return JDParamListOwnerComment.getNameDesc(name2, this.myParamsList);
    }

    public void addParameter(@NotNull String name2, @Nullable String description) {
        if (name2 == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(3);
        }
        if (this.myParamsList == null) {
            this.myParamsList = ContainerUtilRt.newArrayList();
        }
        this.myParamsList.add(new TagDescription(name2, description));
    }

    @Nullable
    private static TagDescription getNameDesc(@Nullable String name2, @Nullable List<TagDescription> list) {
        if (list == null) {
            return null;
        }
        for (TagDescription aList : list) {
            if (!aList.name.equals(name2)) continue;
            return aList;
        }
        return null;
    }

    protected void generateList(@NotNull String prefix, @NotNull StringBuilder sb, @NotNull List<? extends TagDescription> tagBlocks, @NotNull String tag, boolean align_comments, boolean generate_empty_tags, boolean descriptionOnNewLine) {
        if (prefix == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(4);
        }
        if (sb == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(5);
        }
        if (tagBlocks == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(6);
        }
        if (tag == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(7);
        }
        int maxNameLength = JDParamListOwnerComment.maxTagDescriptionNameLength(tagBlocks, align_comments, generate_empty_tags, descriptionOnNewLine);
        StringBuilder fill = new StringBuilder(prefix.length() + tag.length() + maxNameLength + 1);
        fill.append(prefix);
        StringUtil.repeatSymbol((Appendable)fill, (char)' ', (int)(maxNameLength + 1 + tag.length()));
        for (TagDescription tagDescription : tagBlocks) {
            if (JDParamListOwnerComment.isNull(tagDescription.desc) && !generate_empty_tags) continue;
            if (descriptionOnNewLine && !JDParamListOwnerComment.isNull(tagDescription.desc)) {
                sb.append(prefix).append(tag).append(tagDescription.name).append("\n");
                sb.append((CharSequence)this.formatJDTagDescription(tagDescription.desc, prefix + this.continuationIndent()));
                continue;
            }
            if (align_comments) {
                int spacesNumber = maxNameLength + 1 - tagDescription.name.length();
                String spaces = StringUtil.repeatSymbol((char)' ', (int)Math.max(0, spacesNumber));
                String firstLinePrefix = prefix + tag + tagDescription.name + spaces;
                sb.append((CharSequence)this.formatJDTagDescription(tagDescription.desc, firstLinePrefix, fill));
                continue;
            }
            String description = tagDescription.desc == null ? "" : tagDescription.desc;
            StringBuilder tagDescription2 = this.formatJDTagDescription(tag + tagDescription.name + " " + description, prefix, prefix + this.javadocContinuationIndent());
            sb.append((CharSequence)tagDescription2);
        }
    }

    private static int maxTagDescriptionNameLength(@NotNull List<? extends TagDescription> tagBlocks, boolean align_comments, boolean generate_empty_tags, boolean descriptionOnNewLine) {
        if (tagBlocks == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(8);
        }
        int max = 0;
        if (align_comments && !descriptionOnNewLine) {
            for (TagDescription tagDescription : tagBlocks) {
                int current = tagDescription.name.length();
                if (JDParamListOwnerComment.isNull(tagDescription.desc) && !generate_empty_tags || current <= max) continue;
                max = current;
            }
        }
        return max;
    }

    private StringBuilder formatJDTagDescription(@Nullable String description, @NotNull CharSequence firstLinePrefix, @NotNull CharSequence continuationPrefix) {
        if (firstLinePrefix == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(9);
        }
        if (continuationPrefix == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(10);
        }
        return this.myFormatter.getParser().formatJDTagDescription(description, firstLinePrefix, continuationPrefix);
    }

    private StringBuilder formatJDTagDescription(@Nullable String description, @NotNull CharSequence prefix) {
        if (prefix == null) {
            JDParamListOwnerComment.$$$reportNull$$$0(11);
        }
        return this.formatJDTagDescription(description, prefix, prefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 1: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagBlocks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLinePrefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continuationPrefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateSpecial";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generateList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "maxTagDescriptionNameLength";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "formatJDTagDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

