/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.ClassElement");
    private static final TokenSet MODIFIERS_TO_REMOVE_IN_INTERFACE_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{PUBLIC_KEYWORD, ABSTRACT_KEYWORD, STATIC_KEYWORD, FINAL_KEYWORD, NATIVE_KEYWORD});
    private static final TokenSet MODIFIERS_TO_REMOVE_IN_INTERFACE_BIT_SET_18_METHOD = TokenSet.create((IElementType[])new IElementType[]{PUBLIC_KEYWORD, ABSTRACT_KEYWORD, FINAL_KEYWORD, NATIVE_KEYWORD});
    private static final TokenSet MODIFIERS_TO_REMOVE_IN_ENUM_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{PUBLIC_KEYWORD, FINAL_KEYWORD});
    private static final TokenSet ENUM_CONSTANT_LIST_ELEMENTS_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{ENUM_CONSTANT, COMMA, SEMICOLON});

    public ClassElement(IElementType type2) {
        super(type2);
    }

    public int getTextOffset() {
        ASTNode name2 = this.findChildByRole(9);
        if (name2 != null) {
            return name2.getStartOffset();
        }
        return super.getTextOffset();
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        TreeElement firstAdded;
        ASTNode next;
        TreeElement child;
        PsiClass psiClass = (PsiClass)SourceTreeToPsiMap.treeElementToPsi((ASTNode)this);
        if (anchor == null && first.getElementType() != JavaDocElementType.DOC_COMMENT) {
            if (before == null) {
                if (first == last) {
                    PsiElement firstPsi = SourceTreeToPsiMap.treeElementToPsi((ASTNode)first);
                    if (firstPsi instanceof PsiEnumConstant) {
                        anchor = this.findEnumConstantListDelimiterPlace();
                        before = anchor != this.findChildByRole(18);
                    } else {
                        PsiElement psiElement = firstPsi instanceof PsiMember ? JavaPsiImplementationHelper.getInstance(psiClass.getProject()).getDefaultMemberAnchor(psiClass, (PsiMember)firstPsi) : null;
                        anchor = psiElement != null ? SourceTreeToPsiMap.psiElementToTree(psiElement) : null;
                        before = Boolean.TRUE;
                    }
                } else {
                    anchor = this.findChildByRole(19);
                    before = Boolean.TRUE;
                }
            } else {
                anchor = before == false ? this.findChildByRole(18) : this.findChildByRole(19);
            }
        }
        if (this.isEnum() && !ENUM_CONSTANT_LIST_ELEMENTS_BIT_SET.contains(first.getElementType())) {
            ASTNode semicolonPlace = this.findEnumConstantListDelimiterPlace();
            boolean commentsOrWhiteSpaces = true;
            for (child = first; child != null; child = child.getTreeNext()) {
                if (PsiImplUtil.isWhitespaceOrComment((ASTNode)child)) continue;
                commentsOrWhiteSpaces = false;
                break;
            }
            if (!(commentsOrWhiteSpaces || semicolonPlace != null && semicolonPlace.getElementType() == SEMICOLON)) {
                LeafElement semicolon = Factory.createSingleLeafElement((IElementType)SEMICOLON, (CharSequence)";", (int)0, (int)1, (CharTable)SharedImplUtil.findCharTableByTree((ASTNode)this), (PsiManager)this.getManager());
                this.addInternal((TreeElement)semicolon, (ASTNode)semicolon, semicolonPlace, Boolean.FALSE);
                semicolonPlace = semicolon;
            }
            for (ASTNode run = anchor; run != null; run = run.getTreeNext()) {
                if (run != semicolonPlace) continue;
                ASTNode aSTNode = anchor = before != false ? semicolonPlace.getTreeNext() : semicolonPlace;
                if (anchor == null || !PsiImplUtil.isWhitespaceOrComment(anchor)) break;
                anchor = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)anchor.getPsi()).getNode();
                break;
            }
        }
        ASTNode afterLast = last.getTreeNext();
        child = first;
        while (child != afterLast) {
            next = child.getTreeNext();
            if (child.getElementType() == JavaElementType.METHOD && ((PsiMethod)SourceTreeToPsiMap.treeElementToPsi((ASTNode)child)).isConstructor()) {
                ASTNode oldIdentifier = ((CompositeElement)child).findChildByRole(9);
                ASTNode newIdentifier = this.findChildByRole(9).copyElement();
                newIdentifier.putUserData(CharTable.CHAR_TABLE_KEY, (Object)SharedImplUtil.findCharTableByTree((ASTNode)this));
                child.replaceChild(oldIdentifier, newIdentifier);
            }
            child = next;
        }
        if (psiClass.isEnum()) {
            child = first;
            while (child != afterLast) {
                next = child.getTreeNext();
                if (child.getElementType() == JavaElementType.METHOD && ((PsiMethod)SourceTreeToPsiMap.treeElementToPsi((ASTNode)child)).isConstructor() || child.getElementType() == JavaElementType.ENUM_CONSTANT) {
                    ASTNode modifier;
                    CompositeElement modifierList = (CompositeElement)((CompositeElement)child).findChildByRole(8);
                    while ((modifier = modifierList.findChildByType(MODIFIERS_TO_REMOVE_IN_ENUM_BIT_SET)) != null) {
                        modifierList.deleteChildInternal(modifier);
                    }
                }
                child = next;
            }
        } else if (psiClass.isInterface()) {
            boolean level8OrHigher = PsiUtil.isLanguageLevel8OrHigher((PsiElement)psiClass);
            TreeElement child2 = first;
            while (child2 != afterLast) {
                next = child2.getTreeNext();
                IElementType childElementType = child2.getElementType();
                if (childElementType == JavaElementType.METHOD || childElementType == JavaElementType.FIELD) {
                    ASTNode modifier;
                    TokenSet removeModifiersBitSet;
                    CompositeElement modifierList = (CompositeElement)((CompositeElement)child2).findChildByRole(8);
                    TokenSet tokenSet = removeModifiersBitSet = level8OrHigher && childElementType == JavaElementType.METHOD ? MODIFIERS_TO_REMOVE_IN_INTERFACE_BIT_SET_18_METHOD : MODIFIERS_TO_REMOVE_IN_INTERFACE_BIT_SET;
                    while ((modifier = modifierList.findChildByType(removeModifiersBitSet)) != null) {
                        modifierList.deleteChildInternal(modifier);
                    }
                }
                child2 = next;
            }
        }
        if ((firstAdded = super.addInternal(first, last, anchor, before)).getElementType() == ENUM_CONSTANT) {
            LeafElement comma;
            IElementType elementType;
            ASTNode child3;
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
            for (child3 = first.getTreeNext(); child3 != null && (elementType = child3.getElementType()) != COMMA && elementType != SEMICOLON; child3 = child3.getTreeNext()) {
                if (elementType != ENUM_CONSTANT) continue;
                comma = Factory.createSingleLeafElement((IElementType)COMMA, (CharSequence)",", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                super.addInternal((TreeElement)comma, (ASTNode)comma, (ASTNode)first, Boolean.FALSE);
                break;
            }
            for (child3 = first.getTreePrev(); child3 != null && (elementType = child3.getElementType()) != COMMA && elementType != SEMICOLON; child3 = child3.getTreePrev()) {
                if (elementType != ENUM_CONSTANT) continue;
                comma = Factory.createSingleLeafElement((IElementType)COMMA, (CharSequence)",", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                super.addInternal((TreeElement)comma, (ASTNode)comma, child3, Boolean.FALSE);
                break;
            }
        }
        return firstAdded;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode nextField;
        if (child == null) {
            ClassElement.$$$reportNull$$$0(0);
        }
        if (this.isEnum() && child.getElementType() == ENUM_CONSTANT) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
        }
        if (child.getElementType() == FIELD && (nextField = TreeUtil.findSibling((ASTNode)child.getTreeNext(), (IElementType)FIELD)) != null && ((PsiField)nextField.getPsi()).getTypeElement().equals(((PsiField)child.getPsi()).getTypeElement())) {
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
            ASTNode modifierList = child.findChildByType(MODIFIER_LIST);
            if (modifierList != null) {
                LeafElement whitespace = Factory.createSingleLeafElement((IElementType)WHITE_SPACE, (CharSequence)" ", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                ASTNode first = nextField.getFirstChildNode();
                nextField.addChild((ASTNode)whitespace, first);
                ASTNode typeElement = child.findChildByType(TYPE);
                if (typeElement == null) {
                    TreeElement modifierListCopy = ChangeUtil.copyElement((TreeElement)((TreeElement)modifierList), (CharTable)treeCharTab);
                    nextField.addChild((ASTNode)modifierListCopy, (ASTNode)whitespace);
                } else {
                    ASTNode run = modifierList;
                    while (true) {
                        TreeElement copy = ChangeUtil.copyElement((TreeElement)((TreeElement)run), (CharTable)treeCharTab);
                        nextField.addChild((ASTNode)copy, (ASTNode)whitespace);
                        if (run == typeElement) break;
                        run = run.getTreeNext();
                    }
                }
            }
        }
        super.deleteChildInternal(child);
    }

    public boolean isEnum() {
        ASTNode keyword = this.findChildByRole(11);
        return keyword != null && keyword.getElementType() == ENUM_KEYWORD;
    }

    public boolean isAnnotationType() {
        return this.findChildByRole(247) != null;
    }

    public ASTNode findChildByRole(int role) {
        ASTNode treeNext;
        assert (ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 7: {
                return PsiImplUtil.findDocComment(this);
            }
            case 126: {
                return this.isEnum() ? this.findEnumConstantListDelimiter() : null;
            }
            case 8: {
                return this.findChildByType(MODIFIER_LIST);
            }
            case 12: {
                return this.findChildByType(EXTENDS_LIST);
            }
            case 13: {
                return this.findChildByType(IMPLEMENTS_LIST);
            }
            case 245: {
                return this.findChildByType(TYPE_PARAMETER_LIST);
            }
            case 11: {
                for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    if (!CLASS_KEYWORD_BIT_SET.contains(child.getElementType())) continue;
                    return child;
                }
                String message2 = "Node not found. Immediate children are:---\n";
                for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    message2 = message2 + child.getClass() + "(" + child.getElementType() + ") " + child + "\n";
                }
                message2 = message2 + "---";
                LOG.error(message2);
                return null;
            }
            case 9: {
                return this.findChildByType(IDENTIFIER);
            }
            case 18: {
                return this.findChildByType(LBRACE);
            }
            case 19: {
                return TreeUtil.findChildBackward((ASTNode)this, (IElementType)RBRACE);
            }
            case 247: 
        }
        ASTNode modifierList = this.findChildByRole(8);
        if (modifierList != null && (treeNext = modifierList.getTreeNext()) != null && (treeNext = PsiImplUtil.skipWhitespaceAndComments(treeNext)).getElementType() == AT) {
            return treeNext;
        }
        return null;
    }

    private ASTNode findEnumConstantListDelimiter() {
        ASTNode candidate = this.findEnumConstantListDelimiterPlace();
        return candidate != null && candidate.getElementType() == SEMICOLON ? candidate : null;
    }

    @Nullable
    public ASTNode findEnumConstantListDelimiterPlace() {
        ASTNode first = this.findChildByRole(18);
        if (first == null) {
            return null;
        }
        for (ASTNode child = first.getTreeNext(); child != null; child = child.getTreeNext()) {
            IElementType childType = child.getElementType();
            if (PsiImplUtil.isWhitespaceOrComment(child) || childType == ERROR_ELEMENT || childType == ENUM_CONSTANT || childType == COMMA) continue;
            if (childType == SEMICOLON) {
                return child;
            }
            return PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            ClassElement.$$$reportNull$$$0(1);
        }
        assert (child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == SEMICOLON) {
            if (!this.isEnum()) {
                return 0;
            }
            if (child == this.findEnumConstantListDelimiter()) {
                return 126;
            }
            return 0;
        }
        if (i == CLASS) {
            return 3;
        }
        if (i == FIELD) {
            return 4;
        }
        if (i == METHOD || i == ANNOTATION_METHOD) {
            return 5;
        }
        if (i == CLASS_INITIALIZER) {
            return 6;
        }
        if (i == TYPE_PARAMETER_LIST) {
            return 245;
        }
        if (i == JavaDocElementType.DOC_COMMENT) {
            return this.getChildRole(child, 7);
        }
        if (ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(i)) {
            return 0;
        }
        if (i == MODIFIER_LIST) {
            return 8;
        }
        if (i == EXTENDS_LIST) {
            return 12;
        }
        if (i == IMPLEMENTS_LIST) {
            return 13;
        }
        if (ElementType.CLASS_KEYWORD_BIT_SET.contains(i)) {
            return this.getChildRole(child, 11);
        }
        if (i == IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i == LBRACE) {
            return this.getChildRole(child, 18);
        }
        if (i == RBRACE) {
            return this.getChildRole(child, 19);
        }
        if (i == COMMA) {
            return 23;
        }
        if (i == AT) {
            return 247;
        }
        return 0;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "child";
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/ClassElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

