/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationImpl
extends JavaStubPsiElement<PsiAnnotationStub>
implements PsiAnnotation {
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = (project, text2) -> JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText(text2, null);

    public PsiAnnotationImpl(PsiAnnotationStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANNOTATION);
    }

    public PsiAnnotationImpl(ASTNode node) {
        super(node);
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        return (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)(stub != null ? stub.getPsiElement() : this), PsiJavaCodeReferenceElement.class);
    }

    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value2) {
        PsiAnnotationMemberValue t = PsiImplUtil.setDeclaredAttributeValue(this, attributeName, value2, ANNOTATION_CREATOR);
        return (T)t;
    }

    public String toString() {
        return "PsiAnnotation";
    }

    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        PsiAnnotationParameterList psiAnnotationParameterList = (PsiAnnotationParameterList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.ANNOTATION_PARAMETER_LIST);
        if (psiAnnotationParameterList == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(0);
        }
        return psiAnnotationParameterList;
    }

    @Nullable
    public String getQualifiedName() {
        PsiJavaCodeReferenceElement nameRef = this.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        return nameRef.getCanonicalText();
    }

    @Nullable
    private String getShortName() {
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            return PsiAnnotationImpl.getAnnotationShortName(stub.getText());
        }
        PsiJavaCodeReferenceElement nameRef = this.getNameReferenceElement();
        return nameRef == null ? null : nameRef.getReferenceName();
    }

    public boolean hasQualifiedName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(1);
        }
        return StringUtil.getShortName((String)qualifiedName).equals(this.getShortName()) && super.hasQualifiedName(qualifiedName);
    }

    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation((PsiAnnotation)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase((PsiElement)this);
    }

    @Nullable
    public PsiAnnotationOwner getOwner() {
        PsiElement ctx;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiAnnotationOwner) {
            return (PsiAnnotationOwner)parent;
        }
        if (parent instanceof PsiNewExpression) {
            return ((PsiNewExpression)parent).getOwner((PsiAnnotation)this);
        }
        if (parent instanceof PsiReferenceExpression ? (ctx = parent.getParent()) instanceof PsiMethodReferenceExpression : parent instanceof PsiJavaCodeReferenceElement && ((ctx = PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{PsiJavaCodeReferenceElement.class})) instanceof PsiReferenceList || ctx instanceof PsiNewExpression || ctx instanceof PsiTypeElement || ctx instanceof PsiAnonymousClass)) {
            return new PsiClassReferenceType((PsiJavaCodeReferenceElement)parent, null);
        }
        PsiTypeElement typeElement = null;
        PsiParameterList anchor = null;
        if (parent instanceof PsiMethod) {
            typeElement = ((PsiMethod)parent).getReturnTypeElement();
            anchor = ((PsiMethod)parent).getParameterList();
        } else if (parent instanceof PsiField || parent instanceof PsiParameter || parent instanceof PsiLocalVariable) {
            typeElement = ((PsiVariable)parent).getTypeElement();
            anchor = ((PsiVariable)parent).getNameIdentifier();
        }
        if (typeElement != null && anchor != null) {
            return JavaSharedImplUtil.getType(typeElement, (PsiElement)anchor, this);
        }
        return null;
    }

    @NotNull
    public static String getAnnotationShortName(@NotNull String annoText) {
        if (annoText == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(3);
        }
        int at = annoText.indexOf(64);
        int paren = annoText.indexOf(40);
        String qualified = PsiNameHelper.getQualifiedClassName((String)annoText.substring(at + 1, paren > 0 ? paren : annoText.length()), (boolean)true);
        String string = StringUtil.getShortName((String)qualified);
        if (string == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifiedName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationShortName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

