/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.jsp;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JspSpiUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.tagLibrary.JspTagInfoImpl");
    @NonNls
    private static final String JAR_EXTENSION = "jar";

    @Nullable
    private static JspSpiUtil getJspSpiUtil() {
        Ref result = Ref.create();
        ProgressManager.getInstance().executeNonCancelableSection(() -> result.set(ServiceManager.getService(JspSpiUtil.class)));
        return (JspSpiUtil)result.get();
    }

    public static int escapeCharsInJspContext(JspFile file, int offset, String toEscape) throws IncorrectOperationException {
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        return util != null ? util._escapeCharsInJspContext(file, offset, toEscape) : 0;
    }

    protected abstract int _escapeCharsInJspContext(JspFile var1, int var2, String var3) throws IncorrectOperationException;

    public static void visitAllIncludedFilesRecursively(BaseJspFile jspFile, Processor<BaseJspFile> visitor) {
        JspSpiUtil util = JspSpiUtil.getJspSpiUtil();
        if (util != null) {
            util._visitAllIncludedFilesRecursively(jspFile, visitor);
        }
    }

    protected abstract void _visitAllIncludedFilesRecursively(BaseJspFile var1, Processor<BaseJspFile> var2);

    @Nullable
    public static PsiElement resolveMethodPropertyReference(@NotNull PsiReference reference, @Nullable PsiClass resolvedClass, boolean readable) {
        JspSpiUtil util;
        if (reference == null) {
            JspSpiUtil.$$$reportNull$$$0(0);
        }
        return (util = JspSpiUtil.getJspSpiUtil()) == null ? null : util._resolveMethodPropertyReference(reference, resolvedClass, readable);
    }

    @Nullable
    protected abstract PsiElement _resolveMethodPropertyReference(@NotNull PsiReference var1, @Nullable PsiClass var2, boolean var3);

    @NotNull
    public static Object[] getMethodPropertyReferenceVariants(@NotNull PsiReference reference, @Nullable PsiClass resolvedClass, boolean readable) {
        JspSpiUtil util;
        if (reference == null) {
            JspSpiUtil.$$$reportNull$$$0(1);
        }
        Object[] objectArray = (util = JspSpiUtil.getJspSpiUtil()) == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : util._getMethodPropertyReferenceVariants(reference, resolvedClass, readable);
        if (objectArray == null) {
            JspSpiUtil.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    protected abstract Object[] _getMethodPropertyReferenceVariants(@NotNull PsiReference var1, @Nullable PsiClass var2, boolean var3);

    public static boolean isIncludedOrIncludesSomething(@NotNull JspFile file) {
        if (file == null) {
            JspSpiUtil.$$$reportNull$$$0(3);
        }
        return JspSpiUtil.isIncludingAnything(file) || JspSpiUtil.isIncluded(file);
    }

    public static boolean isIncluded(@NotNull JspFile jspFile) {
        JspSpiUtil util;
        if (jspFile == null) {
            JspSpiUtil.$$$reportNull$$$0(4);
        }
        return (util = JspSpiUtil.getJspSpiUtil()) != null && util._isIncluded(jspFile);
    }

    public abstract boolean _isIncluded(@NotNull JspFile var1);

    public static boolean isIncludingAnything(@NotNull JspFile jspFile) {
        JspSpiUtil util;
        if (jspFile == null) {
            JspSpiUtil.$$$reportNull$$$0(5);
        }
        return (util = JspSpiUtil.getJspSpiUtil()) != null && util._isIncludingAnything(jspFile);
    }

    protected abstract boolean _isIncludingAnything(@NotNull JspFile var1);

    public static PsiFile[] getIncludedFiles(@NotNull JspFile jspFile) {
        JspSpiUtil util;
        if (jspFile == null) {
            JspSpiUtil.$$$reportNull$$$0(6);
        }
        return (util = JspSpiUtil.getJspSpiUtil()) == null ? PsiFile.EMPTY_ARRAY : util._getIncludedFiles(jspFile);
    }

    public static PsiFile[] getIncludingFiles(@NotNull JspFile jspFile) {
        JspSpiUtil util;
        if (jspFile == null) {
            JspSpiUtil.$$$reportNull$$$0(7);
        }
        return (util = JspSpiUtil.getJspSpiUtil()) == null ? PsiFile.EMPTY_ARRAY : util._getIncludingFiles((PsiFile)jspFile);
    }

    protected abstract PsiFile[] _getIncludingFiles(@NotNull PsiFile var1);

    @NotNull
    protected abstract PsiFile[] _getIncludedFiles(@NotNull JspFile var1);

    public static boolean isJavaContext(PsiElement position) {
        return PsiTreeUtil.getContextOfType((PsiElement)position, JspClass.class, (boolean)false) != null;
    }

    public static boolean isJarFile(@Nullable VirtualFile file) {
        String ext;
        return file != null && (ext = file.getExtension()) != null && ext.equalsIgnoreCase(JAR_EXTENSION);
    }

    public static List<URL> buildUrls(@Nullable VirtualFile virtualFile, @Nullable Module module) {
        return JspSpiUtil.buildUrls(virtualFile, module, true);
    }

    public static List<URL> buildUrls(@Nullable VirtualFile virtualFile, @Nullable Module module, boolean includeModuleOutput) {
        ArrayList<URL> urls = new ArrayList<URL>();
        JspSpiUtil.processClassPathItems(virtualFile, module, (Consumer<? super VirtualFile>)((Consumer)file -> JspSpiUtil.addUrl(urls, file)), includeModuleOutput);
        return urls;
    }

    public static void processClassPathItems(VirtualFile virtualFile, Module module, Consumer<? super VirtualFile> consumer) {
        JspSpiUtil.processClassPathItems(virtualFile, module, consumer, true);
    }

    public static void processClassPathItems(VirtualFile virtualFile, Module module, Consumer<? super VirtualFile> consumer, boolean includeModuleOutput) {
        if (JspSpiUtil.isJarFile(virtualFile)) {
            consumer.consume((Object)virtualFile);
        }
        if (module != null) {
            OrderEnumerator enumerator = ModuleRootManager.getInstance((Module)module).orderEntries().recursively();
            if (!includeModuleOutput) {
                enumerator = enumerator.withoutModuleSourceEntries();
            }
            for (VirtualFile root : enumerator.getClassesRoots()) {
                VirtualFile file = root.getFileSystem().getProtocol().equals(JAR_EXTENSION) ? JarFileSystem.getInstance().getVirtualFileForJar(root) : root;
                consumer.consume((Object)file);
            }
        }
    }

    private static void addUrl(List<? super URL> urls, VirtualFile file) {
        if (file == null || !file.isValid()) {
            return;
        }
        URL url = JspSpiUtil.getUrl(file);
        if (url != null) {
            urls.add(url);
        }
    }

    @Nullable
    private static URL getUrl(VirtualFile file) {
        if (file.getFileSystem() instanceof JarFileSystem && file.getParent() != null) {
            return null;
        }
        String path = file.getPath();
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - 2);
        }
        String url = SystemInfo.isWindows ? "file:/" + path : "file://" + path;
        if (file.isDirectory() && !(file.getFileSystem() instanceof JarFileSystem)) {
            url = url + "/";
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static IElementType getJspElementType(@NotNull JspElementType.Kind kind2) {
        JspSpiUtil spiUtil;
        if (kind2 == null) {
            JspSpiUtil.$$$reportNull$$$0(8);
        }
        return (spiUtil = JspSpiUtil.getJspSpiUtil()) != null ? spiUtil._getJspElementType(kind2) : null;
    }

    @Nullable
    public static IElementType getJspScriptletType() {
        return JspSpiUtil.getJspElementType(JspElementType.Kind.JSP_SCRIPTLET);
    }

    @Nullable
    public static IElementType getJspExpressionType() {
        return JspSpiUtil.getJspElementType(JspElementType.Kind.JSP_EXPRESSION);
    }

    protected abstract IElementType _getJspElementType(@NotNull JspElementType.Kind var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/jsp/JspSpiUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jspFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/jsp/JspSpiUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodPropertyReferenceVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveMethodPropertyReference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMethodPropertyReferenceVariants";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIncludedOrIncludesSomething";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIncluded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIncludingAnything";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIncludingFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJspElementType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

