/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NameEnvironment
extends UserDataHolderBase {
    static final int OBJECT_NAME = NameEnvironment.hashIdentifier("Object");
    static final int NO_NAME = 0;
    static final int java_lang = NameEnvironment.fromString("java.lang");
    static final QualifiedName java_lang_Enum = new QualifiedName.Interned(NameEnvironment.fromString("java.lang.Enum"));
    static final QualifiedName java_lang_annotation_Annotation = new QualifiedName.Interned(NameEnvironment.fromString("java.lang.annotation.Annotation"));

    NameEnvironment() {
    }

    static int fromString(String s) {
        int id = 0;
        for (int shortName : NameEnvironment.hashQualifiedName(s)) {
            id = NameEnvironment.qualifiedName(id, shortName);
        }
        return id;
    }

    static int hashIdentifier(@Nullable String s) {
        if (StringUtil.isEmpty((String)s)) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < s.length(); ++i) {
            hash = hash * 239 + s.charAt(i);
        }
        return hash == 0 ? 1 : hash;
    }

    static int[] hashQualifiedName(@NotNull String qName) {
        if (qName == null) {
            NameEnvironment.$$$reportNull$$$0(0);
        }
        if ((qName = PsiNameHelper.getQualifiedClassName((String)qName, (boolean)true)).isEmpty()) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        List components = StringUtil.split((String)qName, (String)".");
        int[] result = new int[components.size()];
        for (int i = 0; i < components.size(); ++i) {
            result[i] = NameEnvironment.hashIdentifier((String)components.get(i));
        }
        return result;
    }

    static int memberQualifiedName(int ownerName, int name2) {
        return name2 == 0 || ownerName == 0 ? 0 : NameEnvironment.qualifiedName(ownerName, name2);
    }

    static int qualifiedName(int prefix, int shortName) {
        int hash = prefix * 31 + shortName;
        return hash == 0 ? 1 : hash;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/stubsHierarchy/impl/NameEnvironment", "hashQualifiedName"));
    }
}

