/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.ParametersFolder;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputVariables {
    private final List<VariableData> myInputVariables;
    private List<? extends PsiVariable> myInitialParameters;
    private final Project myProject;
    private final LocalSearchScope myScope;
    private ParametersFolder myFolding;
    private boolean myFoldingAvailable;
    private Set<? extends PsiField> myUsedInstanceFields;
    private boolean myPassFields;

    public InputVariables(List<? extends PsiVariable> inputVariables, Project project, LocalSearchScope scope, boolean foldingAvailable) {
        this.myInitialParameters = inputVariables;
        this.myProject = project;
        this.myScope = scope;
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding = new ParametersFolder();
        this.myInputVariables = this.wrapInputVariables(inputVariables);
    }

    private InputVariables(List<? extends VariableData> inputVariables, Project project, LocalSearchScope scope) {
        this.myProject = project;
        this.myScope = scope;
        this.myInputVariables = new ArrayList<VariableData>(inputVariables);
    }

    public boolean isFoldable() {
        return this.myFolding.isFoldable();
    }

    public void setUsedInstanceFields(Set<? extends PsiField> usedInstanceFields) {
        this.myUsedInstanceFields = usedInstanceFields;
    }

    public void setPassFields(boolean passFields) {
        if (this.myUsedInstanceFields == null || this.myUsedInstanceFields.isEmpty()) {
            return;
        }
        this.myPassFields = passFields;
        this.myInputVariables.clear();
        this.myInputVariables.addAll(this.wrapInputVariables(this.myInitialParameters));
    }

    public boolean isPassFields() {
        return this.myPassFields;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<VariableData> wrapInputVariables(List<? extends PsiVariable> inputVariables) {
        VariableData data;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        ArrayList<VariableData> inputData = new ArrayList<VariableData>(inputVariables.size());
        for (PsiVariable psiVariable : inputVariables) {
            String defaultName = this.getParameterName(psiVariable);
            String name2 = nameGenerator.generateUniqueName(defaultName);
            PsiType type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)psiVariable.getType());
            HashMap<PsiCodeBlock, PsiType> casts = new HashMap<PsiCodeBlock, PsiType>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiVariable, (SearchScope)this.myScope)) {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class);
                if (parent instanceof PsiTypeCastExpression) {
                    PsiType currentType = (PsiType)casts.get(block);
                    PsiType castType = ((PsiTypeCastExpression)parent).getType();
                    casts.put(block, casts.containsKey(block) && currentType == null ? null : InputVariables.getBroaderType(currentType, castType));
                    continue;
                }
                casts.put(block, null);
            }
            if (!casts.containsValue(null)) {
                PsiType psiType;
                PsiType currentType = null;
                Iterator iterator = casts.values().iterator();
                while (iterator.hasNext() && (currentType = InputVariables.getBroaderType(currentType, psiType = (PsiType)iterator.next())) != null) {
                }
                if (currentType != null && (currentType = this.checkTopLevelInstanceOf(currentType)) != null) {
                    type2 = currentType;
                }
            }
            VariableData data2 = new VariableData(psiVariable, type2);
            data2.name = name2;
            data2.passAsParameter = true;
            inputData.add(data2);
            if (!this.myFoldingAvailable) continue;
            this.myFolding.isParameterFoldable(data2, this.myScope, inputVariables, nameGenerator, defaultName);
        }
        if (this.myFoldingAvailable) {
            void var5_7;
            HashSet<VariableData> toDelete = new HashSet<VariableData>();
            int n = inputData.size() - 1;
            while (var5_7 >= 0) {
                data = inputData.get((int)var5_7);
                if (this.myFolding.isParameterSafeToDelete(data, this.myScope)) {
                    toDelete.add(data);
                }
                --var5_7;
            }
            inputData.removeAll(toDelete);
        }
        if (this.myPassFields && this.myUsedInstanceFields != null) {
            for (PsiField psiField : this.myUsedInstanceFields) {
                data = new VariableData((PsiVariable)psiField, psiField.getType());
                data.name = nameGenerator.generateUniqueName(this.getParameterName((PsiVariable)psiField));
                data.passAsParameter = true;
                inputData.add(data);
            }
        }
        return inputData;
    }

    private String getParameterName(PsiVariable var) {
        String name2 = var.getName();
        if (!(var instanceof PsiParameter)) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
            VariableKind kind2 = codeStyleManager.getVariableKind(var);
            name2 = codeStyleManager.variableNameToPropertyName(name2, kind2);
            name2 = codeStyleManager.propertyNameToVariableName(name2, VariableKind.PARAMETER);
        }
        return name2;
    }

    @Nullable
    private PsiType checkTopLevelInstanceOf(final PsiType currentType) {
        PsiExpression condition2;
        PsiElement[] scope = this.myScope.getScope();
        if (scope.length == 1 && scope[0] instanceof PsiIfStatement && (condition2 = ((PsiIfStatement)scope[0]).getCondition()) != null) {
            class CheckInstanceOf {
                CheckInstanceOf() {
                }

                boolean check(PsiInstanceOfExpression expr) {
                    PsiTypeElement checkType = expr.getCheckType();
                    return checkType == null || !checkType.getType().equals(currentType);
                }
            }
            CheckInstanceOf checker = new CheckInstanceOf();
            PsiInstanceOfExpression[] expressions2 = (PsiInstanceOfExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)condition2, PsiInstanceOfExpression.class);
            if (expressions2 != null) {
                for (PsiInstanceOfExpression instanceOfExpression : expressions2) {
                    if (checker.check(instanceOfExpression)) continue;
                    return null;
                }
            } else if (condition2 instanceof PsiInstanceOfExpression && !checker.check((PsiInstanceOfExpression)condition2)) {
                return null;
            }
        }
        return currentType;
    }

    @Nullable
    private static PsiType getBroaderType(PsiType currentType, PsiType castType) {
        if (currentType != null) {
            if (castType != null) {
                if (TypeConversionUtil.isAssignable((PsiType)castType, (PsiType)currentType)) {
                    return castType;
                }
                if (!TypeConversionUtil.isAssignable((PsiType)currentType, (PsiType)castType)) {
                    for (PsiType superType : castType.getSuperTypes()) {
                        if (!TypeConversionUtil.isAssignable((PsiType)superType, (PsiType)currentType)) continue;
                        return superType;
                    }
                    return null;
                }
            }
        } else {
            return castType;
        }
        return currentType;
    }

    public List<VariableData> getInputVariables() {
        return this.myInputVariables;
    }

    public PsiExpression replaceWrappedReferences(PsiElement[] elements, PsiExpression expression2) {
        if (!this.myFoldingAvailable) {
            return expression2;
        }
        boolean update2 = elements[0] == expression2;
        this.myFolding.foldParameterUsagesInBody(this.myInputVariables, elements, (SearchScope)this.myScope);
        return update2 ? (PsiExpression)elements[0] : expression2;
    }

    public boolean toDeclareInsideBody(PsiVariable variable) {
        ArrayList<VariableData> knownVars = new ArrayList<VariableData>(this.myInputVariables);
        for (VariableData data : knownVars) {
            if (!data.variable.equals(variable)) continue;
            return false;
        }
        return !this.myFolding.wasExcluded(variable);
    }

    public boolean contains(PsiVariable variable) {
        for (VariableData data : this.myInputVariables) {
            if (!data.variable.equals(variable)) continue;
            return true;
        }
        return false;
    }

    public void removeParametersUsedInExitsOnly(PsiElement codeFragment, Collection<? extends PsiStatement> exitStatements, ControlFlow controlFlow, int startOffset, int endOffset) {
        LocalSearchScope scope = new LocalSearchScope(codeFragment);
        Iterator<VariableData> iterator = this.myInputVariables.iterator();
        block0: while (iterator.hasNext()) {
            VariableData data = iterator.next();
            for (PsiReference ref : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
                PsiElement element = ref.getElement();
                int elementOffset = controlFlow.getStartOffset(element);
                if (elementOffset < startOffset || elementOffset > endOffset || InputVariables.isInExitStatements(element, exitStatements)) continue;
                continue block0;
            }
            iterator.remove();
        }
    }

    private static boolean isInExitStatements(PsiElement element, Collection<? extends PsiStatement> exitStatements) {
        for (PsiStatement psiStatement : exitStatements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiStatement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public InputVariables copy() {
        InputVariables inputVariables = new InputVariables(this.myInputVariables, this.myProject, this.myScope);
        inputVariables.myFoldingAvailable = this.myFoldingAvailable;
        inputVariables.myFolding = this.myFolding;
        inputVariables.myInitialParameters = this.myInitialParameters;
        return inputVariables;
    }

    @NotNull
    public InputVariables copyWithoutFolding() {
        InputVariables inputVariables = new InputVariables(this.myInitialParameters, this.myProject, this.myScope, false);
        if (inputVariables == null) {
            InputVariables.$$$reportNull$$$0(0);
        }
        return inputVariables;
    }

    public void appendCallArguments(VariableData data, StringBuilder buffer) {
        if (this.myFoldingAvailable) {
            buffer.append(this.myFolding.getGeneratedCallArgument(data));
        } else {
            if (!TypeConversionUtil.isAssignable((PsiType)data.type, (PsiType)data.variable.getType())) {
                buffer.append("(").append(data.type.getCanonicalText()).append(")");
            }
            buffer.append(data.variable.getName());
        }
    }

    public ParametersFolder getFolding() {
        return this.myFolding;
    }

    public void setFoldingAvailable(boolean foldingAvailable) {
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding.clear();
        this.myInputVariables.clear();
        this.myInputVariables.addAll(this.wrapInputVariables(this.myInitialParameters));
    }

    public void annotateWithParameter(PsiJavaCodeReferenceElement reference) {
        if (this.myInputVariables.isEmpty()) {
            return;
        }
        PsiElement element = reference.resolve();
        for (VariableData data : this.myInputVariables) {
            PsiMethod psiMethod;
            int idx;
            if (!data.variable.equals(element)) continue;
            PsiType type2 = data.variable.getType();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiMethodCallExpression.class);
            if (methodCallExpression != null && (idx = ArrayUtil.find((Object[])methodCallExpression.getArgumentList().getExpressions(), (Object)reference)) > -1 && (psiMethod = methodCallExpression.resolveMethod()) != null) {
                PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
                if (idx >= parameters2.length && (idx = parameters2.length - 1) >= 0) {
                    type2 = parameters2[idx].getType();
                }
                if (type2 instanceof PsiEllipsisType) {
                    type2 = ((PsiEllipsisType)type2).getComponentType();
                }
            }
            if (this.myFoldingAvailable && this.myFolding.annotateWithParameter(data, (PsiElement)reference)) continue;
            reference.putUserData(DuplicatesFinder.PARAMETER, (Object)new DuplicatesFinder.Parameter(data.variable, type2));
        }
    }

    public void foldExtractedParameter(@NotNull PsiVariable extractedParameter, @NotNull PsiExpression value2) {
        if (extractedParameter == null) {
            InputVariables.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            InputVariables.$$$reportNull$$$0(2);
        }
        this.myFoldingAvailable = true;
        this.myFolding.putCallArgument(extractedParameter, value2);
    }

    public boolean isFoldingSelectedByDefault() {
        return this.myFolding.isFoldingSelectedByDefault();
    }

    public boolean hasInstanceFields() {
        return this.myUsedInstanceFields != null && !this.myUsedInstanceFields.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/InputVariables";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedParameter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithoutFolding";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/InputVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "foldExtractedParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

