/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ExtractMethodSnapshot;
import com.intellij.refactoring.extractMethod.JavaDuplicatesExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.DuplicateNode;
import com.intellij.refactoring.extractMethod.preview.ElementsRange;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.MethodNode;
import com.intellij.refactoring.extractMethod.preview.PreviewDiffRequest;
import com.intellij.refactoring.extractMethod.preview.PreviewTree;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeListener;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreviewDiffPanel
extends BorderLayoutPanel
implements Disposable,
PreviewTreeListener {
    private final Project myProject;
    private final PreviewTree myTree;
    private final List<SmartPsiElementPointer<PsiElement>> myPattern;
    private final ExtractMethodSnapshot mySnapshot;
    private final SmartPsiElementPointer<PsiElement> myAnchor;
    private final DiffRequestPanel myDiffPanel;
    private PreviewDiffRequest myDiffRequest;
    private Document myPatternDocument;
    private long myInitialDocumentStamp;

    PreviewDiffPanel(@NotNull ExtractMethodProcessor processor, PreviewTree tree) {
        if (processor == null) {
            PreviewDiffPanel.$$$reportNull$$$0(0);
        }
        this.myProject = processor.getProject();
        this.myTree = tree;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        this.myPattern = ContainerUtil.map2List((Object[])processor.getElements(), arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0));
        this.mySnapshot = new ExtractMethodSnapshot(processor);
        this.myAnchor = smartPointerManager.createSmartPsiElementPointer(processor.getAnchor());
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(this.myProject, (Disposable)this, null);
        this.myDiffPanel.putContextHints(DiffUserDataKeys.PLACE, (Object)"ExtractMethod");
        this.myDiffPanel.putContextHints(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        this.myDiffPanel.putContextHints(DiffUserDataKeysEx.FORCE_DIFF_TOOL, (Object)UnifiedDiffTool.INSTANCE);
        this.addToCenter(this.myDiffPanel.getComponent());
        Disposer.register((Disposable)this, (Disposable)this.myDiffPanel);
    }

    public void dispose() {
    }

    public void doExtract() {
        List<DuplicateNode> enabledNodes = this.myTree.getModel().getEnabledDuplicates();
        PsiElement[] pattern = this.getPatternElements();
        if (pattern.length == 0) {
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, null, (String)RefactoringBundle.message((String)"refactoring.extract.method.preview.failed"), (String)ExtractMethodHandler.REFACTORING_NAME, (String)"refactoring.extractMethod");
            return;
        }
        JavaDuplicatesExtractMethodProcessor processor = new JavaDuplicatesExtractMethodProcessor(pattern, ExtractMethodHandler.REFACTORING_NAME);
        if (!processor.prepareFromSnapshot(this.mySnapshot, true)) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)ExtractMethodHandler.REFACTORING_NAME, null, () -> PreviewDiffPanel.doExtractImpl(processor, enabledNodes), (PsiFile[])new PsiFile[]{pattern[0].getContainingFile()});
    }

    public void initLater() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, RefactoringBundle.message((String)"refactoring.extract.method.preview.preparing")){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                PreviewDiffPanel.this.updateLaterImpl(indicator, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel$1", "run"));
            }
        });
    }

    public void updateLater() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, RefactoringBundle.message((String)"refactoring.extract.method.preview.updating")){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                PreviewDiffPanel.this.updateLaterImpl(indicator, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel$2", "run"));
            }
        });
    }

    private void updateLaterImpl(@NotNull ProgressIndicator indicator, boolean onlyEnabled) {
        if (indicator == null) {
            PreviewDiffPanel.$$$reportNull$$$0(1);
        }
        List<DuplicateNode> allNodes = this.myTree.getModel().getAllDuplicates();
        List<DuplicateNode> selectedNodes = onlyEnabled ? this.myTree.getModel().getEnabledDuplicates() : allNodes;
        IncrementalProgress progress = new IncrementalProgress(indicator, selectedNodes.size() + 4);
        PsiElement[] pattern = (PsiElement[])ReadAction.compute(() -> this.getPatternElements());
        PsiElement[] patternCopy = (PsiElement[])ReadAction.compute(() -> {
            PsiFile patternFile = pattern[0].getContainingFile();
            return IntroduceParameterHandler.getElementsInCopy(this.myProject, patternFile, pattern, false);
        });
        progress.increment();
        ExtractMethodSnapshot copySnapshot = (ExtractMethodSnapshot)ReadAction.compute(() -> new ExtractMethodSnapshot(this.mySnapshot, pattern, patternCopy));
        ExtractMethodProcessor copyProcessor = (ExtractMethodProcessor)ReadAction.compute(() -> {
            JavaDuplicatesExtractMethodProcessor processor = new JavaDuplicatesExtractMethodProcessor(patternCopy, ExtractMethodHandler.REFACTORING_NAME);
            return processor.prepareFromSnapshot(copySnapshot, true) ? processor : null;
        });
        if (copyProcessor == null) {
            return;
        }
        Map duplicateMatches = (Map)ReadAction.compute(() -> PreviewDiffPanel.findSelectedDuplicates(copyProcessor, selectedNodes));
        List excludedDuplicates = onlyEnabled && allNodes.size() != duplicateMatches.size() ? (List)ReadAction.compute(() -> PreviewDiffPanel.collectExcludedRanges(allNodes, duplicateMatches.keySet(), patternCopy[0].getContainingFile())) : Collections.emptyList();
        Bounds patternReplacementBounds = (Bounds)ReadAction.compute(() -> {
            Bounds patternBounds = new Bounds(patternCopy[0], patternCopy[patternCopy.length - 1]);
            copyProcessor.doExtract();
            return patternBounds;
        });
        progress.increment();
        ReadAction.run(() -> copyProcessor.initParametrizedDuplicates(false));
        progress.increment();
        ArrayList duplicateReplacements = new ArrayList();
        for (Map.Entry entry : duplicateMatches.entrySet()) {
            DuplicateNode duplicateNode = (DuplicateNode)entry.getKey();
            Match duplicate = (Match)entry.getValue();
            ReadAction.run(() -> {
                Bounds bounds = new Bounds(duplicate.getMatchStart(), duplicate.getMatchEnd());
                copyProcessor.processMatch(duplicate);
                ElementsRange replacement = bounds.getElementsRange();
                duplicateReplacements.add(new Duplicate(duplicateNode, replacement));
            });
            progress.increment();
        }
        PsiMethod method = (PsiMethod)ReadAction.compute(() -> {
            PsiMethod extractedMethod = copyProcessor.getExtractedMethod();
            return (PsiMethod)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)extractedMethod);
        });
        ElementsRange patternReplacement = (ElementsRange)ReadAction.compute(() -> patternReplacementBounds.getElementsRange());
        Document refactoredDocument = (Document)ReadAction.compute(() -> {
            PsiFile refactoredFile = method.getContainingFile();
            if (refactoredFile != null) {
                VirtualFile vFile = refactoredFile.getViewProvider().getVirtualFile();
                vFile.putUserData(DiffUtil.TEMP_FILE_KEY, (Object)Boolean.TRUE);
                return FileDocumentManager.getInstance().getDocument(vFile);
            }
            return null;
        });
        progress.increment();
        if (refactoredDocument != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                documentManager.doPostponedOperationsAndUnblockDocument(refactoredDocument);
                MethodNode methodNode = this.myTree.getModel().updateMethod(method);
                this.initDiff(pattern, patternReplacement, refactoredDocument, methodNode, method.getTextRange(), duplicateReplacements, excludedDuplicates);
                this.myTree.onUpdateLater();
            });
        }
    }

    private void initDiff(@NotNull PsiElement[] pattern, @NotNull ElementsRange patternReplacement, @NotNull Document refactoredDocument, @NotNull MethodNode methodNode, @NotNull TextRange methodRange, @NotNull List<Duplicate> duplicateReplacements, @NotNull List<Duplicate> excludedDuplicates) {
        TextRange replacementRange;
        TextRange patternRange;
        Range diffRange;
        if (pattern == null) {
            PreviewDiffPanel.$$$reportNull$$$0(2);
        }
        if (patternReplacement == null) {
            PreviewDiffPanel.$$$reportNull$$$0(3);
        }
        if (refactoredDocument == null) {
            PreviewDiffPanel.$$$reportNull$$$0(4);
        }
        if (methodNode == null) {
            PreviewDiffPanel.$$$reportNull$$$0(5);
        }
        if (methodRange == null) {
            PreviewDiffPanel.$$$reportNull$$$0(6);
        }
        if (duplicateReplacements == null) {
            PreviewDiffPanel.$$$reportNull$$$0(7);
        }
        if (excludedDuplicates == null) {
            PreviewDiffPanel.$$$reportNull$$$0(8);
        }
        PsiFile patternFile = pattern[0].getContainingFile();
        this.myPatternDocument = FileDocumentManager.getInstance().getDocument(patternFile.getViewProvider().getVirtualFile());
        if (this.myPatternDocument == null) {
            return;
        }
        this.myInitialDocumentStamp = this.myPatternDocument.getModificationStamp();
        ArrayList<Range> diffRanges = new ArrayList<Range>();
        HashMap<FragmentNode, Couple<TextRange>> linesBounds = new HashMap<FragmentNode, Couple<TextRange>>();
        this.collectDiffRanges(refactoredDocument, diffRanges, linesBounds, duplicateReplacements);
        this.collectDiffRanges(refactoredDocument, diffRanges, linesBounds, excludedDuplicates);
        PsiElement anchorElement = this.myAnchor.getElement();
        if (anchorElement != null) {
            int anchorOffset = anchorElement.getTextRange().getEndOffset();
            int anchorLineNumber = this.myPatternDocument.getLineNumber(anchorOffset);
            diffRange = new Range(anchorLineNumber, anchorLineNumber, PreviewDiffPanel.getStartLineNumber(refactoredDocument, methodRange), PreviewDiffPanel.getLineNumberAfter(refactoredDocument, methodRange));
            diffRanges.add(diffRange);
            linesBounds.put(methodNode, (Couple<TextRange>)Couple.of((Object)new TextRange(anchorOffset, anchorOffset), (Object)PreviewDiffPanel.getLinesRange(methodRange, refactoredDocument)));
        }
        if ((diffRange = PreviewDiffPanel.getDiffRange(patternRange = new ElementsRange(pattern).getTextRange(), this.myPatternDocument, replacementRange = patternReplacement.getTextRange(), refactoredDocument)) != null) {
            diffRanges.add(diffRange);
            linesBounds.put(this.myTree.getModel().getPatternNode(), (Couple<TextRange>)Couple.of((Object)PreviewDiffPanel.getLinesRange(patternRange, this.myPatternDocument), (Object)PreviewDiffPanel.getLinesRange(replacementRange, refactoredDocument)));
        }
        diffRanges.sort(Comparator.comparing(r -> r.start1));
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DocumentContent oldContent = contentFactory.create(this.myProject, this.myPatternDocument);
        DocumentContent newContent = contentFactory.create(this.myProject, refactoredDocument);
        this.myDiffRequest = new PreviewDiffRequest(linesBounds, (DiffContent)oldContent, (DiffContent)newContent, node -> this.myTree.selectNode((FragmentNode)node));
        this.myDiffRequest.putUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER, PreviewDiffPanel.getDiffComputer(diffRanges));
        this.myDiffPanel.setRequest((DiffRequest)this.myDiffRequest);
        this.myDiffRequest.onInitialized();
    }

    private void collectDiffRanges(@NotNull Document refactoredDocument, @NotNull List<Range> diffRanges, @NotNull Map<FragmentNode, Couple<TextRange>> linesBounds, @NotNull List<Duplicate> duplicates) {
        if (refactoredDocument == null) {
            PreviewDiffPanel.$$$reportNull$$$0(9);
        }
        if (diffRanges == null) {
            PreviewDiffPanel.$$$reportNull$$$0(10);
        }
        if (linesBounds == null) {
            PreviewDiffPanel.$$$reportNull$$$0(11);
        }
        if (duplicates == null) {
            PreviewDiffPanel.$$$reportNull$$$0(12);
        }
        for (Duplicate duplicate : duplicates) {
            TextRange copyRange;
            DuplicateNode duplicateNode = duplicate.myNode;
            TextRange patternRange = duplicateNode.getTextRange();
            Range diffRange = PreviewDiffPanel.getDiffRange(patternRange, this.myPatternDocument, copyRange = duplicate.myCopy.getTextRange(), refactoredDocument);
            if (diffRange == null) continue;
            diffRanges.add(diffRange);
            linesBounds.put(duplicateNode, (Couple<TextRange>)Couple.of((Object)PreviewDiffPanel.getLinesRange(patternRange, this.myPatternDocument), (Object)PreviewDiffPanel.getLinesRange(copyRange, refactoredDocument)));
        }
    }

    private static int getStartLineNumber(Document document, TextRange textRange) {
        return document.getLineNumber(textRange.getStartOffset());
    }

    private static int getLineNumberAfter(Document document, TextRange textRange) {
        return Math.min(document.getLineNumber(textRange.getEndOffset()) + 1, document.getLineCount());
    }

    private static Range getDiffRange(@Nullable TextRange patternRange, @NotNull Document patternDocument, @Nullable TextRange refactoredRange, @NotNull Document refactoredDocument) {
        if (patternDocument == null) {
            PreviewDiffPanel.$$$reportNull$$$0(13);
        }
        if (refactoredDocument == null) {
            PreviewDiffPanel.$$$reportNull$$$0(14);
        }
        if (patternRange == null || refactoredRange == null) {
            return null;
        }
        return new Range(PreviewDiffPanel.getStartLineNumber(patternDocument, patternRange), PreviewDiffPanel.getLineNumberAfter(patternDocument, patternRange), PreviewDiffPanel.getStartLineNumber(refactoredDocument, refactoredRange), PreviewDiffPanel.getLineNumberAfter(refactoredDocument, refactoredRange));
    }

    @NotNull
    private static TextRange getLinesRange(@NotNull TextRange textRange, @NotNull Document document) {
        if (textRange == null) {
            PreviewDiffPanel.$$$reportNull$$$0(15);
        }
        if (document == null) {
            PreviewDiffPanel.$$$reportNull$$$0(16);
        }
        int startLine = document.getLineNumber(textRange.getStartOffset());
        int endLine = document.getLineNumber(Math.min(textRange.getEndOffset(), document.getTextLength()));
        TextRange textRange2 = new TextRange(document.getLineStartOffset(startLine), document.getLineEndOffset(endLine));
        if (textRange2 == null) {
            PreviewDiffPanel.$$$reportNull$$$0(17);
        }
        return textRange2;
    }

    private static List<Duplicate> collectExcludedRanges(@NotNull List<DuplicateNode> allNodes, @NotNull Set<DuplicateNode> selectedNodes, @NotNull PsiFile copyFile) {
        if (allNodes == null) {
            PreviewDiffPanel.$$$reportNull$$$0(18);
        }
        if (selectedNodes == null) {
            PreviewDiffPanel.$$$reportNull$$$0(19);
        }
        if (copyFile == null) {
            PreviewDiffPanel.$$$reportNull$$$0(20);
        }
        ArrayList<Duplicate> excludedRanges = new ArrayList<Duplicate>();
        for (DuplicateNode node : allNodes) {
            ElementsRange copyRange;
            ElementsRange elementsRange;
            if (selectedNodes.contains(node) || (elementsRange = node.getElementsRange()) == null || (copyRange = elementsRange.findCopyInFile(copyFile)) == null) continue;
            excludedRanges.add(new Duplicate(node, copyRange));
        }
        return excludedRanges;
    }

    private static void doExtractImpl(@NotNull JavaDuplicatesExtractMethodProcessor processor, @NotNull List<? extends DuplicateNode> selectedNodes) {
        Editor editor;
        if (processor == null) {
            PreviewDiffPanel.$$$reportNull$$$0(21);
        }
        if (selectedNodes == null) {
            PreviewDiffPanel.$$$reportNull$$$0(22);
        }
        Map<DuplicateNode, Match> selectedDuplicates = PreviewDiffPanel.findSelectedDuplicates(processor, selectedNodes);
        processor.doExtract();
        processor.initParametrizedDuplicates(false);
        for (Match duplicate : selectedDuplicates.values()) {
            processor.processMatch(duplicate);
        }
        PsiMethodCallExpression methodCall = processor.getMethodCall();
        if (methodCall != null && methodCall.isValid() && (editor = PreviewDiffPanel.getEditor(methodCall.getContainingFile(), false)) != null) {
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(methodCall.getTextOffset());
        }
    }

    @Override
    public void onNodeSelected(@NotNull FragmentNode node) {
        if (node == null) {
            PreviewDiffPanel.$$$reportNull$$$0(23);
        }
        if (this.myDiffRequest != null) {
            this.myDiffRequest.onNodeSelected(node);
        }
    }

    @NotNull
    private static Map<DuplicateNode, Match> findSelectedDuplicates(@NotNull ExtractMethodProcessor processor, @NotNull List<? extends DuplicateNode> selectedNodes) {
        if (processor == null) {
            PreviewDiffPanel.$$$reportNull$$$0(24);
        }
        if (selectedNodes == null) {
            PreviewDiffPanel.$$$reportNull$$$0(25);
        }
        Set textRanges = ContainerUtil.map2SetNotNull(selectedNodes, FragmentNode::getTextRange);
        processor.previewRefactoring(textRanges);
        List<Match> duplicates = processor.getAnyDuplicates();
        Map<DuplicateNode, Match> map = PreviewDiffPanel.filterSelectedDuplicates(selectedNodes, duplicates);
        if (map == null) {
            PreviewDiffPanel.$$$reportNull$$$0(26);
        }
        return map;
    }

    @NotNull
    private static Map<DuplicateNode, Match> filterSelectedDuplicates(@NotNull Collection<? extends DuplicateNode> selectedNodes, @Nullable List<Match> allDuplicates) {
        if (selectedNodes == null) {
            PreviewDiffPanel.$$$reportNull$$$0(27);
        }
        if (ContainerUtil.isEmpty(allDuplicates)) {
            Map<DuplicateNode, Match> map = Collections.emptyMap();
            if (map == null) {
                PreviewDiffPanel.$$$reportNull$$$0(28);
            }
            return map;
        }
        THashMap selectedDuplicates = new THashMap();
        block0: for (DuplicateNode duplicateNode : selectedNodes) {
            TextRange selectedRange = duplicateNode.getTextRange();
            if (selectedRange == null) continue;
            for (Match duplicate : allDuplicates) {
                PsiElement start = duplicate.getMatchStart();
                PsiElement end = duplicate.getMatchEnd();
                if (start == null || end == null || !selectedRange.equalsToRange(start.getTextRange().getStartOffset(), end.getTextRange().getEndOffset())) continue;
                selectedDuplicates.put(duplicateNode, duplicate);
                continue block0;
            }
        }
        THashMap tHashMap = selectedDuplicates;
        if (tHashMap == null) {
            PreviewDiffPanel.$$$reportNull$$$0(29);
        }
        return tHashMap;
    }

    @NotNull
    private static DiffUserDataKeysEx.DiffComputer getDiffComputer(@NotNull Collection<? extends Range> ranges) {
        if (ranges == null) {
            PreviewDiffPanel.$$$reportNull$$$0(30);
        }
        DiffUserDataKeysEx.DiffComputer diffComputer = (text1, text2, policy, innerChanges, indicator) -> {
            if (ranges == null) {
                PreviewDiffPanel.$$$reportNull$$$0(35);
            }
            LineOffsets offsets1 = LineOffsetsUtil.create((CharSequence)text1);
            LineOffsets offsets2 = LineOffsetsUtil.create((CharSequence)text2);
            ArrayList result = new ArrayList();
            ComparisonManagerImpl comparisonManager = ComparisonManagerImpl.getInstanceImpl();
            for (Range range : ranges) {
                result.addAll(comparisonManager.compareLinesInner(range, text1, text2, offsets1, offsets2, policy, innerChanges, indicator));
            }
            return result;
        };
        if (diffComputer == null) {
            PreviewDiffPanel.$$$reportNull$$$0(31);
        }
        return diffComputer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryExtractAgain() {
        PsiFile psiFile;
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiElement[] elements = this.getPatternElements();
        if (elements.length != 0 && (psiFile = elements[0].getContainingFile()) != null) {
            ExtractMethodSnapshot.SNAPSHOT_KEY.set((UserDataHolder)psiFile, (Object)this.mySnapshot);
            try {
                Editor editor = PreviewDiffPanel.getEditor(psiFile, true);
                ExtractMethodHandler.invokeOnElements(this.myProject, editor, psiFile, elements);
                return;
            }
            finally {
                ExtractMethodSnapshot.SNAPSHOT_KEY.set((UserDataHolder)psiFile, null);
            }
        }
        Messages.showErrorDialog((Project)this.myProject, (String)"Can't restore context for method extraction", (String)"Failed to Re-Run Refactoring");
    }

    @NotNull
    private PsiElement[] getPatternElements() {
        Object[] elements = (PsiElement[])ContainerUtil.map2Array(this.myPattern, (Object[])PsiElement.EMPTY_ARRAY, SmartPsiElementPointer::getElement);
        if (ArrayUtil.contains(null, (Object[])elements)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PreviewDiffPanel.$$$reportNull$$$0(32);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (elements == null) {
            PreviewDiffPanel.$$$reportNull$$$0(33);
        }
        return elements;
    }

    @Nullable
    private static Editor getEditor(@NotNull PsiFile psiFile, boolean canCreate) {
        Project project;
        if (psiFile == null) {
            PreviewDiffPanel.$$$reportNull$$$0(34);
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        if (document == null) {
            return null;
        }
        EditorFactory factory = EditorFactory.getInstance();
        Editor[] editors = factory.getEditors(document, project = psiFile.getProject());
        if (editors.length != 0) {
            return editors[0];
        }
        return canCreate ? EditorFactory.getInstance().createEditor(document, project) : null;
    }

    boolean isModified() {
        return this.myPatternDocument == null || this.myPatternDocument.getModificationStamp() != this.myInitialDocumentStamp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternReplacement";
                break;
            }
            case 4: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoredDocument";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRange";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicateReplacements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDuplicates";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffRanges";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesBounds";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternDocument";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allNodes";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinesRange";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findSelectedDuplicates";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSelectedDuplicates";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffComputer";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateLaterImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "initDiff";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectDiffRanges";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRange";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLinesRange";
                break;
            }
            case 17: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectExcludedRanges";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doExtractImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onNodeSelected";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findSelectedDuplicates";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterSelectedDuplicates";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDiffComputer";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDiffComputer$16";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class IncrementalProgress {
        private final ProgressIndicator myIndicator;
        private final double myTotal;
        private int myCount;

        IncrementalProgress(@NotNull ProgressIndicator indicator, int total) {
            if (indicator == null) {
                IncrementalProgress.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator;
            this.myTotal = total;
            indicator.setIndeterminate(false);
        }

        void increment() {
            this.myIndicator.setFraction((double)(++this.myCount) / this.myTotal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel$IncrementalProgress", "<init>"));
        }
    }

    private static class Duplicate {
        final DuplicateNode myNode;
        final ElementsRange myCopy;

        Duplicate(DuplicateNode node, ElementsRange copy) {
            this.myNode = node;
            this.myCopy = copy;
        }
    }

    private static class Bounds {
        private static final Class[] SKIP_TYPES = new Class[]{PsiWhiteSpace.class, PsiComment.class, PsiEmptyStatement.class};
        final PsiElement myParent;
        final PsiElement myBefore;
        final PsiElement myAfter;

        Bounds(@NotNull PsiElement start, @NotNull PsiElement end) {
            if (start == null) {
                Bounds.$$$reportNull$$$0(0);
            }
            if (end == null) {
                Bounds.$$$reportNull$$$0(1);
            }
            this.myParent = start.getParent();
            assert (this.myParent != null) : "bounds' parent is null";
            this.myBefore = PsiTreeUtil.skipSiblingsBackward((PsiElement)start, (Class[])SKIP_TYPES);
            this.myAfter = PsiTreeUtil.skipSiblingsForward((PsiElement)end, (Class[])SKIP_TYPES);
        }

        ElementsRange getElementsRange() {
            PsiElement start = PsiTreeUtil.skipSiblingsForward((PsiElement)this.myBefore, (Class[])SKIP_TYPES);
            PsiElement end = PsiTreeUtil.skipSiblingsBackward((PsiElement)this.myAfter, (Class[])SKIP_TYPES);
            if (start == null) {
                start = this.myParent.getFirstChild();
            }
            if (end == null) {
                end = this.myParent.getLastChild();
            }
            if (start != null && end != null) {
                return new ElementsRange(start, end);
            }
            return new ElementsRange(this.myParent, this.myParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "start";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "end";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel$Bounds";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

