/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineToAnonymousClassHandler;
import com.intellij.refactoring.inline.InlineToAnonymousConstructorProcessor;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineToAnonymousClassProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineToAnonymousClassProcessor");
    private PsiClass myClass;
    private final PsiCall myCallToInline;
    private final boolean myInlineThisOnly;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;

    public InlineToAnonymousClassProcessor(Project project, PsiClass psiClass, @Nullable PsiCall callToInline, boolean inlineThisOnly, boolean searchInComments, boolean searchInNonJavaFiles) {
        super(project);
        this.myClass = psiClass;
        this.myCallToInline = callToInline;
        this.myInlineThisOnly = inlineThisOnly;
        if (this.myInlineThisOnly) assert (this.myCallToInline != null);
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(0);
        }
        InlineViewDescriptor inlineViewDescriptor = new InlineViewDescriptor((PsiElement)this.myClass);
        if (inlineViewDescriptor == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(1);
        }
        return inlineViewDescriptor;
    }

    @NotNull
    public UsageInfo[] findUsages() {
        if (this.myInlineThisOnly) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo((PsiElement)this.myCallToInline)};
            if (usageInfoArray == null) {
                InlineToAnonymousClassProcessor.$$$reportNull$$$0(2);
            }
            return usageInfoArray;
        }
        HashSet<Object> usages = new HashSet<Object>();
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)this.myProject);
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)searchScope)) {
            usages.add(new UsageInfo(reference.getElement()));
        }
        String qName = this.myClass.getQualifiedName();
        if (qName != null) {
            ArrayList nonCodeUsages = new ArrayList();
            if (this.mySearchInComments) {
                TextOccurrencesUtil.addUsagesInStringsAndComments((PsiElement)this.myClass, (String)qName, nonCodeUsages, (UsageInfoFactory)new NonCodeUsageInfoFactory((PsiElement)this.myClass, qName));
            }
            if (this.mySearchInNonJavaFiles) {
                TextOccurrencesUtil.addTextOccurences((PsiElement)this.myClass, (String)qName, (GlobalSearchScope)searchScope, nonCodeUsages, (UsageInfoFactory)new NonCodeUsageInfoFactory((PsiElement)this.myClass, qName));
            }
            usages.addAll(nonCodeUsages);
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor2) {
        if (descriptor2 == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(4);
        }
        if (!this.myInlineThisOnly && !this.myClass.isWritable()) {
            List list = Collections.emptyList();
            if (list == null) {
                InlineToAnonymousClassProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }
        Collection collection = super.getElementsToWrite(descriptor2);
        if (collection == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(7);
        }
        assert (elements.length == 1);
        this.myClass = (PsiClass)elements[0];
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(8);
        }
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        for (UsageInfo usage : usages) {
            if (!InlineToAnonymousClassProcessor.isForcePreview(usage)) continue;
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"occurrences.found.in.comments.strings.and.non.java.files"));
            return true;
        }
        return false;
    }

    private static boolean isForcePreview(UsageInfo usage) {
        PsiFile file;
        if (usage.isNonCodeUsage) {
            return true;
        }
        PsiElement element = usage.getElement();
        return element != null && !((file = element.getContainingFile()) instanceof PsiJavaFile);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        MultiMap<PsiElement, String> conflicts;
        if (refUsages == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(9);
        }
        if (!(conflicts = this.getConflicts((UsageInfo[])refUsages.get())).isEmpty()) {
            return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
        }
        return super.preprocessUsages(refUsages);
    }

    public MultiMap<PsiElement, String> getConflicts(UsageInfo[] usages) {
        final MultiMap result = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector(){

            @Override
            protected void checkAddMember(@NotNull PsiMember member) {
                if (member == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PsiTreeUtil.isAncestor((PsiElement)InlineToAnonymousClassProcessor.this.myClass, (PsiElement)member, (boolean)false)) {
                    return;
                }
                PsiModifierList modifierList = member.getModifierList();
                if (member.getContainingClass() == InlineToAnonymousClassProcessor.this.myClass.getSuperClass() && modifierList != null && modifierList.hasModifierProperty("protected")) {
                    return;
                }
                super.checkAddMember(member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor$1", "checkAddMember"));
            }
        };
        InlineMethodProcessor.addInaccessibleMemberConflicts((PsiElement)this.myClass, usages, collector, (MultiMap<PsiElement, String>)result);
        this.myClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitParameter(PsiParameter parameter2) {
                super.visitParameter(parameter2);
                if (!InlineToAnonymousClassProcessor.this.myClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInType((PsiType)parameter2.getType()))) {
                    return;
                }
                for (PsiReference psiReference : ReferencesSearch.search((PsiElement)parameter2)) {
                    PsiElement resolvedMember;
                    PsiReferenceExpression referenceExpression;
                    PsiElement refElement = psiReference.getElement();
                    if (!(refElement instanceof PsiExpression) || (referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)refElement, PsiReferenceExpression.class)) == null || referenceExpression.getQualifierExpression() != refElement || (resolvedMember = referenceExpression.resolve()) == null || !PsiTreeUtil.isAncestor((PsiElement)InlineToAnonymousClassProcessor.this.myClass, (PsiElement)resolvedMember, (boolean)false) || resolvedMember instanceof PsiMethod && InlineToAnonymousClassProcessor.this.myClass.findMethodsBySignature((PsiMethod)resolvedMember, true).length > 1) continue;
                    result.putValue((Object)refElement, (Object)"Class cannot be inlined because a call to its member inside body");
                }
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                super.visitNewExpression(expression2);
                if (!InlineToAnonymousClassProcessor.this.myClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInType((PsiType)expression2.getType()))) {
                    return;
                }
                result.putValue((Object)expression2, (Object)"Class cannot be inlined because a call to its constructor inside body");
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiMethod method;
                super.visitMethodCallExpression(expression2);
                PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
                if (qualifierExpression2 != null && !InlineToAnonymousClassProcessor.this.myClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInType((PsiType)qualifierExpression2.getType()))) {
                    return;
                }
                PsiElement resolved = methodExpression.resolve();
                if (resolved instanceof PsiMethod && "getClass".equals((method = (PsiMethod)resolved).getName()) && method.getParameterList().isEmpty()) {
                    result.putValue((Object)methodExpression, (Object)"Result of getClass() invocation would be changed");
                }
            }
        });
        return result;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        PsiClassType superType;
        if (usages == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(10);
        }
        LOG.assertTrue((superType = InlineToAnonymousClassProcessor.getSuperType(this.myClass)) != null);
        ArrayList<PsiImportStatement> elementsToDelete = new ArrayList<PsiImportStatement>();
        ArrayList<PsiNewExpression> newExpressions = new ArrayList<PsiNewExpression>();
        for (UsageInfo info : usages) {
            PsiElement element = info.getElement();
            if (element instanceof PsiNewExpression) {
                newExpressions.add((PsiNewExpression)element);
                continue;
            }
            if (element != null && element.getParent() instanceof PsiNewExpression) {
                newExpressions.add((PsiNewExpression)element.getParent());
                continue;
            }
            PsiImportStatement statement = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class);
            if (statement != null && !this.myInlineThisOnly) {
                elementsToDelete.add(statement);
                continue;
            }
            PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
            if (typeElement == null) continue;
            this.replaceWithSuperType(typeElement, superType);
        }
        Collections.sort(newExpressions, PsiUtil.BY_POSITION);
        for (PsiNewExpression psiNewExpression : newExpressions) {
            this.replaceNewOrType(psiNewExpression, superType);
        }
        for (PsiElement psiElement : elementsToDelete) {
            try {
                if (!psiElement.isValid()) continue;
                psiElement.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!this.myInlineThisOnly && this.myClass.getOriginalElement().isWritable()) {
            try {
                this.myClass.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void replaceNewOrType(PsiNewExpression psiNewExpression, PsiClassType superType) {
        try {
            if (!ExpressionUtils.isArrayCreationExpression(psiNewExpression)) {
                new InlineToAnonymousConstructorProcessor(this.myClass, psiNewExpression, (PsiType)superType).run();
            } else {
                PsiClass target = superType.resolve();
                assert (target != null) : superType;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
                PsiJavaCodeReferenceElement element = factory.createClassReferenceElement(target);
                PsiJavaCodeReferenceElement reference = psiNewExpression.getClassReference();
                assert (reference != null) : psiNewExpression;
                reference.replace((PsiElement)element);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void replaceWithSuperType(PsiTypeElement typeElement, PsiClassType superType) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiClassType psiType = (PsiClassType)typeElement.getType();
        PsiClassType.ClassResolveResult classResolveResult = psiType.resolveGenerics();
        PsiType substType = classResolveResult.getSubstitutor().substitute((PsiType)superType);
        assert (this.myClass.isEquivalentTo((PsiElement)classResolveResult.getElement()));
        try {
            PsiElement replaced = typeElement.replace((PsiElement)factory.createTypeElement(substType));
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(replaced);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static PsiClassType getSuperType(PsiClass aClass) {
        PsiClassType[] classTypes;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null) {
            return null;
        }
        PsiClassType[] interfaceTypes = aClass.getImplementsListTypes();
        PsiClassType superType = interfaceTypes.length > 0 && !InlineToAnonymousClassHandler.isRedundantImplements(superClass, interfaceTypes[0]) ? interfaceTypes[0] : ((classTypes = aClass.getExtendsListTypes()).length > 0 ? classTypes[0] : factory.createType(superClass));
        return superType;
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"inline.to.anonymous.command.name", (Object[])new Object[]{this.myClass.getQualifiedName()});
        if (string == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

