/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.KeyboardComboSwitcher;
import com.intellij.refactoring.introduceParameter.IntroduceParameterSettingsUI;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class InplaceIntroduceParameterUI
extends IntroduceParameterSettingsUI {
    private JComboBox myReplaceFieldsCb;
    private boolean myHasWriteAccess;
    private final Project myProject;
    private final TypeSelectorManager myTypeSelectorManager;
    private final PsiExpression[] myOccurrences;
    private final PsiFile myFile;

    public InplaceIntroduceParameterUI(Project project, PsiLocalVariable onLocalVariable, PsiExpression onExpression, PsiMethod methodToReplaceIn, TIntArrayList parametersToRemove, TypeSelectorManager typeSelectorManager, PsiExpression[] occurrences) {
        super(onLocalVariable, onExpression, methodToReplaceIn, parametersToRemove);
        this.myProject = project;
        this.myTypeSelectorManager = typeSelectorManager;
        this.myOccurrences = occurrences;
        this.myFile = methodToReplaceIn.getContainingFile();
        for (PsiExpression occurrence : this.myOccurrences) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)occurrence)) continue;
            this.myHasWriteAccess = true;
            break;
        }
    }

    protected abstract PsiParameter getParameter();

    @Override
    protected JPanel createReplaceFieldsWithGettersPanel() {
        LabeledComponent component = new LabeledComponent();
        this.myReplaceFieldsCb = new JComboBox<Integer>(new Integer[]{2, 1, 0});
        this.myReplaceFieldsCb.setRenderer(new ListCellRendererWrapper<Integer>(){

            public void customize(JList list, Integer value2, int index, boolean selected, boolean hasFocus) {
                switch (value2) {
                    case 0: {
                        this.setText(UIUtil.removeMnemonic((String)RefactoringBundle.message((String)"do.not.replace")));
                        break;
                    }
                    case 1: {
                        this.setText(UIUtil.removeMnemonic((String)RefactoringBundle.message((String)"replace.fields.inaccessible.in.usage.context")));
                        break;
                    }
                    default: {
                        this.setText(UIUtil.removeMnemonic((String)RefactoringBundle.message((String)"replace.all.fields")));
                    }
                }
            }
        });
        this.myReplaceFieldsCb.setSelectedItem(JavaRefactoringSettings.getInstance().INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS);
        KeyboardComboSwitcher.setupActions((JComboBox)this.myReplaceFieldsCb, (Project)this.myProject);
        component.setComponent((JComponent)this.myReplaceFieldsCb);
        component.setText(RefactoringBundle.message((String)"replace.fields.used.in.expressions.with.their.getters"));
        component.getLabel().setDisplayedMnemonic('u');
        component.setLabelLocation("North");
        component.setBorder((Border)JBUI.Borders.empty((int)3, (int)3, (int)2, (int)2));
        return component;
    }

    @Override
    protected int getReplaceFieldsWithGetters() {
        return this.myReplaceFieldsCb != null ? (Integer)this.myReplaceFieldsCb.getSelectedItem() : 1;
    }

    @Override
    protected TypeSelectorManager getTypeSelectionManager() {
        return this.myTypeSelectorManager;
    }

    public boolean isGenerateFinal() {
        return this.hasFinalModifier();
    }

    public void appendOccurrencesDelegate(JPanel myWholePanel) {
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
        if (this.myOccurrences.length > 1 && !this.myIsInvokedOnDeclaration) {
            ++gc.gridy;
            this.createOccurrencesCb(gc, myWholePanel, this.myOccurrences.length);
            this.myCbReplaceAllOccurences.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InplaceIntroduceParameterUI.this.updateControls(new JCheckBox[0]);
                }
            });
        }
        ++gc.gridy;
        gc.insets.left = 0;
        this.createDelegateCb(gc, myWholePanel);
    }

    public boolean hasFinalModifier() {
        if (this.myHasWriteAccess) {
            return false;
        }
        Boolean createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_PARAMETER_CREATE_FINALS;
        return createFinals == null ? JavaCodeStyleSettings.getInstance((PsiFile)this.myFile).GENERATE_FINAL_PARAMETERS : createFinals;
    }
}

