/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.classMembers.InterfaceContainmentVerifier;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PullUpConflictsUtil {
    private PullUpConflictsUtil() {
    }

    public static MultiMap<PsiElement, String> checkConflicts(MemberInfoBase<? extends PsiMember>[] infos, PsiClass subclass, @Nullable PsiClass superClass, @NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, InterfaceContainmentVerifier interfaceContainmentVerifier) {
        if (targetPackage == null) {
            PullUpConflictsUtil.$$$reportNull$$$0(0);
        }
        if (targetDirectory == null) {
            PullUpConflictsUtil.$$$reportNull$$$0(1);
        }
        return PullUpConflictsUtil.checkConflicts(infos, subclass, superClass, targetPackage, targetDirectory, interfaceContainmentVerifier, true);
    }

    public static MultiMap<PsiElement, String> checkConflicts(MemberInfoBase<? extends PsiMember>[] infos, @NotNull PsiClass subclass, @Nullable PsiClass superClass, @NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, InterfaceContainmentVerifier interfaceContainmentVerifier, boolean movedMembers2Super) {
        PsiDirectory targetRepresentativeElement;
        boolean isInterfaceTarget;
        if (subclass == null) {
            PullUpConflictsUtil.$$$reportNull$$$0(2);
        }
        if (targetPackage == null) {
            PullUpConflictsUtil.$$$reportNull$$$0(3);
        }
        if (targetDirectory == null) {
            PullUpConflictsUtil.$$$reportNull$$$0(4);
        }
        final HashSet<PsiMember> movedMembers = new HashSet<PsiMember>();
        HashSet<PsiMethod> abstractMethods = new HashSet<PsiMethod>();
        if (superClass != null) {
            isInterfaceTarget = superClass.isInterface();
            targetRepresentativeElement = superClass;
        } else {
            isInterfaceTarget = false;
            targetRepresentativeElement = targetDirectory;
        }
        for (MemberInfoBase<? extends PsiMember> info : infos) {
            PsiMember member = (PsiMember)info.getMember();
            if (member instanceof PsiMethod) {
                if (!info.isToAbstract()) {
                    movedMembers.add(member);
                    continue;
                }
                abstractMethods.add((PsiMethod)member);
                continue;
            }
            movedMembers.add(member);
        }
        final MultiMap conflicts = new MultiMap();
        HashSet<PsiMethod> abstrMethods = new HashSet<PsiMethod>(abstractMethods);
        if (superClass != null) {
            for (PsiMethod method : subclass.getMethods()) {
                if (movedMembers.contains(method) || method.hasModifierProperty("private") || method.findSuperMethods(superClass).length <= 0) continue;
                abstrMethods.add(method);
            }
            List<PsiMethod> newAbstractMethods = PullUpConflictsUtil.newAbstractMethodInSuper(infos);
            if (!newAbstractMethods.isEmpty()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)superClass, (String[])new String[]{"java.lang.FunctionalInterface"});
                if (annotation != null) {
                    conflicts.putValue((Object)annotation, (Object)RefactoringBundle.message((String)"functional.interface.broken"));
                } else {
                    PsiFunctionalExpression functionalExpression = (PsiFunctionalExpression)FunctionalExpressionSearch.search((PsiClass)superClass).findFirst();
                    if (functionalExpression != null) {
                        conflicts.putValue((Object)functionalExpression, (Object)RefactoringBundle.message((String)"functional.interface.broken"));
                    }
                    ClassInheritorsSearch.search((PsiClass)superClass).forEach(sClass -> {
                        if (subclass == null) {
                            PullUpConflictsUtil.$$$reportNull$$$0(5);
                        }
                        if (!sClass.isInheritor(subclass, true) && !sClass.hasModifierProperty("abstract")) {
                            for (PsiMethod aMethod : newAbstractMethods) {
                                if (MethodSignatureUtil.findMethodBySignature((PsiClass)sClass, (PsiMethod)aMethod, (boolean)true) != null) continue;
                                conflicts.putValue(sClass, (Object)("Concrete '" + RefactoringUIUtil.getDescription((PsiElement)sClass, (boolean)true) + "' would inherit a new abstract method"));
                                return false;
                            }
                        }
                        return true;
                    });
                }
            }
        }
        RefactoringConflictsUtil.analyzeAccessibilityConflicts(movedMembers, superClass, (MultiMap<PsiElement, String>)conflicts, "EscalateVisible", (PsiElement)targetRepresentativeElement, abstrMethods);
        if (superClass != null) {
            if (movedMembers2Super) {
                PullUpConflictsUtil.checkSuperclassMembers(superClass, infos, (MultiMap<PsiElement, String>)conflicts);
                if (isInterfaceTarget) {
                    PullUpConflictsUtil.checkInterfaceTarget(infos, (MultiMap<PsiElement, String>)conflicts);
                }
            } else {
                String qualifiedName = superClass.getQualifiedName();
                assert (qualifiedName != null);
                if (superClass.hasModifierProperty("packageLocal") && !Comparing.strEqual((String)StringUtil.getPackageName((String)qualifiedName), (String)targetPackage.getQualifiedName())) {
                    conflicts.putValue((Object)superClass, (Object)(RefactoringUIUtil.getDescription((PsiElement)superClass, (boolean)true) + " won't be accessible from " + RefactoringUIUtil.getDescription((PsiElement)targetPackage, (boolean)true)));
                }
            }
        }
        ArrayList checkModuleConflictsList = new ArrayList();
        for (PsiMember member : movedMembers) {
            if (member instanceof PsiMethod || member instanceof PsiClass && !(member instanceof PsiCompiledElement)) {
                ClassMemberReferencesVisitor visitor = movedMembers2Super ? new ConflictingUsagesOfSubClassMembers((PsiElement)member, movedMembers, abstractMethods, subclass, superClass, superClass != null ? null : targetPackage, (MultiMap<PsiElement, String>)conflicts, interfaceContainmentVerifier) : new ConflictingUsagesOfSuperClassMembers(member, subclass, targetPackage, movedMembers, (MultiMap<PsiElement, String>)conflicts);
                member.accept((PsiElementVisitor)visitor);
            }
            ContainerUtil.addIfNotNull(checkModuleConflictsList, (Object)member);
        }
        for (PsiMethod method : abstractMethods) {
            ContainerUtil.addIfNotNull(checkModuleConflictsList, (Object)method.getParameterList());
            ContainerUtil.addIfNotNull(checkModuleConflictsList, (Object)method.getReturnTypeElement());
            ContainerUtil.addIfNotNull(checkModuleConflictsList, (Object)method.getTypeParameterList());
        }
        RefactoringConflictsUtil.analyzeModuleConflicts(subclass.getProject(), checkModuleConflictsList, UsageInfo.EMPTY_ARRAY, (PsiElement)targetDirectory, (MultiMap<PsiElement, String>)conflicts);
        PsiClassOwner psiFile = (PsiClassOwner)PsiTreeUtil.getParentOfType((PsiElement)subclass, PsiClassOwner.class);
        final boolean toDifferentPackage = !Comparing.strEqual((String)targetPackage.getQualifiedName(), (String)(psiFile != null ? psiFile.getPackageName() : null));
        for (final PsiMethod abstractMethod : abstractMethods) {
            abstractMethod.accept((PsiElementVisitor)new ClassMemberReferencesVisitor(subclass){

                @Override
                protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
                    if (classMember != null && PullUpConflictsUtil.willBeMoved((PsiElement)classMember, movedMembers)) {
                        boolean isAccessible = false;
                        if (classMember.hasModifierProperty("private")) {
                            isAccessible = true;
                        } else if (classMember.hasModifierProperty("packageLocal") && toDifferentPackage) {
                            isAccessible = true;
                        }
                        if (isAccessible) {
                            String message2 = RefactoringUIUtil.getDescription((PsiElement)abstractMethod, (boolean)false) + " uses " + RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true) + " which won't be accessible from the subclass.";
                            message2 = CommonRefactoringUtil.capitalize((String)message2);
                            conflicts.putValue((Object)classMember, (Object)message2);
                        }
                    }
                }
            });
            if (!abstractMethod.hasModifierProperty("packageLocal") || !toDifferentPackage || isInterfaceTarget) continue;
            String message2 = "Can't make " + RefactoringUIUtil.getDescription((PsiElement)abstractMethod, (boolean)false) + " abstract as it won't be accessible from the subclass.";
            message2 = CommonRefactoringUtil.capitalize((String)message2);
            conflicts.putValue((Object)abstractMethod, (Object)message2);
        }
        return conflicts;
    }

    private static List<PsiMethod> newAbstractMethodInSuper(MemberInfoBase<? extends PsiMember>[] infos) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (MemberInfoBase<? extends PsiMember> info : infos) {
            PsiMember member = (PsiMember)info.getMember();
            if (!(member instanceof PsiMethod) || !info.isToAbstract() && !member.hasModifierProperty("abstract")) continue;
            result.add((PsiMethod)member);
        }
        return result;
    }

    private static void checkInterfaceTarget(MemberInfoBase<? extends PsiMember>[] infos, MultiMap<PsiElement, String> conflictsList) {
        for (MemberInfoBase<? extends PsiMember> info : infos) {
            String message2;
            PsiModifierListOwner member = (PsiModifierListOwner)info.getMember();
            if (!(!(member instanceof PsiField) && !(member instanceof PsiClass) || member.hasModifierProperty("static") || member instanceof PsiClass && ((PsiClass)member).isInterface())) {
                message2 = RefactoringBundle.message((String)"0.is.not.static.it.cannot.be.moved.to.the.interface", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
                message2 = CommonRefactoringUtil.capitalize((String)message2);
                conflictsList.putValue((Object)member, (Object)message2);
            }
            if (!(member instanceof PsiField) || ((PsiField)member).getInitializer() != null) continue;
            message2 = RefactoringBundle.message((String)"0.is.not.initialized.in.declaration.such.fields.are.not.allowed.in.interfaces", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            conflictsList.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message2));
        }
    }

    private static void checkSuperclassMembers(PsiClass superClass, MemberInfoBase<? extends PsiMember>[] infos, MultiMap<PsiElement, String> conflictsList) {
        for (MemberInfoBase<? extends PsiMember> info : infos) {
            PsiMethod method;
            PsiModifierList modifierList;
            PsiMember member = (PsiMember)info.getMember();
            boolean isConflict = false;
            if (member instanceof PsiField) {
                String name2 = member.getName();
                isConflict = superClass.findFieldByName(name2, false) != null;
            } else if (member instanceof PsiMethod) {
                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)member.getContainingClass(), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                MethodSignature signature = ((PsiMethod)member).getSignature(superSubstitutor);
                PsiMethod superClassMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)superClass, (MethodSignature)signature, (boolean)false);
                boolean bl = isConflict = superClassMethod != null && !superClassMethod.hasModifierProperty("abstract");
            }
            if (isConflict) {
                String message2 = RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)superClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
                message2 = CommonRefactoringUtil.capitalize((String)message2);
                conflictsList.putValue((Object)superClass, (Object)message2);
            }
            if (!(member instanceof PsiMethod) || (modifierList = (method = (PsiMethod)member).getModifierList()).hasModifierProperty("private")) continue;
            for (PsiClass subClass : ClassInheritorsSearch.search((PsiClass)superClass)) {
                MethodSignature signature;
                PsiMethod wouldBeOverriden;
                if (method.getContainingClass() == subClass || (wouldBeOverriden = MethodSignatureUtil.findMethodBySignature((PsiClass)subClass, (MethodSignature)(signature = ((PsiMethod)member).getSignature(TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)subClass, (PsiSubstitutor)PsiSubstitutor.EMPTY))), (boolean)false)) == null || VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)wouldBeOverriden.getModifierList()), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList)) <= 0) continue;
                conflictsList.putValue((Object)wouldBeOverriden, (Object)CommonRefactoringUtil.capitalize((String)(RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true) + " in super class would clash with local method from " + RefactoringUIUtil.getDescription((PsiElement)subClass, (boolean)true))));
            }
        }
    }

    private static boolean willBeMoved(PsiElement element, Set<PsiMember> movedMembers) {
        for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
            if (!movedMembers.contains(parent)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackage";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subclass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/memberPullUp/PullUpConflictsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConflicts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkConflicts$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConflictingUsagesOfSubClassMembers
    extends ClassMemberReferencesVisitor {
        private final PsiElement myScope;
        private final Set<PsiMember> myMovedMembers;
        private final Set<PsiMethod> myAbstractMethods;
        private final PsiClass mySubclass;
        private final PsiClass mySuperClass;
        private final PsiPackage myTargetPackage;
        private final MultiMap<PsiElement, String> myConflictsList;
        private final InterfaceContainmentVerifier myInterfaceContainmentVerifier;

        ConflictingUsagesOfSubClassMembers(PsiElement scope, Set<PsiMember> movedMembers, Set<PsiMethod> abstractMethods, PsiClass subclass, PsiClass superClass, PsiPackage targetPackage, MultiMap<PsiElement, String> conflictsList, InterfaceContainmentVerifier interfaceContainmentVerifier) {
            super(subclass);
            this.myScope = scope;
            this.myMovedMembers = movedMembers;
            this.myAbstractMethods = abstractMethods;
            this.mySubclass = subclass;
            this.mySuperClass = superClass;
            this.myTargetPackage = targetPackage;
            this.myConflictsList = conflictsList;
            this.myInterfaceContainmentVerifier = interfaceContainmentVerifier;
        }

        @Override
        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (classMember != null && RefactoringHierarchyUtil.isMemberBetween(this.mySuperClass, this.mySubclass, classMember)) {
                if (classMember.hasModifierProperty("static") && !PullUpConflictsUtil.willBeMoved((PsiElement)classMember, this.myMovedMembers)) {
                    boolean isAccessible = this.mySuperClass != null ? PsiUtil.isAccessible((PsiMember)classMember, (PsiElement)this.mySuperClass, null) : (this.myTargetPackage != null ? PsiUtil.isAccessibleFromPackage((PsiModifierListOwner)classMember, (PsiPackage)this.myTargetPackage) : classMember.hasModifierProperty("public"));
                    if (!isAccessible) {
                        String message2 = RefactoringBundle.message((String)"0.uses.1.which.is.not.accessible.from.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)});
                        message2 = CommonRefactoringUtil.capitalize((String)message2);
                        this.myConflictsList.putValue((Object)classMember, (Object)message2);
                    }
                    return;
                }
                if (!(this.myAbstractMethods.contains(classMember) || PullUpConflictsUtil.willBeMoved((PsiElement)classMember, this.myMovedMembers) || this.existsInSuperClass((PsiElement)classMember))) {
                    String message3 = RefactoringBundle.message((String)"0.uses.1.which.is.not.moved.to.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)});
                    message3 = CommonRefactoringUtil.capitalize((String)message3);
                    this.myConflictsList.putValue((Object)classMember, (Object)message3);
                }
            }
        }

        private boolean existsInSuperClass(PsiElement classMember) {
            if (!(classMember instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)classMember;
            if (this.myInterfaceContainmentVerifier.checkedInterfacesContain(method)) {
                return true;
            }
            if (this.mySuperClass == null) {
                return false;
            }
            PsiMethod methodBySignature = this.mySuperClass.findMethodBySignature(method, true);
            return methodBySignature != null;
        }
    }

    private static class ConflictingUsagesOfSuperClassMembers
    extends ClassMemberReferencesVisitor {
        private final PsiMember myMember;
        private final PsiClass mySubClass;
        private final PsiPackage myTargetPackage;
        private final Set<PsiMember> myMovedMembers;
        private final MultiMap<PsiElement, String> myConflicts;

        ConflictingUsagesOfSuperClassMembers(PsiMember member, PsiClass aClass, PsiPackage targetPackage, Set<PsiMember> movedMembers, MultiMap<PsiElement, String> conflicts) {
            super(aClass);
            this.myMember = member;
            this.mySubClass = aClass;
            this.myTargetPackage = targetPackage;
            this.myMovedMembers = movedMembers;
            this.myConflicts = conflicts;
        }

        @Override
        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            PsiClass containingClass;
            if (classMember != null && !PullUpConflictsUtil.willBeMoved((PsiElement)classMember, this.myMovedMembers) && (containingClass = classMember.getContainingClass()) != null && !PsiUtil.isAccessibleFromPackage((PsiModifierListOwner)classMember, (PsiPackage)this.myTargetPackage)) {
                if (classMember.hasModifierProperty("packageLocal")) {
                    this.myConflicts.putValue((Object)this.myMember, (Object)(RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true) + " won't be accessible"));
                } else if (classMember.hasModifierProperty("protected") && !this.mySubClass.isInheritor(containingClass, true)) {
                    this.myConflicts.putValue((Object)this.myMember, (Object)(RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true) + " won't be accessible"));
                }
            }
        }
    }
}

