/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.lang.java.JavaFindUsagesProvider;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil");

    private MoveClassesOrPackagesUtil() {
    }

    public static UsageInfo[] findUsages(PsiElement element, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName) {
        PsiManager manager = element.getManager();
        ArrayList<UsageInfo> results = new ArrayList<UsageInfo>();
        HashSet<PsiReference> foundReferences = new HashSet<PsiReference>();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
        for (PsiReference reference : ReferencesSearch.search((PsiElement)element, (SearchScope)projectScope, (boolean)false)) {
            TextRange range = reference.getRangeInElement();
            if (foundReferences.contains(reference)) continue;
            results.add((UsageInfo)new MoveRenameUsageInfo(reference.getElement(), reference, range.getStartOffset(), range.getEndOffset(), element, false));
            foundReferences.add(reference);
        }
        MoveClassesOrPackagesUtil.findNonCodeUsages(searchInStringsAndComments, searchInNonJavaFiles, element, newQName, results);
        MoveClassesOrPackagesUtil.preprocessUsages(results);
        return results.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static void preprocessUsages(ArrayList<UsageInfo> results) {
        for (MoveClassHandler handler : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            handler.preprocessUsages(results);
        }
    }

    public static void findNonCodeUsages(boolean searchInStringsAndComments, boolean searchInNonJavaFiles, PsiElement element, String newQName, ArrayList<? super UsageInfo> results) {
        String stringToSearch = MoveClassesOrPackagesUtil.getStringToSearch(element);
        if (stringToSearch == null) {
            return;
        }
        TextOccurrencesUtil.findNonCodeUsages((PsiElement)element, (String)stringToSearch, (boolean)searchInStringsAndComments, (boolean)searchInNonJavaFiles, (String)newQName, results);
    }

    private static String getStringToSearch(PsiElement element) {
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiDirectory) {
            return MoveClassesOrPackagesUtil.getStringToSearch((PsiElement)JavaDirectoryService.getInstance().getPackage((PsiDirectory)element));
        }
        if (element instanceof PsiClassOwner) {
            return ((PsiClassOwner)element).getName();
        }
        LOG.error("Unknown element type");
        return null;
    }

    public static PsiPackage doMovePackage(PsiPackage aPackage, MoveDestination moveDestination) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        PackageWrapper targetPackage = moveDestination.getTargetPackage();
        String newPrefix = "".equals(targetPackage.getQualifiedName()) ? "" : targetPackage.getQualifiedName() + ".";
        String newPackageQualifiedName = newPrefix + aPackage.getName();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)aPackage.getProject());
        for (PsiDirectory dir : dirs = aPackage.getDirectories(projectScope)) {
            PsiDirectory targetDirectory = moveDestination.getTargetDirectory(dir);
            if (targetDirectory == null) continue;
            MoveClassesOrPackagesUtil.moveDirectoryRecursively(dir, targetDirectory);
        }
        aPackage.handleQualifiedNameChange(newPackageQualifiedName);
        return JavaPsiFacade.getInstance((Project)targetPackage.getManager().getProject()).findPackage(newPackageQualifiedName);
    }

    public static void moveDirectoryRecursively(PsiDirectory dir, PsiDirectory destination) throws IncorrectOperationException {
        if (dir.getParentDirectory() == destination) {
            return;
        }
        MoveClassesOrPackagesUtil.moveDirectoryRecursively(dir, destination, new HashSet());
    }

    private static void moveDirectoryRecursively(PsiDirectory dir, PsiDirectory destination, HashSet<? super VirtualFile> movedPaths) throws IncorrectOperationException {
        PsiDirectory subdirectoryInDest;
        String sourcePackageName;
        VirtualFile destVFile = destination.getVirtualFile();
        VirtualFile sourceVFile = dir.getVirtualFile();
        if (movedPaths.contains(sourceVFile)) {
            return;
        }
        String targetName = dir.getName();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        if (aPackage != null && !(sourcePackageName = aPackage.getName()).equals(targetName)) {
            targetName = sourcePackageName;
        }
        boolean isSourceRoot = RefactoringUtil.isSourceRoot(dir);
        if (VfsUtil.isAncestor((VirtualFile)sourceVFile, (VirtualFile)destVFile, (boolean)false) || isSourceRoot) {
            PsiDirectory exitsingSubdir = destination.findSubdirectory(targetName);
            if (exitsingSubdir == null) {
                subdirectoryInDest = destination.createSubdirectory(targetName);
                movedPaths.add((VirtualFile)subdirectoryInDest.getVirtualFile());
            } else {
                subdirectoryInDest = exitsingSubdir;
            }
        } else {
            subdirectoryInDest = destination.findSubdirectory(targetName);
        }
        if (subdirectoryInDest == null) {
            VirtualFile virtualFile = dir.getVirtualFile();
            MoveFilesOrDirectoriesUtil.doMoveDirectory((PsiDirectory)dir, (PsiDirectory)destination);
            movedPaths.add((VirtualFile)virtualFile);
        } else {
            PsiDirectory[] subdirectories;
            PsiFile[] files;
            for (PsiFile file : files = dir.getFiles()) {
                try {
                    subdirectoryInDest.checkAdd((PsiElement)file);
                }
                catch (IncorrectOperationException e) {
                    continue;
                }
                MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file, (PsiDirectory)subdirectoryInDest);
            }
            for (PsiDirectory subdirectory : subdirectories = dir.getSubdirectories()) {
                if (subdirectory.equals(subdirectoryInDest)) continue;
                MoveClassesOrPackagesUtil.moveDirectoryRecursively(subdirectory, subdirectoryInDest, movedPaths);
            }
            if (!isSourceRoot && dir.getFiles().length == 0 && dir.getSubdirectories().length == 0) {
                dir.delete();
            }
        }
    }

    public static void prepareMoveClass(PsiClass aClass) {
        for (MoveClassHandler handler : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            handler.prepareMove(aClass);
        }
    }

    public static void finishMoveClass(PsiClass aClass) {
        for (MoveClassHandler handler : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            handler.finishMoveClass(aClass);
        }
    }

    public static PsiClass doMoveClass(PsiClass aClass, PsiDirectory moveDestination) throws IncorrectOperationException {
        return MoveClassesOrPackagesUtil.doMoveClass(aClass, moveDestination, true);
    }

    public static PsiClass doMoveClass(PsiClass aClass, PsiDirectory moveDestination, boolean moveAllClassesInFile) throws IncorrectOperationException {
        String qualifiedName;
        PsiClass newClass;
        if (!moveAllClassesInFile) {
            for (MoveClassHandler handler : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
                newClass = handler.doMoveClass(aClass, moveDestination);
                if (newClass == null) continue;
                return newClass;
            }
        }
        PsiFile file = aClass.getContainingFile();
        PsiPackage newPackage = JavaDirectoryService.getInstance().getPackage(moveDestination);
        newClass = aClass;
        PsiDirectory containingDirectory = file.getContainingDirectory();
        if (!Comparing.equal((Object)moveDestination.getVirtualFile(), (Object)(containingDirectory != null ? containingDirectory.getVirtualFile() : null))) {
            LOG.assertTrue(file.getVirtualFile() != null, (Object)aClass);
            Project project = file.getProject();
            MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file, (PsiDirectory)moveDestination);
            DumbService.getInstance((Project)project).completeJustSubmittedTasks();
            file = moveDestination.findFile(file.getName());
        }
        if (newPackage != null && file instanceof PsiClassOwner && !FileTypeUtils.isInServerPageFile((PsiElement)file) && !PsiUtil.isModuleFile((PsiFile)file) && !Comparing.strEqual((String)(qualifiedName = newPackage.getQualifiedName()), (String)((PsiClassOwner)file).getPackageName()) && (qualifiedName.isEmpty() || PsiNameHelper.getInstance((Project)file.getProject()).isQualifiedName(qualifiedName))) {
            String aClassName = aClass.getName();
            ((PsiClassOwner)file).setPackageName(qualifiedName);
            newClass = MoveClassesOrPackagesUtil.findClassByName((PsiClassOwner)file, aClassName);
            LOG.assertTrue(newClass != null, (Object)("name:" + aClassName + " file:" + file + " classes:" + Arrays.toString(((PsiClassOwner)file).getClasses())));
        }
        return newClass;
    }

    @Nullable
    private static PsiClass findClassByName(PsiClassOwner file, String name2) {
        PsiClass[] classes2;
        for (PsiClass aClass : classes2 = file.getClasses()) {
            if (!name2.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    public static String getPackageName(PackageWrapper aPackage) {
        if (aPackage == null) {
            return null;
        }
        String name2 = aPackage.getQualifiedName();
        if (name2.length() > 0) {
            return name2;
        }
        return JavaFindUsagesProvider.DEFAULT_PACKAGE_NAME;
    }

    @Nullable
    public static PsiDirectory chooseDestinationPackage(Project project, String packageName, @Nullable PsiDirectory baseDir) {
        PsiDirectory directory;
        boolean isBaseDirInTestSources;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PackageWrapper packageWrapper = new PackageWrapper(psiManager, packageName);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        PsiDirectory[] directories = aPackage != null ? aPackage.getDirectories() : null;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile baseDirVirtualFile = baseDir != null ? baseDir.getVirtualFile() : null;
        boolean bl = isBaseDirInTestSources = baseDirVirtualFile != null && fileIndex.isInTestSourceContent(baseDirVirtualFile);
        if (directories != null && directories.length == 1 && (baseDirVirtualFile == null || fileIndex.isInTestSourceContent(directories[0].getVirtualFile()) == isBaseDirInTestSources)) {
            directory = directories[0];
        } else {
            List<VirtualFile> contentSourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots(project);
            if (contentSourceRoots.size() == 1 && (baseDirVirtualFile == null || fileIndex.isInTestSourceContent(contentSourceRoots.get(0)) == isBaseDirInTestSources)) {
                directory = (PsiDirectory)WriteAction.compute(() -> RefactoringUtil.createPackageDirectoryInSourceRoot(packageWrapper, (VirtualFile)contentSourceRoots.get(0)));
            } else {
                VirtualFile sourceRootForFile = MoveClassesOrPackagesUtil.chooseSourceRoot(packageWrapper, contentSourceRoots, baseDir);
                if (sourceRootForFile == null) {
                    return null;
                }
                directory = (PsiDirectory)WriteAction.compute(() -> new AutocreatingSingleSourceRootMoveDestination(packageWrapper, sourceRootForFile).getTargetDirectory((PsiDirectory)null));
            }
        }
        return directory;
    }

    public static VirtualFile chooseSourceRoot(PackageWrapper targetPackage, List<? extends VirtualFile> contentSourceRoots, PsiDirectory initialDirectory) {
        Project project = targetPackage.getManager().getProject();
        LinkedHashSet targetDirectories = new LinkedHashSet();
        HashMap<PsiDirectory, String> relativePathsToCreate = new HashMap<PsiDirectory, String>();
        MoveClassesOrPackagesUtil.buildDirectoryList(targetPackage, contentSourceRoots, targetDirectories, relativePathsToCreate);
        PsiDirectory selectedDirectory = DirectoryChooserUtil.chooseDirectory((PsiDirectory[])targetDirectories.toArray(PsiDirectory.EMPTY_ARRAY), (PsiDirectory)initialDirectory, (Project)project, relativePathsToCreate);
        if (selectedDirectory == null) {
            return null;
        }
        VirtualFile virt = selectedDirectory.getVirtualFile();
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virt);
        LOG.assertTrue(sourceRootForFile != null);
        return sourceRootForFile;
    }

    public static void buildDirectoryList(PackageWrapper aPackage, List<? extends VirtualFile> contentSourceRoots, LinkedHashSet<? super PsiDirectory> targetDirectories, Map<PsiDirectory, String> relativePathsToCreate) {
        PsiDirectory[] directories = aPackage.getDirectories();
        block2: for (VirtualFile virtualFile : contentSourceRoots) {
            String qNameToCreate;
            if (!virtualFile.isDirectory()) continue;
            for (PsiDirectory directory : directories) {
                if (!VfsUtil.isAncestor((VirtualFile)virtualFile, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
                targetDirectories.add((PsiDirectory)directory);
                continue block2;
            }
            try {
                qNameToCreate = RefactoringUtil.qNameToCreateInSourceRoot(aPackage, virtualFile);
            }
            catch (IncorrectOperationException e) {
                continue;
            }
            PsiDirectory currentDirectory = aPackage.getManager().findDirectory(virtualFile);
            if (currentDirectory == null) continue;
            String[] shortNames = qNameToCreate.split("\\.");
            for (int j = 0; j < shortNames.length; ++j) {
                String shortName = shortNames[j];
                PsiDirectory subdirectory = currentDirectory.findSubdirectory(shortName);
                if (subdirectory == null) {
                    targetDirectories.add((PsiDirectory)currentDirectory);
                    StringBuilder postfix = new StringBuilder();
                    for (int k = j; k < shortNames.length; ++k) {
                        String name2 = shortNames[k];
                        postfix.append(File.separatorChar);
                        postfix.append(name2);
                    }
                    relativePathsToCreate.put(currentDirectory, postfix.toString());
                    continue block2;
                }
                currentDirectory = subdirectory;
            }
        }
        LOG.assertTrue(targetDirectories.size() <= contentSourceRoots.size());
        LOG.assertTrue(relativePathsToCreate.size() <= contentSourceRoots.size());
    }
}

