/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.move.moveInstanceMethod.InheritorUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.InternalUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.JavadocUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.MethodCallUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodViewDescriptor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MoveInstanceMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodProcessor");
    private PsiMethod myMethod;
    private PsiVariable myTargetVariable;
    private PsiClass myTargetClass;
    private final String myNewVisibility;
    private final boolean myOpenInEditor;
    private final Map<PsiClass, String> myOldClassParameterNames;

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public PsiVariable getTargetVariable() {
        return this.myTargetVariable;
    }

    public MoveInstanceMethodProcessor(Project project, PsiMethod method, PsiVariable targetVariable, String newVisibility, Map<PsiClass, String> oldClassParameterNames) {
        this(project, method, targetVariable, newVisibility, false, oldClassParameterNames);
    }

    public MoveInstanceMethodProcessor(Project project, PsiMethod method, PsiVariable targetVariable, String newVisibility, boolean openInEditor, Map<PsiClass, String> oldClassParameterNames) {
        super(project);
        this.myMethod = method;
        this.myTargetVariable = targetVariable;
        this.myOpenInEditor = openInEditor;
        this.myOldClassParameterNames = oldClassParameterNames;
        LOG.assertTrue(this.myTargetVariable instanceof PsiParameter || this.myTargetVariable instanceof PsiField);
        LOG.assertTrue(this.myTargetVariable.getType() instanceof PsiClassType);
        PsiType type2 = this.myTargetVariable.getType();
        LOG.assertTrue(type2 instanceof PsiClassType);
        this.myTargetClass = ((PsiClassType)type2).resolve();
        this.myNewVisibility = newVisibility;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(0);
        }
        MoveInstanceMethodViewDescriptor moveInstanceMethodViewDescriptor = new MoveInstanceMethodViewDescriptor(this.myMethod, this.myTargetVariable, this.myTargetClass);
        if (moveInstanceMethodViewDescriptor == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(1);
        }
        return moveInstanceMethodViewDescriptor;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(2);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        HashSet<Object> members = new HashSet<Object>();
        members.add(this.myMethod);
        if (this.myTargetVariable instanceof PsiField) {
            members.add((PsiMember)this.myTargetVariable);
        }
        if (!this.myTargetClass.isInterface()) {
            RefactoringConflictsUtil.analyzeAccessibilityConflicts(members, this.myTargetClass, (MultiMap<PsiElement, String>)conflicts, this.myNewVisibility);
        } else {
            for (UsageInfo usage : usages) {
                if (!(usage instanceof InheritorUsageInfo)) continue;
                RefactoringConflictsUtil.analyzeAccessibilityConflicts(members, ((InheritorUsageInfo)usage).getInheritor(), (MultiMap<PsiElement, String>)conflicts, this.myNewVisibility);
            }
        }
        if (this.myTargetVariable instanceof PsiParameter) {
            PsiParameter parameter2 = (PsiParameter)this.myTargetVariable;
            int index = this.myMethod.getParameterList().getParameterIndex(parameter2);
            for (UsageInfo usageInfo : usages) {
                if (!(usageInfo instanceof MethodCallUsageInfo)) continue;
                PsiElement methodCall = ((MethodCallUsageInfo)usageInfo).getMethodCallExpression();
                if (methodCall instanceof PsiMethodCallExpression) {
                    PsiExpression[] expressions2 = ((PsiMethodCallExpression)methodCall).getArgumentList().getExpressions();
                    if (index >= expressions2.length) continue;
                    PsiExpression instanceValue = expressions2[index];
                    if (!((instanceValue = RefactoringUtil.unparenthesizeExpression(instanceValue)) instanceof PsiLiteralExpression) || ((PsiLiteralExpression)instanceValue).getValue() != null) continue;
                    String message2 = RefactoringBundle.message((String)"0.contains.call.with.null.argument.for.parameter.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(methodCall), (boolean)true), CommonRefactoringUtil.htmlEmphasize((String)parameter2.getName())});
                    conflicts.putValue((Object)instanceValue, (Object)message2);
                    continue;
                }
                if (!(methodCall instanceof PsiMethodReferenceExpression) || !this.shouldBeExpandedToLambda((PsiMethodReferenceExpression)methodCall, index)) continue;
                conflicts.putValue((Object)methodCall, (Object)RefactoringBundle.message((String)"expand.method.reference.warning"));
            }
        }
        try {
            ConflictsUtil.checkMethodConflicts(this.myTargetClass, this.myMethod, this.getPatternMethod(), (MultiMap<PsiElement, String>)conflicts);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return this.showConflicts(conflicts, usages);
    }

    private boolean shouldBeExpandedToLambda(PsiMethodReferenceExpression referenceExpression, int index) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)referenceExpression.getFunctionalInterfaceType());
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
        if (interfaceMethod != null) {
            MethodSignature methodSignature = interfaceMethod.getSignature(LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult));
            if (index == 0 && methodSignature.getParameterTypes().length > 0 && methodSignature.getParameterTypes()[0].isAssignableFrom(this.myMethod.getParameterList().getParameters()[0].getType())) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        PsiCodeBlock body2;
        PsiManager manager = this.myMethod.getManager();
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)manager.getProject());
        final ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)searchScope, (boolean)false)) {
            PsiElement element = ref.getElement();
            if (element instanceof PsiReferenceExpression) {
                boolean isInternal = PsiTreeUtil.isAncestor((PsiElement)this.myMethod, (PsiElement)element, (boolean)true);
                usages.add(new MethodCallUsageInfo((PsiReferenceExpression)element, isInternal));
                continue;
            }
            if (element instanceof PsiDocTagValue) {
                usages.add(new JavadocUsageInfo((PsiDocTagValue)element));
                continue;
            }
            throw new BaseRefactoringProcessor.UnknownReferenceTypeException(element.getLanguage());
        }
        if (this.myTargetClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myTargetClass)) {
            MoveInstanceMethodProcessor.addInheritorUsages(this.myTargetClass, searchScope, usages);
        }
        if ((body2 = this.myMethod.getBody()) != null) {
            body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitNewExpression(PsiNewExpression expression2) {
                    if (MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression2) != null) {
                        usages.add(new InternalUsageInfo((PsiElement)expression2));
                    }
                    super.visitNewExpression(expression2);
                }

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    if (MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression2) != null) {
                        usages.add(new InternalUsageInfo((PsiElement)expression2));
                    } else if (!expression2.isQualified()) {
                        PsiElement resolved = expression2.resolve();
                        if (MoveInstanceMethodProcessor.this.myTargetVariable.equals(resolved)) {
                            usages.add(new InternalUsageInfo((PsiElement)expression2));
                        }
                    }
                    super.visitReferenceExpression(expression2);
                }
            });
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    private static void addInheritorUsages(PsiClass aClass, GlobalSearchScope searchScope, List<UsageInfo> usages) {
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)searchScope, (boolean)false).findAll()) {
            if (!inheritor.isInterface()) {
                usages.add(new InheritorUsageInfo(inheritor));
                continue;
            }
            MoveInstanceMethodProcessor.addInheritorUsages(inheritor, searchScope, usages);
        }
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(elements.length == 3);
        this.myMethod = (PsiMethod)elements[0];
        this.myTargetVariable = (PsiVariable)elements[1];
        this.myTargetClass = (PsiClass)elements[2];
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"move.instance.method.command");
        if (string == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(6);
        }
        PsiMethod patternMethod = this.createMethodToAdd();
        ArrayList<PsiReference> docRefs = new ArrayList<PsiReference>();
        for (UsageInfo usage : usages) {
            if (usage instanceof InheritorUsageInfo) {
                PsiClass inheritor = ((InheritorUsageInfo)usage).getInheritor();
                MoveInstanceMethodProcessor.addMethodToClass(inheritor, patternMethod, true);
                continue;
            }
            if (usage instanceof MethodCallUsageInfo && !((MethodCallUsageInfo)usage).isInternal()) {
                PsiElement expression2 = ((MethodCallUsageInfo)usage).getMethodCallExpression();
                if (expression2 instanceof PsiMethodCallExpression) {
                    this.correctMethodCall((PsiMethodCallExpression)expression2, false);
                    continue;
                }
                if (!(expression2 instanceof PsiMethodReferenceExpression)) continue;
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)expression2;
                PsiExpression qualifierExpression2 = methodReferenceExpression.getQualifierExpression();
                if (this.myTargetVariable instanceof PsiParameter && this.shouldBeExpandedToLambda(methodReferenceExpression, this.myMethod.getParameterList().getParameterIndex((PsiParameter)this.myTargetVariable))) {
                    List returnExpressions;
                    PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda(methodReferenceExpression, false, true);
                    if (lambdaExpression == null || (returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression)).isEmpty()) continue;
                    this.correctMethodCall((PsiMethodCallExpression)returnExpressions.get(0), false);
                    continue;
                }
                String exprText = this.myTargetVariable instanceof PsiParameter || qualifierExpression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression2).resolve() == this.myMethod.getContainingClass() ? this.myTargetVariable.getType().getCanonicalText() : (qualifierExpression2 instanceof PsiReferenceExpression ? qualifierExpression2.getText() + "." + this.myTargetVariable.getName() : this.myTargetVariable.getName());
                PsiExpression newQualifier = JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText(exprText, null);
                ((PsiMethodReferenceExpression)expression2).setQualifierExpression(newQualifier);
                JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(expression2);
                continue;
            }
            if (!(usage instanceof JavadocUsageInfo)) continue;
            docRefs.add(usage.getElement().getReference());
        }
        try {
            if (this.myTargetClass.isInterface()) {
                PsiModifierList modifierList = patternMethod.getModifierList();
                if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myTargetClass)) {
                    patternMethod.getBody().delete();
                    modifierList.setModifierProperty("default", false);
                } else {
                    modifierList.setModifierProperty("default", true);
                }
                RefactoringUtil.makeMethodAbstract(this.myTargetClass, patternMethod);
            }
            PsiMethod method = MoveInstanceMethodProcessor.addMethodToClass(this.myTargetClass, patternMethod, false);
            this.myMethod.delete();
            for (PsiReference reference : docRefs) {
                reference.bindToElement((PsiElement)method);
            }
            VisibilityUtil.fixVisibility((PsiElement[])UsageViewUtil.toElements((UsageInfo[])usages), (PsiMember)method, (String)this.myNewVisibility);
            if (this.myOpenInEditor) {
                EditorHelper.openInEditor((PsiElement)method);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void correctMethodCall(PsiMethodCallExpression expression2, boolean isInternalCall) {
        try {
            PsiClass resolved;
            PsiType type2;
            PsiManager manager = this.myMethod.getManager();
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            if (!methodExpression.isReferenceTo((PsiElement)this.myMethod)) {
                return;
            }
            PsiExpression oldQualifier = methodExpression.getQualifierExpression();
            PsiExpression newQualifier = null;
            PsiClass classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)methodExpression);
            if (this.myTargetVariable instanceof PsiParameter) {
                PsiExpression[] arguments;
                int index = this.myMethod.getParameterList().getParameterIndex((PsiParameter)this.myTargetVariable);
                if (index < (arguments = expression2.getArgumentList().getExpressions()).length) {
                    newQualifier = (PsiExpression)arguments[index].copy();
                    arguments[index].delete();
                }
            } else {
                PsiClass aClass;
                VisibilityUtil.escalateVisibility((PsiMember)((PsiField)this.myTargetVariable), (PsiElement)expression2);
                String newQualifierName = this.myTargetVariable.getName();
                if (this.myTargetVariable instanceof PsiField && oldQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)oldQualifier.getType())) == ((PsiField)this.myTargetVariable).getContainingClass()) {
                    newQualifierName = oldQualifier.getText() + "." + newQualifierName;
                }
                newQualifier = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(newQualifierName, null);
            }
            PsiExpression newArgument = null;
            if (classReferencedByThis != null) {
                String thisArgumentText = null;
                if (manager.areElementsEquivalent((PsiElement)this.myMethod.getContainingClass(), (PsiElement)classReferencedByThis)) {
                    if (this.myOldClassParameterNames.containsKey(this.myMethod.getContainingClass())) {
                        thisArgumentText = "this";
                    }
                } else {
                    String name2 = classReferencedByThis.getName();
                    thisArgumentText = name2 != null ? name2 + ".this" : "this";
                }
                if (thisArgumentText != null) {
                    newArgument = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(thisArgumentText, null);
                }
            } else if (!isInternalCall && oldQualifier != null && (type2 = oldQualifier.getType()) instanceof PsiClassType && (resolved = ((PsiClassType)type2).resolve()) != null && this.getParameterNameToCreate(resolved) != null) {
                newArgument = this.replaceRefsToTargetVariable(oldQualifier);
            }
            if (newArgument != null) {
                expression2.getArgumentList().add(newArgument);
            }
            if (newQualifier != null) {
                if (newQualifier instanceof PsiThisExpression && ((PsiThisExpression)newQualifier).getQualifier() == null) {
                    if (oldQualifier != null) {
                        oldQualifier.delete();
                    }
                } else {
                    PsiReferenceExpression refExpr = (PsiReferenceExpression)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText("q." + this.myMethod.getName(), null);
                    refExpr.getQualifierExpression().replace((PsiElement)newQualifier);
                    methodExpression.replace((PsiElement)refExpr);
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiExpression replaceRefsToTargetVariable(PsiExpression expression2) {
        final PsiManager manager = expression2.getManager();
        if (ExpressionUtils.isReferenceTo(expression2, this.myTargetVariable)) {
            return MoveInstanceMethodProcessor.createThisExpr(manager);
        }
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.isReferenceTo((PsiElement)MoveInstanceMethodProcessor.this.myTargetVariable)) {
                    try {
                        expression2.replace((PsiElement)MoveInstanceMethodProcessor.createThisExpr(manager));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        return expression2;
    }

    private static PsiExpression createThisExpr(PsiManager manager) {
        try {
            return JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText("this", null);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiMethod addMethodToClass(PsiClass aClass, PsiMethod patternMethod, boolean canAddOverride) {
        try {
            PsiMethod method = (PsiMethod)aClass.add((PsiElement)patternMethod);
            ChangeContextUtil.decodeContextInfo((PsiElement)method, null, null);
            if (canAddOverride && OverrideImplementUtil.isInsertOverride(method, aClass)) {
                method.getModifierList().addAnnotation("java.lang.Override");
            }
            return method;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private PsiMethod createMethodToAdd() {
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myMethod, true);
        try {
            final PsiManager manager = this.myMethod.getManager();
            final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            final PsiElementFactory factory = facade.getElementFactory();
            PsiCodeBlock body2 = this.myMethod.getBody();
            if (body2 != null) {
                final HashMap replaceMap = new HashMap();
                body2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitThisExpression(PsiThisExpression expression2) {
                        PsiClass classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression2);
                        if (classReferencedByThis != null && !PsiTreeUtil.isAncestor((PsiElement)MoveInstanceMethodProcessor.this.myMethod, (PsiElement)classReferencedByThis, (boolean)false)) {
                            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)MoveInstanceMethodProcessor.this.myProject);
                            String paramName = MoveInstanceMethodProcessor.this.getParameterNameToCreate(classReferencedByThis);
                            try {
                                PsiExpression refExpression = factory2.createExpressionFromText(paramName, null);
                                replaceMap.put(expression2, refExpression);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        try {
                            String paramName;
                            PsiClass classReferencedByThis;
                            PsiExpression qualifier = expression2.getQualifierExpression();
                            PsiElement resolved = expression2.resolve();
                            if (ExpressionUtils.isReferenceTo(qualifier, MoveInstanceMethodProcessor.this.myTargetVariable)) {
                                if (resolved instanceof PsiField) {
                                    String fieldName = ((PsiField)resolved).getName();
                                    LOG.assertTrue(fieldName != null);
                                    for (PsiParameter parameter2 : MoveInstanceMethodProcessor.this.myMethod.getParameterList().getParameters()) {
                                        if (!Comparing.strEqual((String)parameter2.getName(), (String)fieldName) && facade.getResolveHelper().resolveReferencedVariable(fieldName, (PsiElement)expression2) == null) continue;
                                        qualifier.replace((PsiElement)factory.createExpressionFromText("this", null));
                                        return;
                                    }
                                }
                                if (expression2 instanceof PsiMethodReferenceExpression) {
                                    qualifier.replace((PsiElement)factory.createExpressionFromText("this", null));
                                } else {
                                    qualifier.delete();
                                }
                                return;
                            }
                            if (MoveInstanceMethodProcessor.this.myTargetVariable.equals(resolved)) {
                                PsiThisExpression thisExpression = RefactoringChangeUtil.createThisExpression(manager, PsiTreeUtil.isAncestor((PsiElement)MoveInstanceMethodProcessor.this.myMethod, (PsiElement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class), (boolean)true) ? MoveInstanceMethodProcessor.this.myTargetClass : null);
                                replaceMap.put(expression2, thisExpression);
                                return;
                            }
                            if (!MoveInstanceMethodProcessor.this.myMethod.equals(resolved) && (classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression2)) != null && (paramName = MoveInstanceMethodProcessor.this.getParameterNameToCreate(classReferencedByThis)) != null) {
                                PsiReferenceExpression newQualifier = (PsiReferenceExpression)factory.createExpressionFromText(paramName, null);
                                expression2.setQualifierExpression((PsiExpression)newQualifier);
                                return;
                            }
                            super.visitReferenceExpression(expression2);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }

                    public void visitNewExpression(PsiNewExpression expression2) {
                        try {
                            PsiExpression qualifier = expression2.getQualifier();
                            if (ExpressionUtils.isReferenceTo(qualifier, MoveInstanceMethodProcessor.this.myTargetVariable)) {
                                qualifier.delete();
                            } else {
                                PsiClass classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression2);
                                if (classReferencedByThis != null) {
                                    if (qualifier != null) {
                                        qualifier.delete();
                                    }
                                    String paramName = MoveInstanceMethodProcessor.this.getParameterNameToCreate(classReferencedByThis);
                                    PsiExpression newExpression = factory.createExpressionFromText(paramName + "." + expression2.getText(), null);
                                    replaceMap.put(expression2, newExpression);
                                }
                            }
                            super.visitNewExpression(expression2);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }

                    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                        MoveInstanceMethodProcessor.this.correctMethodCall(expression2, true);
                        super.visitMethodCallExpression(expression2);
                    }
                });
                for (PsiElement element : replaceMap.keySet()) {
                    PsiElement replacement = (PsiElement)replaceMap.get(element);
                    element.replace(replacement);
                }
            }
            PsiMethod methodCopy = this.getPatternMethod();
            List<PsiParameter> newParameters = Arrays.asList(methodCopy.getParameterList().getParameters());
            RefactoringUtil.fixJavadocsForParams(methodCopy, new HashSet<PsiParameter>(newParameters));
            return methodCopy;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return this.myMethod;
        }
    }

    private PsiMethod getPatternMethod() throws IncorrectOperationException {
        String name2;
        PsiMethod methodCopy = (PsiMethod)this.myMethod.copy();
        String string = this.myTargetClass.isInterface() ? "public" : (name2 = !Comparing.strEqual((String)this.myNewVisibility, (String)"EscalateVisible") ? this.myNewVisibility : null);
        if (name2 != null) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)methodCopy, (String)name2, (boolean)true);
        }
        if (this.myTargetVariable instanceof PsiParameter) {
            int index = this.myMethod.getParameterList().getParameterIndex((PsiParameter)this.myTargetVariable);
            methodCopy.getParameterList().getParameters()[index].delete();
        }
        this.addParameters(JavaPsiFacade.getElementFactory((Project)this.myProject), methodCopy, this.myTargetClass.isInterface());
        return methodCopy;
    }

    private void addParameters(PsiElementFactory factory, PsiMethod methodCopy, boolean isInterface) throws IncorrectOperationException {
        Set<Map.Entry<PsiClass, String>> entries = this.myOldClassParameterNames.entrySet();
        for (Map.Entry<PsiClass, String> entry : entries) {
            PsiClassType type2 = factory.createType(entry.getKey());
            PsiParameter parameter2 = factory.createParameter(entry.getValue(), (PsiType)type2);
            if (isInterface) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)parameter2, (String)"final", (boolean)false);
            }
            methodCopy.getParameterList().add((PsiElement)parameter2);
        }
    }

    private String getParameterNameToCreate(@NotNull PsiClass aClass) {
        if (aClass == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(7);
        }
        return this.myOldClassParameterNames.get(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNameToCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

