/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook.deductive;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiTypeVariableFactory {
    private int myCurrent;
    private final List<Set<PsiTypeVariable>> myClusters = new LinkedList<Set<PsiTypeVariable>>();
    private final Map<Integer, Set<PsiTypeVariable>> myVarCluster = new HashMap<Integer, Set<PsiTypeVariable>>();

    public final int getNumber() {
        return this.myCurrent;
    }

    public final void registerCluster(Set<PsiTypeVariable> cluster) {
        this.myClusters.add(cluster);
        for (PsiTypeVariable aCluster : cluster) {
            this.myVarCluster.put(new Integer(aCluster.getIndex()), cluster);
        }
    }

    public final List<Set<PsiTypeVariable>> getClusters() {
        return this.myClusters;
    }

    public final Set<PsiTypeVariable> getClusterOf(int var) {
        return this.myVarCluster.get(new Integer(var));
    }

    public final PsiTypeVariable create() {
        return this.create(null);
    }

    public final PsiTypeVariable create(final PsiElement context) {
        return new PsiTypeVariable(){
            private final int myIndex;
            private final PsiElement myContext;
            {
                this.myIndex = PsiTypeVariableFactory.this.myCurrent++;
                this.myContext = context;
            }

            @Override
            public boolean isValidInContext(PsiType type2) {
                if (this.myContext == null) {
                    return true;
                }
                if (type2 == null) {
                    return true;
                }
                return (Boolean)type2.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

                    public Boolean visitType(PsiType type2) {
                        return Boolean.TRUE;
                    }

                    public Boolean visitArrayType(PsiArrayType arrayType) {
                        return (Boolean)arrayType.getDeepComponentType().accept((PsiTypeVisitor)this);
                    }

                    public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                        PsiType bound = wildcardType.getBound();
                        if (bound != null) {
                            bound.accept((PsiTypeVisitor)this);
                        }
                        return Boolean.TRUE;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Boolean visitClassType(PsiClassType classType) {
                        PsiClassType.ClassResolveResult result = classType.resolveGenerics();
                        PsiClass aClass = result.getElement();
                        PsiSubstitutor aSubst = result.getSubstitutor();
                        if (aClass == null) return Boolean.FALSE;
                        PsiManager manager = aClass.getManager();
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
                        if (aClass instanceof PsiTypeParameter) {
                            PsiTypeParameter typeParameter;
                            PsiTypeParameterListOwner owner2 = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)myContext, PsiTypeParameterListOwner.class);
                            if (owner2 == null) return Boolean.FALSE;
                            boolean found = false;
                            Iterator iterator = PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)owner2).iterator();
                            while (iterator.hasNext() && !(found = manager.areElementsEquivalent((PsiElement)(typeParameter = (PsiTypeParameter)iterator.next()), (PsiElement)aClass))) {
                            }
                            if (!found) {
                                return Boolean.FALSE;
                            }
                        } else if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, myContext, null)) {
                            return Boolean.FALSE;
                        }
                        for (PsiTypeParameter parm : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                            Boolean b;
                            PsiType type2 = aSubst.substitute(parm);
                            if (type2 == null || (b = (Boolean)type2.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                });
            }

            @NotNull
            public String getPresentableText() {
                String string = "$" + this.myIndex;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getCanonicalText() {
                String string = this.getPresentableText();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isValid() {
                return true;
            }

            public boolean equalsToText(@NotNull String text2) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return text2.equals(this.getPresentableText());
            }

            public GlobalSearchScope getResolveScope() {
                return null;
            }

            @NotNull
            public PsiType[] getSuperTypes() {
                if (EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(3);
                }
                return EMPTY_ARRAY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof PsiTypeVariable)) {
                    return false;
                }
                PsiTypeVariable psiTypeVariable = (PsiTypeVariable)((Object)o);
                return this.myIndex == psiTypeVariable.getIndex();
            }

            public int hashCode() {
                return this.myIndex;
            }

            @Override
            public int getIndex() {
                return this.myIndex;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/typeCook/deductive/PsiTypeVariableFactory$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCanonicalText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/typeCook/deductive/PsiTypeVariableFactory$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSuperTypes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "equalsToText";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }
}

