/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.util.IncorrectOperationException;
import java.util.List;

class ConstantMatchProvider
implements MatchProvider {
    private final PsiField myField;
    private final Project myProject;
    private final List<Match> myMatches;
    private static final Logger LOG = Logger.getInstance(ConstantMatchProvider.class);

    ConstantMatchProvider(PsiMember member, Project project, List<Match> matches) {
        this.myField = (PsiField)member;
        this.myProject = project;
        this.myMatches = matches;
    }

    @Override
    public void prepareSignature(Match match) {
    }

    @Override
    public PsiElement processMatch(Match match) throws IncorrectOperationException {
        PsiClass containingClass = this.myField.getContainingClass();
        LOG.assertTrue(containingClass != null, (Object)this.myField);
        String fieldReference = this.myField.getName();
        PsiElement start = match.getMatchStart();
        if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)start, (boolean)false)) {
            fieldReference = containingClass.getQualifiedName() + "." + fieldReference;
        }
        return match.replaceWithExpression(JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText(fieldReference, (PsiElement)this.myField));
    }

    @Override
    public List<Match> getDuplicates() {
        return this.myMatches;
    }

    @Override
    public Boolean hasDuplicates() {
        return !this.myMatches.isEmpty();
    }

    @Override
    public String getConfirmDuplicatePrompt(Match match) {
        return null;
    }

    @Override
    public String getReplaceDuplicatesTitle(int idx, int size) {
        return RefactoringBundle.message((String)"process.duplicates.title", (Object[])new Object[]{idx, size});
    }
}

