/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.wrapreturnvalue.WrapReturnValueProcessor;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class WrapReturnValueDialog
extends RefactoringDialog {
    private final PsiMethod sourceMethod;
    private JTextField sourceMethodTextField;
    private JRadioButton createNewClassButton;
    private JTextField classNameField;
    private PackageNameReferenceEditorCombo packageTextField;
    private JPanel myNewClassPanel;
    private ReferenceEditorComboWithBrowseButton existingClassField;
    private JRadioButton useExistingClassButton;
    private JComboBox<PsiField> myFieldsCombo;
    private JPanel myExistingClassPanel;
    private JPanel myWholePanel;
    private JRadioButton myCreateInnerClassButton;
    private JTextField myInnerClassNameTextField;
    private JPanel myCreateInnerPanel;
    private ComboboxWithBrowseButton myDestinationCb;
    private static final String RECENT_KEYS = "WrapReturnValue.RECENT_KEYS";

    WrapReturnValueDialog(PsiMethod sourceMethod) {
        super(sourceMethod.getProject(), true);
        this.sourceMethod = sourceMethod;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(RefactorJBundle.message("wrap.return.value.title", objectArray));
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.WrapReturnValue";
    }

    protected void doAction() {
        String packageName;
        String className;
        boolean useExistingClass = this.useExistingClassButton.isSelected();
        boolean createInnerClass = this.myCreateInnerClassButton.isSelected();
        String existingClassName = this.existingClassField.getText().trim();
        if (useExistingClass) {
            className = StringUtil.getShortName((String)existingClassName);
            packageName = StringUtil.getPackageName((String)existingClassName);
        } else if (createInnerClass) {
            className = this.getInnerClassName();
            packageName = "";
        } else {
            className = this.getClassName();
            packageName = this.getPackageName();
        }
        this.invokeRefactoring((BaseRefactoringProcessor)new WrapReturnValueProcessor(className, packageName, ((DestinationFolderComboBox)this.myDestinationCb).selectDirectory(new PackageWrapper(this.sourceMethod.getManager(), packageName), false), this.sourceMethod, useExistingClass, createInnerClass, (PsiField)this.myFieldsCombo.getSelectedItem()));
    }

    protected void canRun() throws ConfigurationException {
        Project project = this.sourceMethod.getProject();
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project);
        if (this.myCreateInnerClassButton.isSelected()) {
            String innerClassName = this.getInnerClassName().trim();
            if (!nameHelper.isIdentifier(innerClassName)) {
                throw new ConfigurationException("'" + innerClassName + "' is invalid inner class name");
            }
            PsiClass containingClass = this.sourceMethod.getContainingClass();
            if (containingClass != null && containingClass.findInnerClassByName(innerClassName, false) != null) {
                throw new ConfigurationException("Inner class with name '" + innerClassName + "' already exist");
            }
        } else if (this.useExistingClassButton.isSelected()) {
            String className = this.existingClassField.getText().trim();
            if (className.length() == 0 || !nameHelper.isQualifiedName(className)) {
                throw new ConfigurationException("'" + className + "' is invalid qualified wrapper class name");
            }
            Object item = this.myFieldsCombo.getSelectedItem();
            if (item == null) {
                throw new ConfigurationException("Wrapper field not found");
            }
        } else {
            String className = this.getClassName();
            if (className.length() == 0 || !nameHelper.isIdentifier(className)) {
                throw new ConfigurationException("'" + className + "' is invalid wrapper class name");
            }
            String packageName = this.getPackageName();
            if (packageName.length() == 0 || !nameHelper.isQualifiedName(packageName)) {
                throw new ConfigurationException("'" + packageName + "' is invalid wrapper class package name");
            }
        }
    }

    private String getInnerClassName() {
        return this.myInnerClassNameTextField.getText().trim();
    }

    @NotNull
    public String getPackageName() {
        String string = this.packageTextField.getText().trim();
        if (string == null) {
            WrapReturnValueDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.classNameField.getText().trim();
        if (string == null) {
            WrapReturnValueDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        this.sourceMethodTextField.setEditable(false);
        DocumentAdapter docListener = new DocumentAdapter(){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                WrapReturnValueDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/wrapreturnvalue/WrapReturnValueDialog$1", "textChanged"));
            }
        };
        this.classNameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        this.myFieldsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WrapReturnValueDialog.this.validateButtons();
            }
        });
        this.myInnerClassNameTextField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        PsiFile file = this.sourceMethod.getContainingFile();
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            this.packageTextField.setText(packageName);
        }
        PsiClass containingClass = this.sourceMethod.getContainingClass();
        assert (containingClass != null) : this.sourceMethod;
        String containingClassName = containingClass instanceof PsiAnonymousClass ? "Anonymous " + ((PsiAnonymousClass)containingClass).getBaseClassType().getClassName() : containingClass.getName();
        String sourceMethodName = this.sourceMethod.getName();
        this.sourceMethodTextField.setText(containingClassName + '.' + sourceMethodName);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useExistingClassButton);
        buttonGroup.add(this.createNewClassButton);
        buttonGroup.add(this.myCreateInnerClassButton);
        this.createNewClassButton.setSelected(true);
        ActionListener enableListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WrapReturnValueDialog.this.toggleRadioEnablement();
            }
        };
        this.useExistingClassButton.addActionListener(enableListener);
        this.createNewClassButton.addActionListener(enableListener);
        this.myCreateInnerClassButton.addActionListener(enableListener);
        this.toggleRadioEnablement();
        final DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.myFieldsCombo.setModel(model);
        this.myFieldsCombo.setRenderer((ListCellRenderer<PsiField>)new ListCellRendererWrapper<PsiField>(){

            public void customize(JList list, PsiField field, int index, boolean selected, boolean hasFocus) {
                if (field != null) {
                    this.setText(field.getName());
                    this.setIcon(field.getIcon(1));
                }
            }
        });
        ((EditorComboBox)this.existingClassField.getChildComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                JavaPsiFacade facade;
                PsiClass currentClass;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((currentClass = (facade = JavaPsiFacade.getInstance((Project)WrapReturnValueDialog.this.myProject)).findClass(WrapReturnValueDialog.this.existingClassField.getText(), GlobalSearchScope.allScope((Project)WrapReturnValueDialog.this.myProject))) != null) {
                    model.removeAllElements();
                    PsiType returnType = WrapReturnValueDialog.this.sourceMethod.getReturnType();
                    assert (returnType != null);
                    for (PsiField field : currentClass.getFields()) {
                        PsiType fieldType = field.getType();
                        if (TypeConversionUtil.isAssignable((PsiType)fieldType, (PsiType)returnType)) {
                            model.addElement(field);
                            continue;
                        }
                        if (WrapReturnValueProcessor.getInferredType(fieldType, returnType, currentClass, WrapReturnValueDialog.this.sourceMethod) == null) continue;
                        model.addElement(field);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/wrapreturnvalue/WrapReturnValueDialog$5", "documentChanged"));
            }
        });
        return this.myWholePanel;
    }

    private void toggleRadioEnablement() {
        UIUtil.setEnabled((Component)this.myExistingClassPanel, (boolean)this.useExistingClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myNewClassPanel, (boolean)this.createNewClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myCreateInnerPanel, (boolean)this.myCreateInnerClassButton.isSelected(), (boolean)true);
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        if (this.useExistingClassButton.isSelected()) {
            focusManager.requestFocus((Component)((Object)this.existingClassField), true);
        } else if (this.myCreateInnerClassButton.isSelected()) {
            focusManager.requestFocus((Component)this.myInnerClassNameTextField, true);
        } else {
            focusManager.requestFocus((Component)this.classNameField, true);
        }
        this.validateButtons();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classNameField;
    }

    protected String getHelpId() {
        return "refactorj.wrapReturnValue";
    }

    private void createUIComponents() {
        DocumentListener adapter = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                WrapReturnValueDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/wrapreturnvalue/WrapReturnValueDialog$6", "documentChanged"));
            }
        };
        this.packageTextField = new PackageNameReferenceEditorCombo("", this.myProject, RECENT_KEYS, RefactoringBundle.message((String)"choose.destination.package"));
        ((EditorComboBox)this.packageTextField.getChildComponent()).getDocument().addDocumentListener(adapter);
        this.existingClassField = new ReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)WrapReturnValueDialog.this.getProject()).createWithInnerClassesScopeChooser(RefactorJBundle.message("select.wrapper.class", new Object[0]), GlobalSearchScope.allScope((Project)WrapReturnValueDialog.this.myProject), null, null);
                String classText = WrapReturnValueDialog.this.existingClassField.getText();
                PsiClass currentClass = JavaPsiFacade.getInstance((Project)WrapReturnValueDialog.this.myProject).findClass(classText, GlobalSearchScope.allScope((Project)WrapReturnValueDialog.this.myProject));
                if (currentClass != null) {
                    chooser.select(currentClass);
                }
                chooser.showDialog();
                PsiClass selectedClass = chooser.getSelected();
                if (selectedClass != null) {
                    WrapReturnValueDialog.this.existingClassField.setText(selectedClass.getQualifiedName());
                }
            }
        }, "", this.myProject, true, RECENT_KEYS);
        ((EditorComboBox)this.existingClassField.getChildComponent()).getDocument().addDocumentListener(adapter);
        this.myDestinationCb = new DestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return WrapReturnValueDialog.this.getPackageName();
            }
        };
        ((DestinationFolderComboBox)this.myDestinationCb).setData(this.myProject, this.sourceMethod.getContainingFile().getContainingDirectory(), (EditorComboBox)this.packageTextField.getChildComponent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/wrapreturnvalue/WrapReturnValueDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JTextField jTextField2;
        JPanel jPanel2;
        JTextField jTextField3;
        JPanel jPanel3;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.createNewClassButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Create new class");
        jRadioButton3.setMnemonic('C');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.useExistingClassButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Use existing class");
        jRadioButton2.setMnemonic('U');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jRadioButton2, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNewClassPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.classNameField = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Package name");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PackageNameReferenceEditorCombo packageNameReferenceEditorCombo = this.packageTextField;
        jPanel3.add((Component)((Object)packageNameReferenceEditorCombo), new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("target.destination.folder"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myDestinationCb;
        jPanel3.add((Component)comboboxWithBrowseButton, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myExistingClassPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Name");
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.existingClassField;
        jPanel2.add((Component)((Object)referenceEditorComboWithBrowseButton), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myFieldsCombo = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Wrapper field");
        jLabel5.setDisplayedMnemonic('F');
        jLabel5.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.sourceMethodTextField = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(400, -1), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/refactoring/RefactorJBundle").getString("method.to.wrap.returns.from.label"));
        jPanel4.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCreateInnerClassButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Create inner class");
        jRadioButton.setMnemonic('I');
        jRadioButton.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCreateInnerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Name");
        jLabel7.setDisplayedMnemonic('M');
        jLabel7.setDisplayedMnemonicIndex(2);
        jPanel.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInnerClassNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jTextField3);
        jLabel3.setLabelFor((Component)comboboxWithBrowseButton);
        jLabel4.setLabelFor(jComboBox);
        jLabel5.setLabelFor(jComboBox);
        jLabel7.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

