/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class JavaTestFramework
implements TestFramework {
    public boolean isLibraryAttached(@NotNull Module module) {
        if (module == null) {
            JavaTestFramework.$$$reportNull$$$0(0);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiClass c = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(this.getMarkerClassFQName(), scope);
        return c != null;
    }

    @Nullable
    public String getLibraryPath() {
        ExternalLibraryDescriptor descriptor2 = this.getFrameworkLibraryDescriptor();
        if (descriptor2 != null) {
            return descriptor2.getLibraryClassesRoots().get(0);
        }
        return null;
    }

    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return null;
    }

    protected abstract String getMarkerClassFQName();

    public boolean isTestClass(@NotNull PsiElement clazz) {
        if (clazz == null) {
            JavaTestFramework.$$$reportNull$$$0(1);
        }
        return clazz instanceof PsiClass && this.isTestClass((PsiClass)clazz, false);
    }

    public boolean isPotentialTestClass(@NotNull PsiElement clazz) {
        if (clazz == null) {
            JavaTestFramework.$$$reportNull$$$0(2);
        }
        return clazz instanceof PsiClass && this.isTestClass((PsiClass)clazz, true);
    }

    protected abstract boolean isTestClass(PsiClass var1, boolean var2);

    protected boolean isUnderTestSources(PsiClass clazz) {
        PsiFile psiFile = clazz.getContainingFile();
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)clazz.getProject()).getFileIndex().isInTestSourceContent(vFile);
    }

    @Nullable
    public PsiElement findSetUpMethod(@NotNull PsiElement clazz) {
        if (clazz == null) {
            JavaTestFramework.$$$reportNull$$$0(3);
        }
        return clazz instanceof PsiClass ? this.findSetUpMethod((PsiClass)clazz) : null;
    }

    @Nullable
    protected abstract PsiMethod findSetUpMethod(@NotNull PsiClass var1);

    @Nullable
    public PsiElement findTearDownMethod(@NotNull PsiElement clazz) {
        if (clazz == null) {
            JavaTestFramework.$$$reportNull$$$0(4);
        }
        return clazz instanceof PsiClass ? this.findTearDownMethod((PsiClass)clazz) : null;
    }

    @Nullable
    protected abstract PsiMethod findTearDownMethod(@NotNull PsiClass var1);

    public PsiElement findOrCreateSetUpMethod(@NotNull PsiElement clazz) throws IncorrectOperationException {
        if (clazz == null) {
            JavaTestFramework.$$$reportNull$$$0(5);
        }
        return clazz instanceof PsiClass ? this.findOrCreateSetUpMethod((PsiClass)clazz) : null;
    }

    public boolean isIgnoredMethod(PsiElement element) {
        return false;
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            JavaTestFramework.$$$reportNull$$$0(6);
        }
        return javaLanguage;
    }

    @Nullable
    protected abstract PsiMethod findOrCreateSetUpMethod(PsiClass var1) throws IncorrectOperationException;

    public boolean isParameterized(PsiClass clazz) {
        return false;
    }

    @Nullable
    public PsiMethod findParametersMethod(PsiClass clazz) {
        return null;
    }

    @Nullable
    public FileTemplateDescriptor getParametersMethodFileTemplateDescriptor() {
        return null;
    }

    public abstract char getMnemonic();

    public PsiMethod createSetUpPatternMethod(JVMElementFactory factory) {
        FileTemplate template = FileTemplateManager.getDefaultInstance().getCodeTemplate(this.getSetUpMethodFileTemplateDescriptor().getFileName());
        String templateText = StringUtil.replace((String)StringUtil.replace((String)template.getText(), (String)"${BODY}\n", (String)""), (String)"${NAME}", (String)"setUp");
        return factory.createMethodFromText(templateText, null);
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return null;
    }

    public Promise<Void> setupLibrary(Module module) {
        ExternalLibraryDescriptor descriptor2 = this.getFrameworkLibraryDescriptor();
        if (descriptor2 != null) {
            return JavaProjectModelModificationService.getInstance(module.getProject()).addDependency(module, descriptor2, DependencyScope.TEST);
        }
        String path = this.getLibraryPath();
        if (path != null) {
            OrderEntryFix.addJarsToRoots(Collections.singletonList(path), null, module, null);
            return Promise.resolve(null);
        }
        return Promises.rejectedPromise();
    }

    public boolean isSingleConfig() {
        return false;
    }

    public boolean isSuiteClass(PsiClass psiClass) {
        return false;
    }

    public boolean isTestMethod(PsiMethod method, PsiClass myClass) {
        return this.isTestMethod((PsiElement)method);
    }

    public boolean acceptNestedClasses() {
        return false;
    }

    public boolean isTestMethod(PsiElement element) {
        return this.isTestMethod(element, true);
    }

    public boolean isMyConfigurationType(ConfigurationType type2) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testIntegration/JavaTestFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testIntegration/JavaTestFramework";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryAttached";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTestClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPotentialTestClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSetUpMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTearDownMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateSetUpMethod";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

