/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestIntegrationUtils {
    private static final Logger LOG = Logger.getInstance(TestIntegrationUtils.class);

    public static boolean isTest(@NotNull PsiElement element) {
        PsiClass klass;
        if (element == null) {
            TestIntegrationUtils.$$$reportNull$$$0(0);
        }
        return (klass = TestIntegrationUtils.findOuterClass(element)) != null && TestFrameworks.getInstance().isTestClass(klass);
    }

    @Nullable
    public static PsiClass findOuterClass(@NotNull PsiElement element) {
        PsiClass[] classes2;
        PsiFile containingFile;
        PsiClass result;
        if (element == null) {
            TestIntegrationUtils.$$$reportNull$$$0(1);
        }
        if ((result = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false)) == null && (containingFile = element.getContainingFile()) instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)containingFile).getClasses()).length == 1) {
            result = classes2[0];
        }
        if (result == null) {
            return null;
        }
        PsiClass nextParent;
        while ((nextParent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)result, PsiClass.class, (boolean)true)) != null) {
            result = nextParent;
        }
        return result;
    }

    public static List<MemberInfo> extractClassMethods(PsiClass clazz, boolean includeInherited) {
        Set<PsiClass> classes2;
        ArrayList<MemberInfo> result = new ArrayList<MemberInfo>();
        if (includeInherited) {
            LinkedHashSet classes22 = InheritanceUtil.getSuperClasses((PsiClass)clazz);
            classes22.add(clazz);
        } else {
            classes2 = Collections.singleton(clazz);
        }
        for (PsiClass psiClass : classes2) {
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) continue;
            MemberInfo.extractClassMembers(psiClass, result, new MemberInfoBase.Filter<PsiMember>(){

                public boolean includeMember(PsiMember member) {
                    if (!(member instanceof PsiMethod)) {
                        return false;
                    }
                    return !member.hasModifierProperty("private") && !member.hasModifierProperty("abstract");
                }
            }, false);
        }
        return result;
    }

    public static void runTestMethodTemplate(@NotNull MethodKind methodKind, TestFramework framework, Editor editor, PsiClass targetClass, PsiMethod method, @Nullable String name2, boolean automatic, Set<? super String> existingNames) {
        if (methodKind == null) {
            TestIntegrationUtils.$$$reportNull$$$0(2);
        }
        TestIntegrationUtils.runTestMethodTemplate(methodKind, framework, editor, targetClass, null, method, name2, automatic, existingNames);
    }

    public static void runTestMethodTemplate(@NotNull MethodKind methodKind, TestFramework framework, Editor editor, PsiClass targetClass, @Nullable PsiClass sourceClass, PsiMethod method, @Nullable String name2, boolean automatic, Set<? super String> existingNames) {
        if (methodKind == null) {
            TestIntegrationUtils.$$$reportNull$$$0(3);
        }
        TestIntegrationUtils.runTestMethodTemplate(editor, targetClass, method, automatic, TestIntegrationUtils.createTestMethodTemplate(methodKind, framework, targetClass, sourceClass, name2, automatic, existingNames));
    }

    public static void runTestMethodTemplate(final Editor editor, PsiClass targetClass, PsiMethod method, boolean automatic, Template template) {
        int startOffset = method.getModifierList().getTextRange().getStartOffset();
        TextRange range = new TextRange(startOffset, method.getTextRange().getEndOffset());
        editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        final Project project = targetClass.getProject();
        TemplateEditingAdapter adapter = null;
        if (!automatic) {
            adapter = new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        PsiMethod method1;
                        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                        PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                        PsiElement el = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psi, (int)(editor.getCaretModel().getOffset() - 1), PsiMethod.class, (boolean)false);
                        if (el != null && (method1 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)el, PsiMethod.class, (boolean)false)) != null) {
                            if (method1.findDeepestSuperMethods().length > 0) {
                                GenerateMembersUtil.setupGeneratedMethod(method1);
                            }
                            CreateFromUsageUtils.setupEditor(method1, editor);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/testIntegration/TestIntegrationUtils$2", "templateFinished"));
                }
            };
        }
        TemplateManager.getInstance((Project)project).startTemplate(editor, template, (TemplateEditingListener)adapter);
    }

    public static Template createTestMethodTemplate(@NotNull MethodKind methodKind, TestFramework descriptor2, @NotNull PsiClass targetClass, @Nullable String name2, boolean automatic, Set<? super String> existingNames) {
        if (methodKind == null) {
            TestIntegrationUtils.$$$reportNull$$$0(4);
        }
        if (targetClass == null) {
            TestIntegrationUtils.$$$reportNull$$$0(5);
        }
        return TestIntegrationUtils.createTestMethodTemplate(methodKind, descriptor2, targetClass, null, name2, automatic, existingNames);
    }

    public static Template createTestMethodTemplate(@NotNull MethodKind methodKind, TestFramework descriptor2, @NotNull PsiClass targetClass, @Nullable PsiClass sourceClass, @Nullable String name2, boolean automatic, Set<? super String> existingNames) {
        int index;
        String templateText;
        if (methodKind == null) {
            TestIntegrationUtils.$$$reportNull$$$0(6);
        }
        if (targetClass == null) {
            TestIntegrationUtils.$$$reportNull$$$0(7);
        }
        FileTemplateDescriptor templateDesc = methodKind.getFileTemplateDescriptor(descriptor2);
        String templateName = templateDesc.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)targetClass.getProject()).getCodeTemplate(templateName);
        Template template = TemplateManager.getInstance((Project)targetClass.getProject()).createTemplate("", "");
        try {
            Properties properties = new Properties();
            if (sourceClass != null && sourceClass.isValid()) {
                properties.setProperty("CLASS_NAME", sourceClass.getQualifiedName());
            }
            templateText = fileTemplate.getText(properties);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            templateText = fileTemplate.getText();
        }
        if (name2 == null) {
            name2 = methodKind.getDefaultName();
        }
        if (existingNames != null && !existingNames.add(name2)) {
            int idx = 1;
            while (existingNames.contains(name2)) {
                String newName = name2 + idx++;
                if (!existingNames.add(newName)) continue;
                name2 = newName;
                break;
            }
        }
        templateText = StringUtil.replace((String)templateText, (String)"${BODY}\n", (String)"");
        int from = 0;
        while ((index = templateText.indexOf("${NAME}", from)) != -1) {
            template.addTextSegment(templateText.substring(from, index));
            name2 = index > 0 && !Character.isWhitespace(templateText.charAt(index - 1)) ? StringUtil.capitalize((String)name2) : StringUtil.decapitalize((String)name2);
            if (from == 0) {
                ConstantNode nameExpr = new ConstantNode(name2);
                template.addVariable("name", (Expression)nameExpr, (Expression)nameExpr, !automatic);
            } else {
                template.addVariableSegment("name");
            }
            from = index + "${NAME}".length();
        }
        template.addTextSegment(templateText.substring(from));
        template.setToIndent(true);
        template.setToReformat(true);
        template.setToShortenLongNames(true);
        return template;
    }

    public static PsiMethod createDummyMethod(@NotNull PsiElement context) {
        JVMElementFactory factory;
        if (context == null) {
            TestIntegrationUtils.$$$reportNull$$$0(8);
        }
        if ((factory = JVMElementFactories.getFactory((Language)context.getLanguage(), (Project)context.getProject())) == null) {
            factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        }
        return factory.createMethod("dummy", (PsiType)PsiType.VOID);
    }

    public static List<TestFramework> findSuitableFrameworks(PsiClass targetClass) {
        List frameworks = TestFramework.EXTENSION_NAME.getExtensionList();
        Project project = targetClass.getProject();
        SmartList result = new SmartList();
        for (TestFramework framework : frameworks) {
            if (!TestIntegrationUtils.isAvailableFor(project, framework)) continue;
            if (framework.isTestClass((PsiElement)targetClass)) {
                return Collections.singletonList(framework);
            }
            if (!framework.isPotentialTestClass((PsiElement)targetClass)) continue;
            result.add(framework);
        }
        return result;
    }

    private static boolean isAvailableFor(@NotNull Project project, @NotNull TestFramework framework) {
        if (project == null) {
            TestIntegrationUtils.$$$reportNull$$$0(9);
        }
        if (framework == null) {
            TestIntegrationUtils.$$$reportNull$$$0(10);
        }
        if (framework instanceof JavaTestFramework) {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            String markerClassFQName = ((JavaTestFramework)framework).getMarkerClassFQName();
            PsiClass c = JavaPsiFacade.getInstance((Project)project).findClass(markerClassFQName, scope);
            return c != null;
        }
        return true;
    }

    private TestIntegrationUtils() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodKind";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testIntegration/TestIntegrationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findOuterClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runTestMethodTemplate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestMethodTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createDummyMethod";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum MethodKind {
        SET_UP("setUp"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    1.$$$reportNull$$$0(0);
                }
                return framework.getSetUpMethodFileTemplateDescriptor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$1", "getFileTemplateDescriptor"));
            }
        }
        ,
        TEAR_DOWN("tearDown"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    2.$$$reportNull$$$0(0);
                }
                return framework.getTearDownMethodFileTemplateDescriptor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$2", "getFileTemplateDescriptor"));
            }
        }
        ,
        TEST("test"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    3.$$$reportNull$$$0(0);
                }
                return framework.getTestMethodFileTemplateDescriptor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$3", "getFileTemplateDescriptor"));
            }
        }
        ,
        DATA("data"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (framework instanceof JavaTestFramework) {
                    return ((JavaTestFramework)framework).getParametersMethodFileTemplateDescriptor();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$4", "getFileTemplateDescriptor"));
            }
        }
        ,
        TEST_CLASS("testClass"){

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework framework) {
                if (framework == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (framework instanceof JavaTestFramework) {
                    return ((JavaTestFramework)framework).getTestClassFileTemplateDescriptor();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/testIntegration/TestIntegrationUtils$MethodKind$5", "getFileTemplateDescriptor"));
            }
        };

        private final String myDefaultName;

        private MethodKind(String defaultName) {
            this.myDefaultName = defaultName;
        }

        public String getDefaultName() {
            return this.myDefaultName;
        }

        public abstract FileTemplateDescriptor getFileTemplateDescriptor(@NotNull TestFramework var1);
    }
}

