/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceAssignmentWithOperatorAssignmentInspection
extends BaseInspection {
    public boolean ignoreLazyOperators = true;
    public boolean ignoreObscureOperators = false;

    @NotNull
    public String getID() {
        if ("AssignmentReplaceableWithOperatorAssignment" == null) {
            ReplaceAssignmentWithOperatorAssignmentInspection.$$$reportNull$$$0(0);
        }
        return "AssignmentReplaceableWithOperatorAssignment";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.display.name", new Object[0]);
        if (string == null) {
            ReplaceAssignmentWithOperatorAssignmentInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression lhs = (PsiExpression)infos[0];
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)infos[1];
        String string = InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.problem.descriptor", ReplaceAssignmentWithOperatorAssignmentInspection.calculateReplacementExpression(lhs, polyadicExpression, new CommentTracker()));
        if (string == null) {
            ReplaceAssignmentWithOperatorAssignmentInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.ignore.conditional.operators.option", new Object[0]), "ignoreLazyOperators");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.ignore.obscure.operators.option", new Object[0]), "ignoreObscureOperators");
        return optionsPanel;
    }

    static String calculateReplacementExpression(PsiExpression lhs, PsiPolyadicExpression polyadicExpression, CommentTracker ct) {
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        PsiJavaToken sign = polyadicExpression.getTokenBeforeOperand(operands2[1]);
        String signText = sign.getText();
        if ("&&".equals(signText)) {
            signText = "&";
        } else if ("||".equals(signText)) {
            signText = "|";
        }
        StringBuilder text2 = new StringBuilder(ct.text((PsiElement)lhs));
        text2.append(' ');
        text2.append(signText);
        text2.append("= ");
        boolean addToken = false;
        for (int i = 1; i < operands2.length; ++i) {
            PsiExpression operand2 = operands2[i];
            if (addToken) {
                PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand2);
                text2.append(' ');
                if (token != null) {
                    text2.append(token.getText());
                }
                text2.append(' ');
            } else {
                addToken = true;
            }
            text2.append(ct.text((PsiElement)operand2));
        }
        return text2.toString();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceAssignmentWithOperatorAssignmentFix((PsiPolyadicExpression)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReplaceAssignmentWithOperatorAssignmentVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ReplaceAssignmentWithOperatorAssignmentVisitor
    extends BaseInspectionVisitor {
        private ReplaceAssignmentWithOperatorAssignmentVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                ReplaceAssignmentWithOperatorAssignmentVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(assignment);
            IElementType assignmentTokenType = assignment.getOperationTokenType();
            if (!assignmentTokenType.equals(JavaTokenType.EQ)) {
                return;
            }
            PsiExpression lhs = assignment.getLExpression();
            PsiExpression rhs = ParenthesesUtils.stripParentheses(assignment.getRExpression());
            if (rhs instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rhs;
                PsiType castType = typeCastExpression.getType();
                if (castType == null || !castType.equals(lhs.getType())) {
                    return;
                }
                rhs = ParenthesesUtils.stripParentheses(typeCastExpression.getOperand());
            }
            if (!(rhs instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)rhs;
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            if (operands2.length < 2) {
                return;
            }
            if (operands2.length > 2 && !ParenthesesUtils.isAssociativeOperation(polyadicExpression)) {
                return;
            }
            for (PsiExpression operand2 : operands2) {
                if (operand2 != null) continue;
                return;
            }
            IElementType expressionTokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.EQEQ.equals(expressionTokenType) || JavaTokenType.NE.equals(expressionTokenType)) {
                return;
            }
            if (ReplaceAssignmentWithOperatorAssignmentInspection.this.ignoreLazyOperators && (JavaTokenType.ANDAND.equals(expressionTokenType) || JavaTokenType.OROR.equals(expressionTokenType))) {
                return;
            }
            if (ReplaceAssignmentWithOperatorAssignmentInspection.this.ignoreObscureOperators && (JavaTokenType.XOR.equals(expressionTokenType) || JavaTokenType.PERC.equals(expressionTokenType))) {
                return;
            }
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(lhs, operands2[0])) {
                return;
            }
            this.registerError((PsiElement)assignment, lhs, polyadicExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentVisitor", "visitAssignmentExpression"));
        }
    }

    private static class ReplaceAssignmentWithOperatorAssignmentFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private ReplaceAssignmentWithOperatorAssignmentFix(PsiPolyadicExpression expression2) {
            PsiJavaToken sign = expression2.getTokenBeforeOperand(expression2.getOperands()[1]);
            String signText = sign.getText();
            if ("&&".equals(signText)) {
                signText = "&";
            } else if ("||".equals(signText)) {
                signText = "|";
            }
            this.m_name = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"=", signText + "="});
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor2.getPsiElement()) instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression expression2 = (PsiAssignmentExpression)element;
            PsiExpression lhs = expression2.getLExpression();
            PsiExpression rhs = ParenthesesUtils.stripParentheses(expression2.getRExpression());
            if (rhs instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rhs;
                PsiType castType = typeCastExpression.getType();
                if (castType == null || !castType.equals(lhs.getType())) {
                    return;
                }
                rhs = ParenthesesUtils.stripParentheses(typeCastExpression.getOperand());
            }
            if (!(rhs instanceof PsiPolyadicExpression)) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)rhs;
            String newExpression = ReplaceAssignmentWithOperatorAssignmentInspection.calculateReplacementExpression(lhs, polyadicExpression, ct);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression, ct);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

