/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MathRandomCastToIntInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("math.random.cast.to.int.display.name", new Object[0]);
        if (string == null) {
            MathRandomCastToIntInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[1];
        String string = InspectionGadgetsBundle.message("math.random.cast.to.int.problem.descriptor", type2.getPresentableText());
        if (string == null) {
            MathRandomCastToIntInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiTypeCastExpression expression2 = (PsiTypeCastExpression)infos[0];
        PsiElement parent = expression2.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (JavaTokenType.ASTERISK != tokenType || polyadicExpression.getType() == null) {
            return null;
        }
        return new MathRandomCastToIntegerFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MathRandomCastToIntegerVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/MathRandomCastToIntInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MathRandomCastToIntegerVisitor
    extends BaseInspectionVisitor {
        private MathRandomCastToIntegerVisitor() {
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            PsiExpression operand2 = expression2.getOperand();
            while (operand2 instanceof PsiPrefixExpression) {
                operand2 = ((PsiPrefixExpression)operand2).getOperand();
            }
            if (!(operand2 instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiTypeElement castType = expression2.getCastType();
            if (castType == null) {
                return;
            }
            PsiType type2 = castType.getType();
            if (!(type2 instanceof PsiPrimitiveType) || PsiType.DOUBLE.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.BOOLEAN.equals((Object)type2)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"random".equals(referenceName)) {
                return;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.lang.Math".equals(qualifiedName) && !"java.lang.StrictMath".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)methodCallExpression, expression2, type2);
        }
    }

    private static class MathRandomCastToIntegerFix
    extends InspectionGadgetsFix {
        private MathRandomCastToIntegerFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("math.random.cast.to.int.quickfix", new Object[0]);
            if (string == null) {
                MathRandomCastToIntegerFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiExpression[] operands2;
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            while (parent instanceof PsiPrefixExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiElement grandParent = typeCastExpression.getParent();
            if (!(grandParent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)grandParent;
            PsiExpression operand2 = typeCastExpression.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType type2 = polyadicExpression.getType();
            if (type2 == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            CommentTracker commentTracker = new CommentTracker();
            newExpression.append("(").append(type2.getCanonicalText()).append(")(");
            for (PsiExpression expression2 : operands2 = polyadicExpression.getOperands()) {
                PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(expression2);
                if (token != null) {
                    newExpression.append(token.getText());
                }
                if (typeCastExpression.equals(expression2)) {
                    newExpression.append(commentTracker.text((PsiElement)operand2));
                    continue;
                }
                newExpression.append(commentTracker.text((PsiElement)expression2));
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MathRandomCastToIntInspection$MathRandomCastToIntegerFix", "getFamilyName"));
        }
    }
}

