/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtectedMemberInFinalClassInspection
extends BaseInspection {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RemoveModifierFix((String)infos[0]), new MakePrivateFix()};
        if (inspectionGadgetsFixArray == null) {
            ProtectedMemberInFinalClassInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("protected.member.in.final.class.display.name", new Object[0]);
        if (string == null) {
            ProtectedMemberInFinalClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("protected.member.in.final.class.problem.descriptor", new Object[0]);
        if (string == null) {
            ProtectedMemberInFinalClassInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedMemberInFinalClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ProtectedMemberInFinalClassVisitor
    extends BaseInspectionVisitor {
        private ProtectedMemberInFinalClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ProtectedMemberInFinalClassVisitor.$$$reportNull$$$0(0);
            }
            if (!method.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            this.registerModifierError("protected", (PsiModifierListOwner)method, "protected");
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                ProtectedMemberInFinalClassVisitor.$$$reportNull$$$0(1);
            }
            if (!field.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            this.registerModifierError("protected", (PsiModifierListOwner)field, "protected");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspection$ProtectedMemberInFinalClassVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MakePrivateFix
    extends InspectionGadgetsFix {
        private MakePrivateFix() {
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                MakePrivateFix.$$$reportNull$$$0(0);
            }
            return currentFile;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("make.private.quickfix", new Object[0]);
            if (string == null) {
                MakePrivateFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            boolean conflictsDialogOK;
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMember)) {
                return;
            }
            PsiMember member = (PsiMember)grandParent;
            PsiModifierList modifierList = member.getModifierList();
            if (modifierList == null) {
                return;
            }
            MultiMap conflicts = new MultiMap();
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                SuperMethodsSearch.search((PsiMethod)method, (PsiClass)method.getContainingClass(), (boolean)true, (boolean)false).forEach(methodSignature -> {
                    PsiMethod superMethod = methodSignature.getMethod();
                    conflicts.putValue((Object)superMethod, (Object)InspectionGadgetsBundle.message("0.will.have.incompatible.access.privileges.with.super.1", RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)superMethod, (boolean)true)));
                    return true;
                });
                OverridingMethodsSearch.search((PsiMethod)method).forEach(overridingMethod -> {
                    conflicts.putValue(overridingMethod, (Object)InspectionGadgetsBundle.message("0.will.no.longer.be.visible.from.overriding.1", RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, (boolean)true)));
                    return false;
                });
            }
            PsiModifierList modifierListCopy = (PsiModifierList)modifierList.copy();
            modifierListCopy.setModifierProperty("private", true);
            Query search = ReferencesSearch.search((PsiElement)member, (SearchScope)member.getResolveScope());
            search.forEach(reference -> {
                PsiElement element1 = reference.getElement();
                if (!JavaResolveUtil.isAccessible(member, member.getContainingClass(), modifierListCopy, element1, null, null)) {
                    PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element1, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClass.class, PsiFile.class});
                    assert (context != null);
                    conflicts.putValue((Object)element1, (Object)RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), PsiBundle.visibilityPresentation((String)"private"), RefactoringUIUtil.getDescription((PsiElement)context, (boolean)true)}));
                }
                return true;
            });
            if (conflicts.isEmpty()) {
                conflictsDialogOK = true;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                ConflictsDialog conflictsDialog = new ConflictsDialog(member.getProject(), conflicts, () -> WriteAction.run(() -> modifierList.setModifierProperty("private", true)));
                conflictsDialogOK = conflictsDialog.showAndGet();
            }
            if (conflictsDialogOK) {
                WriteAction.run(() -> modifierList.setModifierProperty("private", true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspection$MakePrivateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/classlayout/ProtectedMemberInFinalClassInspection$MakePrivateFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

