/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BooleanExpressionMayBeConditionalInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.expression.may.be.conditional.display.name", new Object[0]);
        if (string == null) {
            BooleanExpressionMayBeConditionalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.may.be.conditional.problem.descriptor", new Object[0]);
        if (string == null) {
            BooleanExpressionMayBeConditionalInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new BooleanExpressionMayBeConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanExpressionMayBeConditionalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class BooleanExpressionMayBeConditionalVisitor
    extends BaseInspectionVisitor {
        private BooleanExpressionMayBeConditionalVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            PsiExpression expression22;
            super.visitBinaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.OROR.equals(tokenType)) {
                return;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(expression2.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(expression2.getROperand());
            if (!(lhs instanceof PsiBinaryExpression) || !(rhs instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression lBinaryExpression = (PsiBinaryExpression)lhs;
            PsiBinaryExpression rBinaryExpression = (PsiBinaryExpression)rhs;
            IElementType lTokenType = lBinaryExpression.getOperationTokenType();
            IElementType rTokenType = rBinaryExpression.getOperationTokenType();
            if (!JavaTokenType.ANDAND.equals(lTokenType) || !JavaTokenType.ANDAND.equals(rTokenType)) {
                return;
            }
            PsiExpression expression1 = ParenthesesUtils.stripParentheses(lBinaryExpression.getLOperand());
            if (BoolUtils.areExpressionsOpposite(expression1, expression22 = ParenthesesUtils.stripParentheses(rBinaryExpression.getLOperand())) && !SideEffectChecker.mayHaveSideEffects(expression1)) {
                this.registerError((PsiElement)expression2, new Object[0]);
            }
        }
    }

    private static class BooleanExpressionMayBeConditionalFix
    extends InspectionGadgetsFix {
        private BooleanExpressionMayBeConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("if.may.be.conditional.quickfix", new Object[0]);
            if (string == null) {
                BooleanExpressionMayBeConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            if (!(lhs instanceof PsiBinaryExpression) || !(rhs instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression lBinaryExpression = (PsiBinaryExpression)lhs;
            PsiBinaryExpression rBinaryExpression = (PsiBinaryExpression)rhs;
            PsiExpression llhs = ParenthesesUtils.stripParentheses(lBinaryExpression.getLOperand());
            PsiExpression lrhs = ParenthesesUtils.stripParentheses(rBinaryExpression.getLOperand());
            if (llhs == null || lrhs == null) {
                return;
            }
            PsiExpression thenExpression2 = ParenthesesUtils.stripParentheses(lBinaryExpression.getROperand());
            PsiExpression elseExpression2 = ParenthesesUtils.stripParentheses(rBinaryExpression.getROperand());
            if (thenExpression2 == null || elseExpression2 == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            if (BoolUtils.isNegation(llhs)) {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, BooleanExpressionMayBeConditionalFix.getText(lrhs, commentTracker) + '?' + BooleanExpressionMayBeConditionalFix.getText(elseExpression2, commentTracker) + ':' + BooleanExpressionMayBeConditionalFix.getText(thenExpression2, commentTracker), commentTracker);
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, BooleanExpressionMayBeConditionalFix.getText(llhs, commentTracker) + '?' + BooleanExpressionMayBeConditionalFix.getText(thenExpression2, commentTracker) + ':' + BooleanExpressionMayBeConditionalFix.getText(elseExpression2, commentTracker), commentTracker);
            }
        }

        private static String getText(@NotNull PsiExpression expression2, CommentTracker commentTracker) {
            if (expression2 == null) {
                BooleanExpressionMayBeConditionalFix.$$$reportNull$$$0(1);
            }
            return ParenthesesUtils.getText(commentTracker.markUnchanged(expression2), 15);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection$BooleanExpressionMayBeConditionalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection$BooleanExpressionMayBeConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

