/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ConstantConditionalExpressionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiConditionalExpression expression2 = (PsiConditionalExpression)infos[0];
        String string = InspectionGadgetsBundle.message("constant.conditional.expression.problem.descriptor", ConstantConditionalExpressionInspection.calculateReplacementExpression(expression2).getText());
        if (string == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    static PsiExpression calculateReplacementExpression(@NotNull PsiConditionalExpression exp) {
        if (exp == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(2);
        }
        PsiExpression thenExpression2 = exp.getThenExpression();
        PsiExpression elseExpression2 = exp.getElseExpression();
        PsiExpression condition2 = exp.getCondition();
        assert (thenExpression2 != null);
        assert (elseExpression2 != null);
        PsiExpression psiExpression = BoolUtils.isTrue(condition2) ? thenExpression2 : elseExpression2;
        if (psiExpression == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(3);
        }
        return psiExpression;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConstantConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateReplacementExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateReplacementExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression condition2 = expression2.getCondition();
            PsiExpression thenExpression2 = expression2.getThenExpression();
            if (thenExpression2 == null) {
                return;
            }
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (elseExpression2 == null) {
                return;
            }
            if (BoolUtils.isFalse(condition2) || BoolUtils.isTrue(condition2)) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }
    }

    private static class ConstantConditionalFix
    extends InspectionGadgetsFix {
        private ConstantConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                ConstantConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor2.getPsiElement();
            CommentTracker ct = new CommentTracker();
            PsiExpression replacement = ConstantConditionalExpressionInspection.calculateReplacementExpression(expression2);
            PsiType type2 = replacement.getType();
            PsiType expressionType = expression2.getType();
            if (type2 != null && expressionType != null && !type2.equals(expressionType) && PsiTypesUtil.isDenotableType((PsiType)expressionType, (PsiElement)expression2)) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)ct.replaceAndRestoreComments((PsiElement)expression2, "(" + expressionType.getCanonicalText() + ")" + ct.text((PsiElement)replacement));
                if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)castExpression)) {
                    RemoveRedundantCastUtil.removeCast(castExpression);
                }
            } else {
                ct.replaceAndRestoreComments((PsiElement)expression2, (PsiElement)replacement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection$ConstantConditionalFix", "getFamilyName"));
        }
    }
}

