/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import javax.swing.JComponent;
import one.util.streamex.Joining;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumSwitchStatementWhichMissesCasesInspection
extends BaseInspection {
    public boolean ignoreSwitchStatementsWithDefault = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.display.name", new Object[0]);
        if (string == null) {
            EnumSwitchStatementWhichMissesCasesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String enumName = (String)infos[0];
        Set names = (Set)infos[1];
        if (names.size() == 1) {
            String string = InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.problem.descriptor.single", enumName, names.iterator().next());
            if (string == null) {
                EnumSwitchStatementWhichMissesCasesInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String namesString = EnumSwitchStatementWhichMissesCasesInspection.formatMissingBranches(names);
        String string = InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.problem.descriptor", enumName, namesString);
        if (string == null) {
            EnumSwitchStatementWhichMissesCasesInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    static String formatMissingBranches(Set<String> names) {
        return (String)StreamEx.of(names).map(name2 -> "'" + name2 + "'").mapLast("and "::concat).collect((Collector)Joining.with((CharSequence)", ").maxChars(50).cutAfterDelimiter());
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSwitchStatementsWithDefault");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EnumSwitchStatementWhichMissesCasesVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Set names = (Set)infos[1];
        return new CreateMissingSwitchBranchesFix(names);
    }

    private static PsiEnumConstant findEnumConstant(PsiElement element) {
        if (!(element instanceof PsiSwitchLabelStatement)) {
            return null;
        }
        PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)element;
        PsiExpression value2 = switchLabelStatement.getCaseValue();
        if (!(value2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value2;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiEnumConstant)) {
            return null;
        }
        return (PsiEnumConstant)target;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CreateMissingSwitchBranchesFix
    extends InspectionGadgetsFix {
        private final Set<String> myNames;

        private CreateMissingSwitchBranchesFix(Set<String> names) {
            this.myNames = names;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            if (this.myNames.size() == 1) {
                String string = "Create missing switch branch '" + this.myNames.iterator().next() + "'";
                if (string == null) {
                    CreateMissingSwitchBranchesFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = "Create missing branches: " + EnumSwitchStatementWhichMissesCasesInspection.formatMissingBranches(this.myNames);
            if (string == null) {
                CreateMissingSwitchBranchesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            if ("Create enum switch branches" == null) {
                CreateMissingSwitchBranchesFix.$$$reportNull$$$0(2);
            }
            return "Create enum switch branches";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)descriptor2.getStartElement(), (Class[])new Class[]{PsiSwitchStatement.class});
            if (switchStatement == null) {
                return;
            }
            PsiCodeBlock body2 = switchStatement.getBody();
            PsiExpression switchExpression = switchStatement.getExpression();
            if (switchExpression == null) {
                return;
            }
            PsiClassType switchType = (PsiClassType)switchExpression.getType();
            if (switchType == null) {
                return;
            }
            PsiClass enumClass = switchType.resolve();
            if (enumClass == null) {
                return;
            }
            if (body2 == null) {
                StringBuilder newStatementText = new StringBuilder();
                CommentTracker commentTracker = new CommentTracker();
                newStatementText.append("switch(").append(commentTracker.text((PsiElement)switchExpression)).append("){");
                for (String missingName : this.myNames) {
                    newStatementText.append("case ").append(missingName).append(": break;");
                }
                newStatementText.append('}');
                PsiReplacementUtil.replaceStatement((PsiStatement)switchStatement, newStatementText.toString(), commentTracker);
                return;
            }
            List allEnumConstants = StreamEx.of((Object[])enumClass.getAllFields()).select(PsiEnumConstant.class).toList();
            Map nextEnumConstants = StreamEx.of((Collection)allEnumConstants).pairMap(Couple::of).toMap(c -> (PsiEnumConstant)c.getFirst(), c -> (PsiEnumConstant)c.getSecond());
            List missingEnumElements = ((StreamEx)StreamEx.of((Collection)allEnumConstants).filter(c -> this.myNames.contains(c.getName()))).toList();
            PsiEnumConstant nextEnumConstant = CreateMissingSwitchBranchesFix.getNextEnumConstant(nextEnumConstants, missingEnumElements);
            for (PsiElement bodyElement = body2.getFirstBodyElement(); bodyElement != null; bodyElement = bodyElement.getNextSibling()) {
                while (nextEnumConstant != null && EnumSwitchStatementWhichMissesCasesInspection.findEnumConstant(bodyElement) == nextEnumConstant) {
                    CreateMissingSwitchBranchesFix.addSwitchLabelStatementBefore((PsiEnumConstant)missingEnumElements.get(0), bodyElement);
                    missingEnumElements.remove(0);
                    if (missingEnumElements.isEmpty()) break;
                    nextEnumConstant = CreateMissingSwitchBranchesFix.getNextEnumConstant(nextEnumConstants, missingEnumElements);
                }
                if (!CreateMissingSwitchBranchesFix.isDefaultSwitchLabelStatement(bodyElement)) continue;
                for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                    CreateMissingSwitchBranchesFix.addSwitchLabelStatementBefore(missingEnumElement, bodyElement);
                }
                missingEnumElements.clear();
                break;
            }
            if (!missingEnumElements.isEmpty()) {
                PsiElement lastChild = body2.getLastChild();
                for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                    CreateMissingSwitchBranchesFix.addSwitchLabelStatementBefore(missingEnumElement, lastChild);
                }
            }
        }

        private static void addSwitchLabelStatementBefore(PsiEnumConstant missingEnumElement, PsiElement anchor) {
            if (anchor instanceof PsiSwitchLabelStatement) {
                PsiElement sibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
                while (sibling instanceof PsiSwitchLabelStatement) {
                    anchor = sibling;
                    sibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
                }
            }
            PsiElement parent = anchor.getParent();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
            PsiStatement caseStatement = factory.createStatementFromText("case " + missingEnumElement.getName() + ":", anchor);
            parent.addBefore((PsiElement)caseStatement, anchor);
            PsiStatement breakStatement = factory.createStatementFromText("break;", anchor);
            parent.addBefore((PsiElement)breakStatement, anchor);
        }

        private static PsiEnumConstant getNextEnumConstant(Map<PsiEnumConstant, PsiEnumConstant> nextEnumConstants, List<PsiEnumConstant> missingEnumElements) {
            PsiEnumConstant nextEnumConstant = nextEnumConstants.get(missingEnumElements.get(0));
            while (missingEnumElements.contains(nextEnumConstant)) {
                nextEnumConstant = nextEnumConstants.get(nextEnumConstant);
            }
            return nextEnumConstant;
        }

        private static boolean isDefaultSwitchLabelStatement(PsiElement element) {
            return element instanceof PsiSwitchLabelStatement && ((PsiSwitchLabelStatement)element).isDefaultCase();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection$CreateMissingSwitchBranchesFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class EnumSwitchStatementWhichMissesCasesVisitor
    extends BaseInspectionVisitor {
        private EnumSwitchStatementWhichMissesCasesVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                EnumSwitchStatementWhichMissesCasesVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(statement);
            PsiExpression expression2 = statement.getExpression();
            if (expression2 == null) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            if (aClass == null || !aClass.isEnum()) {
                return;
            }
            Set constants = (Set)StreamEx.of((Object[])aClass.getAllFields()).select(PsiEnumConstant.class).map(PsiNamedElement::getName).toCollection(LinkedHashSet::new);
            if (constants.isEmpty()) {
                return;
            }
            ProblemHighlightType highlighting = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            for (PsiSwitchLabelStatement child : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement.getBody(), PsiSwitchLabelStatement.class)) {
                if (child.isDefaultCase()) {
                    if (!EnumSwitchStatementWhichMissesCasesInspection.this.ignoreSwitchStatementsWithDefault) continue;
                    if (!this.isOnTheFly()) {
                        return;
                    }
                    highlighting = ProblemHighlightType.INFORMATION;
                    continue;
                }
                PsiEnumConstant enumConstant = EnumSwitchStatementWhichMissesCasesInspection.findEnumConstant((PsiElement)child);
                if (enumConstant == null || enumConstant.getContainingClass() != aClass) {
                    return;
                }
                constants.remove(enumConstant.getName());
            }
            if (constants.isEmpty()) {
                return;
            }
            CommonDataflow.DataflowResult dataflow = CommonDataflow.getDataflowResult(expression2);
            if (dataflow != null) {
                Set<Object> values = dataflow.getValuesNotEqualToExpression(expression2);
                for (Object e : values) {
                    if (!(e instanceof PsiEnumConstant)) continue;
                    constants.remove(((PsiEnumConstant)e).getName());
                }
            }
            if (constants.isEmpty()) {
                return;
            }
            Object[] infos = new Object[]{aClass.getQualifiedName(), constants};
            if (highlighting == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)EnumSwitchStatementWhichMissesCasesInspection.this.getShortName(), (PsiElement)statement)) {
                this.registerError((PsiElement)statement, ProblemHighlightType.INFORMATION, infos);
            } else {
                int length = statement.getFirstChild().getTextLength();
                this.registerErrorAtOffset((PsiElement)statement, 0, length, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, infos);
                if (this.isOnTheFly()) {
                    this.registerErrorAtOffset((PsiElement)statement, length, statement.getTextLength() - length, ProblemHighlightType.INFORMATION, infos);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection$EnumSwitchStatementWhichMissesCasesVisitor", "visitSwitchStatement"));
        }
    }
}

