/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NegatedIfElseInspection
extends BaseInspection {
    public boolean m_ignoreNegatedNullComparison = true;
    public boolean m_ignoreNegatedZeroComparison = false;

    @NotNull
    public String getID() {
        if ("IfStatementWithNegatedCondition" == null) {
            NegatedIfElseInspection.$$$reportNull$$$0(0);
        }
        return "IfStatementWithNegatedCondition";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negated.if.else.display.name", new Object[0]);
        if (string == null) {
            NegatedIfElseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.if.else.problem.descriptor", new Object[0]);
        if (string == null) {
            NegatedIfElseInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedIfElseVisitor();
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("negated.if.else.ignore.negated.null.option", new Object[0]), "m_ignoreNegatedNullComparison");
        panel.addCheckbox(InspectionGadgetsBundle.message("negated.if.else.ignore.negated.zero.option", new Object[0]), "m_ignoreNegatedZeroComparison");
        return panel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedIfElseFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/NegatedIfElseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NegatedIfElseVisitor
    extends BaseInspectionVisitor {
        private NegatedIfElseVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                NegatedIfElseVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (elseBranch instanceof PsiIfStatement) {
                return;
            }
            PsiExpression condition2 = statement.getCondition();
            if (condition2 == null) {
                return;
            }
            if (!ExpressionUtils.isNegation(condition2, NegatedIfElseInspection.this.m_ignoreNegatedNullComparison, NegatedIfElseInspection.this.m_ignoreNegatedZeroComparison)) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/NegatedIfElseInspection$NegatedIfElseVisitor", "visitIfStatement"));
        }
    }

    private static class NegatedIfElseFix
    extends InspectionGadgetsFix {
        private NegatedIfElseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.if.else.invert.quickfix", new Object[0]);
            if (string == null) {
                NegatedIfElseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiComment comment;
            IElementType tokenType;
            PsiElement ifToken = descriptor2.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)ifToken.getParent();
            assert (ifStatement != null);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition2, tracker);
            String elseText = tracker.text((PsiElement)elseBranch);
            PsiElement lastChild = elseBranch.getLastChild();
            if (lastChild instanceof PsiComment && JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType = (comment = (PsiComment)lastChild).getTokenType())) {
                elseText = elseText + '\n';
            }
            String newStatement = "if(" + negatedCondition + ')' + elseText + " else " + tracker.text((PsiElement)thenBranch);
            PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, newStatement, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedIfElseInspection$NegatedIfElseFix", "getFamilyName"));
        }
    }
}

