/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        if ("RedundantConditionalExpression" == null) {
            UnnecessaryConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return "RedundantConditionalExpression";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacement = (String)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", replacement);
        if (string == null) {
            UnnecessaryConditionalExpressionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String replacement = (String)infos[0];
        return new UnnecessaryConditionalFix(replacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression2 = expression2.getThenExpression();
            if (thenExpression2 == null) {
                return;
            }
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (elseExpression2 == null) {
                return;
            }
            PsiExpression condition2 = ParenthesesUtils.stripParentheses(expression2.getCondition());
            if (condition2 == null) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (BoolUtils.isFalse(thenExpression2) && BoolUtils.isTrue(elseExpression2)) {
                this.registerError((PsiElement)expression2, BoolUtils.getNegatedExpressionText(condition2, new CommentTracker()));
            } else if (BoolUtils.isTrue(thenExpression2) && BoolUtils.isFalse(elseExpression2)) {
                if (!(parent instanceof PsiLambdaExpression) || LambdaUtil.isSafeLambdaBodyReplacement((PsiLambdaExpression)((PsiLambdaExpression)parent), () -> condition2)) {
                    this.registerError((PsiElement)expression2, condition2.getText());
                }
            } else if (this.isUnnecessary(condition2, thenExpression2, elseExpression2, JavaTokenType.EQEQ)) {
                this.registerError((PsiElement)expression2, elseExpression2.getText());
            } else if (this.isUnnecessary(condition2, elseExpression2, thenExpression2, JavaTokenType.NE)) {
                this.registerError((PsiElement)expression2, thenExpression2.getText());
            }
        }

        boolean isUnnecessary(PsiExpression condition2, PsiExpression thenExpression2, PsiExpression elseExpression2, IElementType expectedToken) {
            if (!(condition2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
            IElementType token = binaryExpression.getOperationTokenType();
            if (token != expectedToken) {
                return false;
            }
            EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            return equivalence.expressionsAreEquivalent(thenExpression2, lhs) && equivalence.expressionsAreEquivalent(elseExpression2, rhs) || equivalence.expressionsAreEquivalent(thenExpression2, rhs) && equivalence.expressionsAreEquivalent(elseExpression2, lhs);
        }
    }

    private static class UnnecessaryConditionalFix
    extends InspectionGadgetsFix {
        private final String myReplacement;

        UnnecessaryConditionalFix(String replacement) {
            this.myReplacement = replacement;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor2.getPsiElement();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, this.myReplacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection$UnnecessaryConditionalFix", "getFamilyName"));
        }
    }
}

