/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReuseOfLocalVariableInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReuseOfLocalVariableFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("reuse.of.local.variable.display.name", new Object[0]);
        if (string == null) {
            ReuseOfLocalVariableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("reuse.of.local.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            ReuseOfLocalVariableInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReuseOfLocalVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReuseOfLocalVariableVisitor
    extends BaseInspectionVisitor {
        private ReuseOfLocalVariableVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            int i;
            if (assignment == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(assignment);
            PsiElement assignmentParent = assignment.getParent();
            if (!(assignmentParent instanceof PsiExpressionStatement)) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiLocalVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)referent;
            if (variable.getInitializer() == null) {
                return;
            }
            IElementType tokenType = assignment.getOperationTokenType();
            if (!JavaTokenType.EQ.equals(tokenType)) {
                return;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs)) {
                return;
            }
            PsiCodeBlock variableBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (variableBlock == null) {
                return;
            }
            if (ReuseOfLocalVariableVisitor.loopExistsBetween(assignment, variableBlock)) {
                return;
            }
            if (ReuseOfLocalVariableVisitor.tryExistsBetween(assignment, variableBlock)) {
                return;
            }
            PsiElement assignmentBlock = assignmentParent.getParent();
            if (assignmentBlock == null) {
                return;
            }
            if (variableBlock.equals(assignmentBlock)) {
                this.registerError((PsiElement)lhs, new Object[0]);
            }
            PsiStatement[] statements = variableBlock.getStatements();
            PsiElement containingStatement = ReuseOfLocalVariableVisitor.getChildWhichContainsElement(variableBlock, (PsiElement)assignment);
            int statementPosition = -1;
            for (i = 0; i < statements.length; ++i) {
                if (!statements[i].equals(containingStatement)) continue;
                statementPosition = i;
                break;
            }
            if (statementPosition == -1) {
                return;
            }
            for (i = statementPosition + 1; i < statements.length; ++i) {
                if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)statements[i])) continue;
                return;
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }

        private static boolean loopExistsBetween(PsiAssignmentExpression assignment, PsiCodeBlock block) {
            for (PsiAssignmentExpression elementToTest = assignment; elementToTest != null; elementToTest = elementToTest.getParent()) {
                if (elementToTest.equals(block)) {
                    return false;
                }
                if (!(elementToTest instanceof PsiWhileStatement) && !(elementToTest instanceof PsiForeachStatement) && !(elementToTest instanceof PsiForStatement) && !(elementToTest instanceof PsiDoWhileStatement)) continue;
                return true;
            }
            return false;
        }

        private static boolean tryExistsBetween(PsiAssignmentExpression assignment, PsiCodeBlock block) {
            for (PsiAssignmentExpression elementToTest = assignment; elementToTest != null; elementToTest = elementToTest.getParent()) {
                if (elementToTest.equals(block)) {
                    return false;
                }
                if (!(elementToTest instanceof PsiTryStatement)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public static PsiElement getChildWhichContainsElement(@NotNull PsiCodeBlock ancestor, @NotNull PsiElement descendant) {
            if (ancestor == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(1);
            }
            if (descendant == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(2);
            }
            PsiElement element = descendant;
            while (!element.equals(ancestor)) {
                descendant = element;
                if ((element = descendant.getParent()) != null) continue;
                return null;
            }
            return descendant;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ancestor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descendant";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection$ReuseOfLocalVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getChildWhichContainsElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReuseOfLocalVariableFix
    extends InspectionGadgetsFix {
        private ReuseOfLocalVariableFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("reuse.of.local.variable.split.quickfix", new Object[0]);
            if (string == null) {
                ReuseOfLocalVariableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)descriptor2.getPsiElement();
            PsiLocalVariable variable = (PsiLocalVariable)referenceExpression.resolve();
            if (variable == null) {
                return;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiUtil.skipParenthesizedExprUp((PsiElement)referenceExpression.getParent());
            if (assignment == null) {
                return;
            }
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)assignment.getParent();
            PsiExpression lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
            if (lExpression == null) {
                return;
            }
            String originalVariableName = lExpression.getText();
            PsiType type2 = variable.getType();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            PsiCodeBlock variableBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            String newVariableName = codeStyleManager.suggestUniqueVariableName(originalVariableName, (PsiElement)variableBlock, false);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)assignmentStatement, PsiCodeBlock.class);
            Object scope = codeBlock != null ? new LocalSearchScope((PsiElement)codeBlock) : variable.getUseScope();
            Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)scope, (boolean)false);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            ArrayList<PsiReferenceExpression> collectedReferences = new ArrayList<PsiReferenceExpression>();
            for (PsiReference reference : query) {
                PsiElement referenceElement = reference.getElement();
                TextRange textRange = assignmentStatement.getTextRange();
                if (referenceElement.getTextOffset() <= textRange.getEndOffset()) continue;
                PsiExpression newExpression = factory.createExpressionFromText(newVariableName, referenceElement);
                PsiReferenceExpression replacementExpression = (PsiReferenceExpression)referenceElement.replace((PsiElement)newExpression);
                collectedReferences.add(replacementExpression);
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiExpression rhs = assignment.getRExpression();
            String rhsText = rhs == null ? "" : commentTracker.text((PsiElement)rhs);
            String newStatementText = type2.getCanonicalText() + ' ' + newVariableName + " =  " + rhsText + ';';
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)commentTracker.replaceAndRestoreComments((PsiElement)assignmentStatement, newStatementText);
            PsiElement[] elements = declarationStatement.getDeclaredElements();
            PsiLocalVariable newVariable = (PsiLocalVariable)elements[0];
            PsiElement context = declarationStatement.getParent();
            HighlightUtils.showRenameTemplate(context, (PsiNameIdentifierOwner)newVariable, (PsiReference[])collectedReferences.toArray(new PsiReferenceExpression[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection$ReuseOfLocalVariableFix", "getFamilyName"));
        }
    }
}

