/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddArgumentFix
extends InspectionGadgetsFix {
    private final String myExpressionText;
    private final String myPresentableText;

    public AddArgumentFix(String expressionText, String presentableText) {
        this.myExpressionText = expressionText;
        this.myPresentableText = presentableText;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiMethodCallExpression call;
        PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), PsiReferenceExpression.class);
        if (ref == null) {
            return;
        }
        if (ref instanceof PsiMethodReferenceExpression) {
            PsiLambdaExpression lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)ref, true, true);
            if (lambda2 == null) {
                return;
            }
            call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)lambda2.getBody(), PsiMethodCallExpression.class);
        } else {
            call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ref.getParent(), PsiMethodCallExpression.class);
        }
        if (call == null) {
            return;
        }
        PsiElement result = call.getArgumentList().add((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(this.myExpressionText, (PsiElement)call));
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("fix.add.argument.name", this.myPresentableText);
        if (string == null) {
            AddArgumentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("fix.add.argument.family.name", new Object[0]);
        if (string == null) {
            AddArgumentFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/AddArgumentFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

