/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class InlineGetterSetterCallFix
extends InspectionGadgetsFix {
    private final boolean myGetter;

    public InlineGetterSetterCallFix(boolean getter) {
        this.myGetter = getter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.myGetter ? InspectionGadgetsBundle.message("call.to.simple.getter.in.class.inline.quickfix", new Object[0]) : InspectionGadgetsBundle.message("call.to.simple.setter.in.class.inline.quickfix", new Object[0]);
        if (string == null) {
            InlineGetterSetterCallFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("inline.call.quickfix", new Object[0]);
        if (string == null) {
            InlineGetterSetterCallFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiField field;
        PsiElement nameElement = descriptor2.getPsiElement();
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)nameElement.getParent();
        if (methodExpression == null) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return;
        }
        PsiField psiField = field = this.myGetter ? PropertyUtil.getFieldOfGetter(method) : PropertyUtil.getFieldOfSetter(method);
        if (field == null) {
            return;
        }
        String name2 = field.getName();
        if (name2 == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        StringBuilder newText = new StringBuilder();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null) {
            newText.append(tracker.text((PsiElement)qualifier)).append('.');
        } else {
            PsiVariable variable = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedVariable(name2, (PsiElement)methodExpression);
            if (variable != field) {
                newText.append("this.");
            }
        }
        newText.append(name2);
        if (!this.myGetter) {
            newText.append("=").append(methodCallExpression.getArgumentList().getExpressions()[0].getText());
        }
        tracker.replaceAndRestoreComments((PsiElement)methodCallExpression, newText.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/InlineGetterSetterCallFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

