/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import org.jetbrains.annotations.NonNls;

public class MemberSignature
implements Comparable<MemberSignature> {
    @NonNls
    private static final String CONSTRUCTOR_NAME = "<init>";
    @NonNls
    private static final String INITIALIZER_SIGNATURE = "()V";
    @NonNls
    private static final MemberSignature ASSERTIONS_DISABLED_FIELD = new MemberSignature("$assertionsDisabled", 24, "Z");
    @NonNls
    private static final MemberSignature PACKAGE_PRIVATE_CONSTRUCTOR = new MemberSignature("<init>", 0, "()V");
    @NonNls
    private static final MemberSignature PUBLIC_CONSTRUCTOR = new MemberSignature("<init>", 1, "()V");
    @NonNls
    private static final MemberSignature STATIC_INITIALIZER = new MemberSignature("<clinit>", 8, "()V");
    private final int modifiers;
    private final String name;
    private final String signature;

    public MemberSignature(PsiField field) {
        this.modifiers = MemberSignature.calculateModifierBitmap(field.getModifierList());
        this.name = field.getName();
        this.signature = MemberSignature.createTypeSignature(field.getType());
    }

    public MemberSignature(PsiMethod method) {
        this.modifiers = MemberSignature.calculateModifierBitmap(method.getModifierList());
        this.signature = MemberSignature.createMethodSignature(method).replace('/', '.');
        this.name = method.isConstructor() ? CONSTRUCTOR_NAME : method.getName();
    }

    public MemberSignature(@NonNls String name2, int modifiers, @NonNls String signature) {
        this.name = name2;
        this.modifiers = modifiers;
        this.signature = signature;
    }

    public static int calculateModifierBitmap(PsiModifierList modifierList) {
        int modifiers = 0;
        if (modifierList.hasModifierProperty("public")) {
            modifiers |= 1;
        }
        if (modifierList.hasModifierProperty("private")) {
            modifiers |= 2;
        }
        if (modifierList.hasModifierProperty("protected")) {
            modifiers |= 4;
        }
        if (modifierList.hasModifierProperty("static")) {
            modifiers |= 8;
        }
        if (modifierList.hasModifierProperty("final")) {
            modifiers |= 0x10;
        }
        if (modifierList.hasModifierProperty("volatile")) {
            modifiers |= 0x40;
        }
        if (modifierList.hasModifierProperty("transient")) {
            modifiers |= 0x80;
        }
        if (modifierList.hasModifierProperty("abstract")) {
            modifiers |= 0x400;
        }
        if (modifierList.hasModifierProperty("synchronized")) {
            modifiers |= 0x20;
        }
        if (modifierList.hasModifierProperty("native")) {
            modifiers |= 0x100;
        }
        if (modifierList.hasModifierProperty("strictfp")) {
            modifiers |= 0x800;
        }
        return modifiers;
    }

    @Override
    public int compareTo(MemberSignature other) {
        int result = this.name.compareTo(other.name);
        if (result != 0) {
            return result;
        }
        return this.signature.compareTo(other.signature);
    }

    public static String createMethodSignature(PsiMethod method) {
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        StringBuilder signatureBuffer = new StringBuilder();
        signatureBuffer.append('(');
        for (PsiParameter parameter2 : parameters2) {
            PsiType type2 = parameter2.getType();
            signatureBuffer.append(MemberSignature.createTypeSignature(type2));
        }
        signatureBuffer.append(')');
        PsiType returnType = method.getReturnType();
        String returnTypeSignature = returnType == null ? MemberSignature.createTypeSignature((PsiType)PsiType.VOID) : MemberSignature.createTypeSignature(returnType);
        signatureBuffer.append(returnTypeSignature);
        return signatureBuffer.toString();
    }

    public static String createPrimitiveTypeSignature(PsiPrimitiveType primitiveType) {
        if (primitiveType.equals((Object)PsiType.INT)) {
            return "I";
        }
        if (primitiveType.equals((Object)PsiType.BYTE)) {
            return "B";
        }
        if (primitiveType.equals((Object)PsiType.LONG)) {
            return "J";
        }
        if (primitiveType.equals((Object)PsiType.FLOAT)) {
            return "F";
        }
        if (primitiveType.equals((Object)PsiType.DOUBLE)) {
            return "D";
        }
        if (primitiveType.equals((Object)PsiType.SHORT)) {
            return "S";
        }
        if (primitiveType.equals((Object)PsiType.CHAR)) {
            return "C";
        }
        if (primitiveType.equals((Object)PsiType.BOOLEAN)) {
            return "Z";
        }
        if (primitiveType.equals((Object)PsiType.VOID)) {
            return "V";
        }
        throw new InternalError();
    }

    public static String createTypeSignature(PsiType type2) {
        StringBuilder buffer = new StringBuilder();
        PsiType internalType = type2;
        while (internalType instanceof PsiArrayType) {
            buffer.append('[');
            PsiArrayType arrayType = (PsiArrayType)internalType;
            internalType = arrayType.getComponentType();
        }
        if (internalType instanceof PsiPrimitiveType) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)internalType;
            buffer.append(MemberSignature.createPrimitiveTypeSignature(primitiveType));
        } else {
            buffer.append('L');
            if (internalType instanceof PsiClassType) {
                PsiTypeParameter typeParameter;
                PsiReferenceList extendsList;
                PsiClassType[] types;
                PsiClassType classType = (PsiClassType)internalType;
                PsiClass psiClass = classType.resolve();
                if (psiClass instanceof PsiTypeParameter && (types = (extendsList = (typeParameter = (PsiTypeParameter)psiClass).getExtendsList()).getReferencedTypes()).length > 0) {
                    psiClass = types[0].resolve();
                }
                if (psiClass != null) {
                    StringBuilder postFix = new StringBuilder();
                    PsiClass containingClass = psiClass.getContainingClass();
                    while (containingClass != null) {
                        postFix.insert(0, psiClass.getName()).insert(0, '$');
                        psiClass = containingClass;
                        containingClass = psiClass.getContainingClass();
                    }
                    String qualifiedName = psiClass.getQualifiedName();
                    if (qualifiedName == null) {
                        buffer.append("java.lang.Object");
                    } else {
                        buffer.append(qualifiedName.replace('.', '/')).append((CharSequence)postFix);
                    }
                }
            } else {
                buffer.append(internalType.getCanonicalText().replace('.', '/'));
            }
            buffer.append(';');
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        try {
            MemberSignature other = (MemberSignature)object;
            return this.name.equals(other.name) && this.signature.equals(other.signature) && this.modifiers == other.modifiers;
        }
        catch (ClassCastException | NullPointerException ignored) {
            return false;
        }
    }

    public static MemberSignature getAssertionsDisabledFieldMemberSignature() {
        return ASSERTIONS_DISABLED_FIELD;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public static MemberSignature getPackagePrivateConstructor() {
        return PACKAGE_PRIVATE_CONSTRUCTOR;
    }

    public static MemberSignature getPublicConstructor() {
        return PUBLIC_CONSTRUCTOR;
    }

    public String getSignature() {
        return this.signature;
    }

    public static MemberSignature getStaticInitializerMemberSignature() {
        return STATIC_INITIALIZER;
    }

    public int hashCode() {
        return this.name.hashCode() + this.signature.hashCode();
    }

    public String toString() {
        return this.name + this.signature;
    }
}

