/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.stream.IntStream;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public class RemoveRedundantPolyadicOperandFix
extends InspectionGadgetsFix {
    private final String myExpressionText;

    public RemoveRedundantPolyadicOperandFix(String expressionText) {
        this.myExpressionText = expressionText;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("remove.redundant.polyadic.operand.fix.name", this.myExpressionText);
        if (string == null) {
            RemoveRedundantPolyadicOperandFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("remove.redundant.polyadic.operand.fix.family.name", new Object[0]);
        if (string == null) {
            RemoveRedundantPolyadicOperandFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiElement element = descriptor2.getPsiElement();
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPolyadicExpression.class);
        if (polyadicExpression == null) {
            return;
        }
        Object[] children = polyadicExpression.getChildren();
        int start = IntStreamEx.ofIndices((Object[])children, child -> PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)element, (boolean)false)).findFirst().orElse(-1);
        if (start == -1) {
            return;
        }
        int end = IntStreamEx.range((int)(start + 1), (int)children.length).findFirst(arg_0 -> RemoveRedundantPolyadicOperandFix.lambda$doFix$1((PsiElement[])children, arg_0)).orElse(-1);
        if (end == -1) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        String replacement = IntStreamEx.range((int)0, (int)start).append((IntStream)IntStreamEx.range((int)end, (int)children.length)).elements(children).map(ct::text).joining();
        ct.replaceAndRestoreComments((PsiElement)polyadicExpression, replacement);
    }

    private static /* synthetic */ boolean lambda$doFix$1(PsiElement[] children, int idx) {
        return children[idx] instanceof PsiExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/RemoveRedundantPolyadicOperandFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

