/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressForTestsScopeFix
extends InspectionGadgetsFix {
    private final AbstractBaseJavaLocalInspectionTool myInspection;

    private SuppressForTestsScopeFix(AbstractBaseJavaLocalInspectionTool inspection) {
        this.myInspection = inspection;
    }

    @Nullable
    public static SuppressForTestsScopeFix build(AbstractBaseJavaLocalInspectionTool inspection, PsiElement context) {
        if (!TestUtils.isInTestSourceContent(context)) {
            return null;
        }
        return new SuppressForTestsScopeFix(inspection);
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("suppress.for.tests.scope.quickfix", new Object[0]);
        if (string == null) {
            SuppressForTestsScopeFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void doFix(final Project project, ProblemDescriptor descriptor2) {
        this.addRemoveTestsScope(project, true);
        VirtualFile vFile = descriptor2.getPsiElement().getContainingFile().getVirtualFile();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

            public void undo() {
                SuppressForTestsScopeFix.this.addRemoveTestsScope(project, false);
            }

            public void redo() {
                SuppressForTestsScopeFix.this.addRemoveTestsScope(project, true);
            }
        });
    }

    private void addRemoveTestsScope(Project project, boolean add) {
        String shortName;
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        InspectionToolWrapper tool = profile.getInspectionTool(shortName = this.myInspection.getShortName(), project);
        if (tool == null) {
            return;
        }
        if (add) {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)project, (String)"Tests");
            HighlightDisplayKey key2 = HighlightDisplayKey.find((String)shortName);
            HighlightDisplayLevel level = profile.getErrorLevel(key2, namedScope, project);
            profile.addScope(tool, namedScope, level, false, project);
        } else {
            profile.removeScope(shortName, "Tests", project);
        }
        profile.scopesChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/SuppressForTestsScopeFix", "getFamilyName"));
    }
}

