/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitDefaultCharsetUsageInspection
extends BaseInspection {
    private static final Key<CharsetOverload> HAS_CHARSET_OVERLOAD = Key.create((String)"Method has Charset overload");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.display.name", new Object[0]);
        if (string == null) {
            ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos[0] instanceof PsiNewExpression) {
            String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.problem.descriptor", new Object[0]);
        if (string == null) {
            ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static CharsetOverload getCharsetOverload(PsiMethod method) {
        if (method == null) {
            CharsetOverload charsetOverload = CharsetOverload.NONE;
            if (charsetOverload == null) {
                ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(3);
            }
            return charsetOverload;
        }
        CharsetOverload charsetOverload = (CharsetOverload)((Object)method.getUserData(HAS_CHARSET_OVERLOAD));
        if (charsetOverload == null) {
            PsiMethod methodWithCharsetArgument = null;
            PsiClass aClass = method.getContainingClass();
            charsetOverload = CharsetOverload.EXIST;
            if (aClass != null) {
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                PsiClassType charsetType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeByFQClassName("java.nio.charset.Charset", method.getResolveScope());
                Object[] parameterTypes = signature.getParameterTypes();
                if (method.isConstructor() && "java.io.PrintWriter".equals(aClass.getQualifiedName()) && parameterTypes.length == 1 && parameterTypes[0].equalsToText("java.io.OutputStream")) {
                    parameterTypes = (PsiType[])ArrayUtil.append((Object[])parameterTypes, (Object)PsiType.BOOLEAN);
                    charsetOverload = CharsetOverload.EXIST_WITH_FALSE;
                }
                MethodSignature newSignature = MethodSignatureUtil.createMethodSignature((String)signature.getName(), (PsiType[])((PsiType[])ArrayUtil.append((Object[])parameterTypes, (Object)charsetType)), (PsiTypeParameter[])signature.getTypeParameters(), (PsiSubstitutor)signature.getSubstitutor(), (boolean)signature.isConstructor());
                methodWithCharsetArgument = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)newSignature, (boolean)false);
            }
            if (methodWithCharsetArgument == null) {
                charsetOverload = CharsetOverload.NONE;
            }
            method.putUserData(HAS_CHARSET_OVERLOAD, (Object)charsetOverload);
        }
        CharsetOverload charsetOverload2 = charsetOverload;
        if (charsetOverload2 == null) {
            ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(4);
        }
        return charsetOverload2;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiCallExpression call = (PsiCallExpression)infos[0];
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)call)) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        return ImplicitDefaultCharsetUsageInspection.getCharsetOverload(method).createFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitDefaultCharsetUsageVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/internationalization/ImplicitDefaultCharsetUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsetOverload";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AddUtf8CharsetFix
    extends InspectionGadgetsFix {
        private final CharsetOverload myCharsetOverload;

        private AddUtf8CharsetFix(CharsetOverload charsetOverload) {
            this.myCharsetOverload = charsetOverload;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiCallExpression call = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), PsiCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpressionList arguments = call.getArgumentList();
            if (arguments == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            this.myCharsetOverload.additionalArguments().map(arg -> factory.createExpressionFromText(arg, (PsiElement)call)).forEach(arg_0 -> ((PsiExpressionList)arguments).add(arg_0));
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)arguments);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.fix.family.name", new Object[0]);
            if (string == null) {
                AddUtf8CharsetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/ImplicitDefaultCharsetUsageInspection$AddUtf8CharsetFix", "getFamilyName"));
        }
    }

    private static class ImplicitDefaultCharsetUsageVisitor
    extends BaseInspectionVisitor {
        private ImplicitDefaultCharsetUsageVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name2 = methodExpression.getReferenceName();
            if (!"getBytes".equals(name2)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 1) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String qName = aClass.getQualifiedName();
            if (!"java.lang.String".equals(qName)) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiMethod constructor = expression2.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (aClass == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            int count = parameterList.getParametersCount();
            if (count == 0) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            String qName = aClass.getQualifiedName();
            if ("java.lang.String".equals(qName)) {
                if (!parameters2[0].getType().equalsToText("byte[]") || ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[count - 1])) {
                    return;
                }
            } else if ("java.io.InputStreamReader".equals(qName) || "java.io.OutputStreamWriter".equals(qName) || "java.io.PrintStream".equals(qName)) {
                if (ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[count - 1])) {
                    return;
                }
            } else if ("java.io.PrintWriter".equals(qName)) {
                if (count > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[count - 1]) || parameters2[0].getType().equalsToText("java.io.Writer")) {
                    return;
                }
            } else if ("java.util.Formatter".equals(qName)) {
                if (count > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[1])) {
                    return;
                }
                PsiType firstType = parameters2[0].getType();
                if (!(firstType.equalsToText("java.lang.String") || firstType.equalsToText("java.io.File") || firstType.equalsToText("java.io.OutputStream"))) {
                    return;
                }
            } else if ("java.util.Scanner".equals(qName)) {
                if (count > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[1])) {
                    return;
                }
                PsiType firstType = parameters2[0].getType();
                if (!(firstType.equalsToText("java.io.InputStream") || firstType.equalsToText("java.io.File") || firstType.equalsToText("java.nio.file.Path") || firstType.equalsToText("java.nio.channels.ReadableByteChannel"))) {
                    return;
                }
            } else if (!"java.io.FileReader".equals(qName) && !"java.io.FileWriter".equals(qName)) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2);
        }

        private static boolean hasCharsetType(PsiVariable variable) {
            return TypeUtils.variableHasTypeOrSubtype(variable, "java.lang.String", "java.nio.charset.Charset", "java.nio.charset.CharsetEncoder", "java.nio.charset.CharsetDecoder");
        }
    }

    static enum CharsetOverload {
        EXIST,
        EXIST_WITH_FALSE,
        NONE;


        InspectionGadgetsFix createFix() {
            return this == NONE ? null : new AddUtf8CharsetFix(this);
        }

        Stream<String> additionalArguments() {
            switch (this) {
                case EXIST: {
                    return Stream.of("java.nio.charset.StandardCharsets.UTF_8");
                }
                case EXIST_WITH_FALSE: {
                    return Stream.of("false", "java.nio.charset.StandardCharsets.UTF_8");
                }
            }
            throw new IllegalStateException(this.toString());
        }
    }
}

