/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HtmlTagCanBeJavadocTagInspection
extends BaseInspection {
    private static final Pattern START_TAG_PATTERN = Pattern.compile("<([a-zA-Z])+([^>])*>");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("html.tag.can.be.javadoc.tag.display.name", new Object[0]);
        if (string == null) {
            HtmlTagCanBeJavadocTagInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("html.tag.can.be.javadoc.tag.problem.descriptor", new Object[0]);
        if (string == null) {
            HtmlTagCanBeJavadocTagInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new HtmlTagCanBeJavaDocTagFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HtmlTagCanBeJavaDocTagVisitor();
    }

    static boolean containsHtmlTag(String text2, int startIndex, int endIndex) {
        Matcher matcher = START_TAG_PATTERN.matcher(text2);
        if (matcher.find(startIndex)) {
            return matcher.start() < endIndex;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class HtmlTagCanBeJavaDocTagVisitor
    extends BaseInspectionVisitor {
        private HtmlTagCanBeJavaDocTagVisitor() {
        }

        public void visitDocToken(PsiDocToken token) {
            super.visitDocToken(token);
            IElementType tokenType = token.getTokenType();
            if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType)) {
                return;
            }
            String text2 = token.getText();
            int startIndex = 0;
            while ((startIndex = StringUtil.indexOfIgnoreCase((String)text2, (String)"<code>", (int)startIndex)) >= 0) {
                if (HtmlTagCanBeJavaDocTagVisitor.hasMatchingCloseTag((PsiElement)token, startIndex + 6)) {
                    this.registerErrorAtOffset((PsiElement)token, startIndex, 6, new Object[0]);
                }
                ++startIndex;
            }
            return;
        }

        private static boolean hasMatchingCloseTag(PsiElement element, int offset) {
            int balance = 0;
            while (element != null) {
                int end;
                String text2 = element.getText();
                int endIndex = StringUtil.indexOfIgnoreCase((String)text2, (String)"</code>", (int)offset);
                int n = end = endIndex >= 0 ? endIndex : text2.length();
                if (text2.equals("{")) {
                    ++balance;
                } else if (text2.equals("}") && --balance < 0) {
                    return false;
                }
                if (HtmlTagCanBeJavadocTagInspection.containsHtmlTag(text2, offset, end)) {
                    return false;
                }
                if (endIndex >= 0) {
                    return balance == 0;
                }
                offset = 0;
                if (!((element = element.getNextSibling()) instanceof PsiInlineDocTag)) continue;
                return false;
            }
            return false;
        }
    }

    private static class HtmlTagCanBeJavaDocTagFix
    extends InspectionGadgetsFix {
        private HtmlTagCanBeJavaDocTagFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("html.tag.can.be.javadoc.tag.quickfix", new Object[0]);
            if (string == null) {
                HtmlTagCanBeJavaDocTagFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            TextRange range = descriptor2.getTextRangeInElement();
            PsiElement element = descriptor2.getPsiElement();
            PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFile.class);
            if (file == null) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) {
                return;
            }
            int startOffset = range.getStartOffset();
            int replaceStartOffset = element.getTextOffset() + startOffset;
            int startTag = range.getEndOffset();
            String text2 = element.getText();
            if (!"<code>".equalsIgnoreCase(text2.substring(startOffset, startTag))) {
                return;
            }
            StringBuilder newCommentText = new StringBuilder("{@code");
            int endTag = StringUtil.indexOfIgnoreCase((String)text2, (String)"</code>", (int)startTag);
            while (endTag < 0) {
                HtmlTagCanBeJavaDocTagFix.appendElementText(text2, startTag, text2.length(), newCommentText);
                element = element.getNextSibling();
                if (element == null) {
                    return;
                }
                startTag = 0;
                text2 = element.getText();
                endTag = StringUtil.indexOfIgnoreCase((String)text2, (String)"</code>", (int)0);
            }
            HtmlTagCanBeJavaDocTagFix.appendElementText(text2, startTag, endTag, newCommentText);
            newCommentText.append('}');
            int replaceEndOffset = element.getTextOffset() + endTag + 7;
            String oldText = document.getText(new TextRange(replaceStartOffset, replaceEndOffset));
            if (!StringUtil.startsWithIgnoreCase((String)oldText, (String)"<code>") || !StringUtil.endsWithIgnoreCase((String)oldText, (String)"</code>")) {
                return;
            }
            document.replaceString(replaceStartOffset, replaceEndOffset, (CharSequence)newCommentText);
        }

        private static void appendElementText(String text2, int startOffset, int endOffset, StringBuilder out) {
            if (out.length() == "{@code".length() && endOffset - startOffset > 0 && !Character.isWhitespace(text2.charAt(startOffset))) {
                out.append(' ');
            }
            String s = text2.substring(startOffset, endOffset);
            out.append(StringUtil.unescapeXml((String)s));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection$HtmlTagCanBeJavaDocTagFix", "getFamilyName"));
        }
    }
}

