/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit4AnnotatedMethodInJUnit3TestCaseInspection
extends BaseInspection {
    protected static final String IGNORE = "org.junit.Ignore";

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>(3);
        PsiMethod method = (PsiMethod)infos[1];
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)IGNORE, (int)0)) {
            fixes.add(new RemoveIgnoreAndRename(method));
        }
        if (TestUtils.isJUnit4TestMethod(method)) {
            String newMethodName;
            String methodName = method.getName();
            if (methodName.startsWith("test")) {
                newMethodName = null;
            } else {
                boolean lowCaseStyle = methodName.contains("_");
                newMethodName = "test" + (lowCaseStyle ? "_" + methodName : StringUtil.capitalize((String)methodName));
            }
            fixes.add(new RemoveTestAnnotationFix(newMethodName));
        }
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        fixes.add(new ConvertToJUnit4Fix(className));
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            JUnit4AnnotatedMethodInJUnit3TestCaseInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit4.test.method.in.class.extending.junit3.testcase.display.name", new Object[0]);
        if (string == null) {
            JUnit4AnnotatedMethodInJUnit3TestCaseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)infos[1]), (String)IGNORE, (int)0)) {
            String string = InspectionGadgetsBundle.message("ignore.test.method.in.class.extending.junit3.testcase.problem.descriptor", new Object[0]);
            if (string == null) {
                JUnit4AnnotatedMethodInJUnit3TestCaseInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("junit4.test.method.in.class.extending.junit3.testcase.problem.descriptor", new Object[0]);
        if (string == null) {
            JUnit4AnnotatedMethodInJUnit3TestCaseInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Junit4AnnotatedMethodInJunit3TestCaseVisitor();
    }

    private static void deleteAnnotation(ProblemDescriptor descriptor2, String qualifiedName) {
        PsiElement element = descriptor2.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiModifierListOwner)) {
            return;
        }
        PsiModifierListOwner method = (PsiModifierListOwner)parent;
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiAnnotation annotation = modifierList.findAnnotation(qualifiedName);
        if (annotation == null) {
            return;
        }
        annotation.delete();
    }

    public static void convertJUnit3ClassToJUnit4(PsiClass containingClass) {
        PsiJavaCodeReferenceElement[] referenceElements;
        if (containingClass == null) {
            return;
        }
        PsiReferenceList extendsList = containingClass.getExtendsList();
        if (extendsList == null) {
            return;
        }
        for (PsiMethod method : containingClass.getMethods()) {
            String name2 = method.getName();
            if (!method.hasModifierProperty("static") && PsiType.VOID.equals((Object)method.getReturnType()) && method.getParameterList().isEmpty()) {
                PsiModifierList modifierList = method.getModifierList();
                if (name2.startsWith("test")) {
                    JUnit4AnnotatedMethodInJUnit3TestCaseInspection.addAnnotationIfNotPresent(modifierList, "org.junit.Test");
                } else if (name2.equals("setUp")) {
                    JUnit4AnnotatedMethodInJUnit3TestCaseInspection.transformSetUpOrTearDownMethod(method);
                    JUnit4AnnotatedMethodInJUnit3TestCaseInspection.addAnnotationIfNotPresent(modifierList, "org.junit.Before");
                } else if (name2.equals("tearDown")) {
                    JUnit4AnnotatedMethodInJUnit3TestCaseInspection.transformSetUpOrTearDownMethod(method);
                    JUnit4AnnotatedMethodInJUnit3TestCaseInspection.addAnnotationIfNotPresent(modifierList, "org.junit.After");
                }
            }
            method.accept((PsiElementVisitor)new MethodCallModifier());
        }
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
            referenceElement.delete();
        }
    }

    private static void addAnnotationIfNotPresent(PsiModifierList modifierList, String qualifiedAnnotationName) {
        if (modifierList.hasAnnotation(qualifiedAnnotationName)) {
            return;
        }
        PsiAnnotation annotation = modifierList.addAnnotation(qualifiedAnnotationName);
        Project project = modifierList.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        codeStyleManager.shortenClassReferences((PsiElement)annotation);
    }

    private static void transformSetUpOrTearDownMethod(PsiMethod method) {
        PsiAnnotation overrideAnnotation;
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList.hasModifierProperty("protected")) {
            modifierList.setModifierProperty("protected", false);
        }
        if (!modifierList.hasModifierProperty("public")) {
            modifierList.setModifierProperty("public", true);
        }
        if ((overrideAnnotation = modifierList.findAnnotation("java.lang.Override")) != null) {
            overrideAnnotation.delete();
        }
        method.accept((PsiElementVisitor)new SuperLifeCycleCallRemover(method.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Junit4AnnotatedMethodInJunit3TestCaseVisitor
    extends BaseInspectionVisitor {
        private Junit4AnnotatedMethodInJunit3TestCaseVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!TestUtils.isJUnitTestClass(containingClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)containingClass, (String)"org.junit.runner.RunWith", (int)1)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)JUnit4AnnotatedMethodInJUnit3TestCaseInspection.IGNORE, (int)0) && method.getName().startsWith("test") || TestUtils.isJUnit4TestMethod(method)) {
                this.registerMethodError(method, containingClass, method);
            }
        }
    }

    private static class RemoveTestAnnotationFix
    extends RenameFix {
        private final String myNewName;

        RemoveTestAnnotationFix(String newName) {
            super(newName);
            this.myNewName = newName;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("remove.junit4.test.annotation.quickfix", new Object[0]);
            if (string == null) {
                RemoveTestAnnotationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myNewName == null ? this.getFamilyName() : InspectionGadgetsBundle.message("remove.junit4.test.annotation.and.rename.quickfix", this.myNewName);
            if (string == null) {
                RemoveTestAnnotationFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                RemoveTestAnnotationFix.$$$reportNull$$$0(2);
            }
            return currentFile;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            WriteAction.run(() -> JUnit4AnnotatedMethodInJUnit3TestCaseInspection.deleteAnnotation(descriptor2, "org.junit.Test"));
            if (this.myNewName != null) {
                super.doFix(project, descriptor2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$RemoveTestAnnotationFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$RemoveTestAnnotationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MethodCallModifier
    extends JavaRecursiveElementVisitor {
        private MethodCallModifier() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            if (methodExpression.getQualifierExpression() != null) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null || !method.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String name2 = aClass.getQualifiedName();
            if (!"junit.framework.Assert".equals(name2) && !"junit.framework.TestCase".equals(name2)) {
                return;
            }
            String newExpressionText = "org.junit.Assert." + expression2.getText();
            Project project = expression2.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression2);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            PsiElement replacedExpression = expression2.replace((PsiElement)newExpression);
            codeStyleManager.shortenClassReferences(replacedExpression);
        }
    }

    private static class SuperLifeCycleCallRemover
    extends JavaRecursiveElementVisitor {
        @NotNull
        private final String myLifeCycleMethodName;

        private SuperLifeCycleCallRemover(@NotNull String lifeCycleMethodName) {
            if (lifeCycleMethodName == null) {
                SuperLifeCycleCallRemover.$$$reportNull$$$0(0);
            }
            this.myLifeCycleMethodName = lifeCycleMethodName;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!this.myLifeCycleMethodName.equals(methodName)) {
                return;
            }
            PsiExpression target = methodExpression.getQualifierExpression();
            if (!(target instanceof PsiSuperExpression)) {
                return;
            }
            expression2.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lifeCycleMethodName", "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$SuperLifeCycleCallRemover", "<init>"));
        }
    }

    private static class ConvertToJUnit4Fix
    extends InspectionGadgetsFix {
        private final String className;

        ConvertToJUnit4Fix(String className) {
            this.className = className;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("convert.junit3.test.class.quickfix", this.className);
            if (string == null) {
                ConvertToJUnit4Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Convert JUnit 3 class to JUnit 4" == null) {
                ConvertToJUnit4Fix.$$$reportNull$$$0(1);
            }
            return "Convert JUnit 3 class to JUnit 4";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMember)) {
                return;
            }
            PsiMember member = (PsiMember)parent;
            PsiClass containingClass = member.getContainingClass();
            JUnit4AnnotatedMethodInJUnit3TestCaseInspection.convertJUnit3ClassToJUnit4(containingClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$ConvertToJUnit4Fix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class RemoveIgnoreAndRename
    extends RenameFix {
        RemoveIgnoreAndRename(@NonNls PsiMethod method) {
            super("_" + method.getName());
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("ignore.test.method.in.class.extending.junit3.testcase.quickfix", this.getTargetName());
            if (string == null) {
                RemoveIgnoreAndRename.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                RemoveIgnoreAndRename.$$$reportNull$$$0(1);
            }
            return currentFile;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            WriteAction.run(() -> JUnit4AnnotatedMethodInJUnit3TestCaseInspection.deleteAnnotation(descriptor2, JUnit4AnnotatedMethodInJUnit3TestCaseInspection.IGNORE));
            super.doFix(project, descriptor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$RemoveIgnoreAndRename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$RemoveIgnoreAndRename";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

